/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.device.interpret.util;

import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.comm.ICommunicateManager;
import com.owon.uppersoft.vds.core.comm.effect.JobUnitDealer;
import com.owon.uppersoft.vds.core.comm.job.JobUnit_I;
import com.owon.uppersoft.vds.device.interpret.CMDResponser;
import com.owon.uppersoft.vds.device.interpret.util.PackUtil2;
import com.owon.vds.firm.protocol.AddValueAttachCommand;
import com.owon.vds.firm.protocol.AddressAttachCommand;

public class Sendable {
    public static final String SEND_CMD2_RESPONSE = "sendCMD2_response";
    public static final String SEND_CMD_RESPONSE = "sendCMD_response";
    private JobUnitDealer st;
    private Logable vl;

    public Sendable(JobUnitDealer jobUnitDealer, Logable logable) {
        this.st = jobUnitDealer;
        this.vl = logable;
    }

    public Sendable(JobUnitDealer jobUnitDealer) {
        this(jobUnitDealer, new VLog());
    }

    public void sendCMD(AddressAttachCommand addressAttachCommand, int n, CMDResponser cMDResponser) {
        int n2 = addressAttachCommand.address;
        int n3 = addressAttachCommand.bytes;
        this.sendCMD(n2, n3, n, addressAttachCommand.name, cMDResponser);
    }

    public void sendCMDbyBytes(AddressAttachCommand addressAttachCommand, int n, CMDResponser cMDResponser) {
        int n2 = addressAttachCommand.address;
        int n3 = addressAttachCommand.bytes;
        this.sendCMD(n2, n3, n, addressAttachCommand.toString(), cMDResponser);
    }

    public String getHex(int n) {
        return Integer.toHexString(n);
    }

    public void sendCMD(int n, int n2, int n3, CMDResponser cMDResponser) {
        this.sendCMD(n, n2, n3, "", cMDResponser);
    }

    public void sendCMD(AddValueAttachCommand addValueAttachCommand, CMDResponser cMDResponser) {
        this.sendCMD(addValueAttachCommand.address, addValueAttachCommand.bytes, addValueAttachCommand.value, "", cMDResponser);
    }

    public JobUnit_I prepareCMD(AddressAttachCommand addressAttachCommand, int n, String string, CMDResponser cMDResponser) {
        int n2 = addressAttachCommand.address;
        int n3 = addressAttachCommand.bytes;
        return this.prepareCMD(n2, n3, n, string, cMDResponser);
    }

    public JobUnit_I prepareCMD(int n, int n2, int n3, String string, final CMDResponser cMDResponser) {
        byte[] byArray = PackUtil2.packCMD(n, n2, n3);
        int n4 = 5;
        final byte[] byArray2 = new byte[n4];
        JobUnit_I jobUnit_I = new JobUnit_I(byArray, byArray2){

            @Override
            protected void init() {
            }

            @Override
            protected void prepareJob() {
            }

            @Override
            protected void afterJob(ICommunicateManager iCommunicateManager) {
                if (cMDResponser != null) {
                    cMDResponser.onResponse(byArray2, this.resNum, Sendable.this.vl);
                }
            }
        };
        return jobUnit_I;
    }

    public void sendCMD(int n, int n2, int n3, String string, CMDResponser cMDResponser) {
        JobUnit_I jobUnit_I = this.prepareCMD(n, n2, n3, string, cMDResponser);
        this.st.addJobUnit(jobUnit_I);
    }

    public void sendCMD2(int n, int n2, final CMDResponser cMDResponser) {
        byte[] byArray = PackUtil2.packCMD2(n, n2);
        int n3 = 5;
        final byte[] byArray2 = new byte[n3];
        JobUnit_I jobUnit_I = new JobUnit_I(byArray, byArray2){

            @Override
            protected void init() {
            }

            @Override
            protected void afterJob(ICommunicateManager iCommunicateManager) {
                if (cMDResponser != null) {
                    cMDResponser.onResponse(byArray2, this.resNum, Sendable.this.vl);
                }
            }
        };
        this.st.addJobUnit(jobUnit_I);
    }

    public static String getCommmandLog(AddressAttachCommand addressAttachCommand, int n) {
        return "[Send " + addressAttachCommand.name + " 0x" + Integer.toHexString(n) + "]";
    }

    public static String getCommmandLogResponse(byte[] byArray, int n) {
        char c = (char)byArray[0];
        int n2 = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 24;
        return " recv: " + c + " 0x" + Integer.toHexString(n2);
    }

    public static int writeCommmand(ICommunicateManager iCommunicateManager, AddressAttachCommand addressAttachCommand, int n) {
        byte[] byArray = PackUtil2.packCMD(addressAttachCommand, n);
        return iCommunicateManager.write(byArray, byArray.length);
    }

    public static int writeCommmand(ICommunicateManager iCommunicateManager, AddValueAttachCommand addValueAttachCommand) {
        byte[] byArray = PackUtil2.packCMD(addValueAttachCommand);
        return iCommunicateManager.write(byArray, byArray.length);
    }

    public static int interCommmands(ICommunicateManager iCommunicateManager, AddValueAttachCommand addValueAttachCommand, byte[] byArray, Logable logable) {
        int n;
        int n2 = addValueAttachCommand.address;
        int n3 = addValueAttachCommand.bytes;
        int n4 = addValueAttachCommand.value;
        byte[] byArray2 = PackUtil2.packCMD(n2, n3, n4);
        int n5 = iCommunicateManager.write(byArray2, n = byArray2.length);
        if (n5 < n) {
            return -1;
        }
        int n6 = iCommunicateManager.acceptResponse(byArray, byArray.length);
        return n6;
    }
}

