/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.device.interpret;

import com.owon.uppersoft.vds.core.comm.BufferredSourceManager;
import com.owon.uppersoft.vds.core.comm.effect.JobUnitDealer;
import com.owon.uppersoft.vds.core.comm.job.JobUnit;
import com.owon.uppersoft.vds.device.interpret.util.DefaultCMDResponser;
import com.owon.uppersoft.vds.device.interpret.util.Sendable;
import com.owon.uppersoft.vds.tool.simple.UsbCommunicator;
import com.owon.uppersoft.vds.ui.layout.OneColumnLayout;
import com.owon.vds.tiny.firm.DeviceFlashCommunicator;
import com.owon.vds.tiny.firm.pref.DefaultPrefControl;
import com.owon.vds.tiny.firm.pref.PrefSync;
import com.owon.vds.tiny.tune.TinyTuneFunction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class Tune2
implements PropertyChangeListener {
    public static final String APPEND_TXTLINE2 = "APPEND_TXTLINE2";
    private TinyTuneFunction tf;
    private JTextArea consoleArea;
    private UsbCommunicator um;
    private JLabel trglbl;

    public Tune2(Window window, final PropertyChangeSupport propertyChangeSupport, TinyTuneFunction tinyTuneFunction) {
        this.tf = tinyTuneFunction;
        JDialog jDialog = new JDialog(window);
        jDialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jDialog.add((Component)jPanel, "Center");
        this.CreateSouthPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jDialog.add((Component)jPanel2, "North");
        jPanel2.setLayout(new OneColumnLayout());
        this.CreateAddrPanel(jPanel2);
        this.CreateHexPanel(jPanel2);
        jDialog.pack();
        jDialog.setSize(1300, 600);
        jDialog.setLocationRelativeTo(window);
        jDialog.setVisible(true);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                propertyChangeSupport.removePropertyChangeListener(Tune2.this);
            }
        });
        propertyChangeSupport.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("APPEND_TXTLINE")) {
            Object object = propertyChangeEvent.getNewValue();
            this.addTextLine(object);
        } else if (string.equals("APPEND_TXT")) {
            Object object = propertyChangeEvent.getNewValue();
            this.addText(object);
        } else if (string.equals(APPEND_TXTLINE2)) {
            Object object = propertyChangeEvent.getNewValue();
            this.trglbl.setText(object.toString());
        }
    }

    private void CreateSouthPane(JPanel jPanel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(800, 200));
        jScrollPane.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 10, 10), new LineBorder(Color.black, 1, false)));
        this.consoleArea = new JTextArea();
        this.consoleArea.setLineWrap(true);
        this.consoleArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(this.consoleArea);
        jPanel.add((Component)jScrollPane, "Center");
    }

    private void CreateAddrPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel.add((Component)jPanel2, "South");
        JLabel jLabel = new JLabel("addr 0x");
        jPanel2.add(jLabel);
        final JTextField jTextField = new JTextField();
        jPanel2.add(jTextField);
        jTextField.setColumns(6);
        JLabel jLabel2 = new JLabel("bytes 0x");
        jPanel2.add(jLabel2);
        final JTextField jTextField2 = new JTextField();
        jPanel2.add(jTextField2);
        jTextField2.setColumns(6);
        JLabel jLabel3 = new JLabel("value 0x");
        jPanel2.add(jLabel3);
        final JTextField jTextField3 = new JTextField();
        jPanel2.add(jTextField3);
        jTextField3.setColumns(6);
        JButton jButton = new JButton("Send");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobUnitDealer jobUnitDealer = Tune2.this.getJobUnitDealer();
                Sendable sendable = new Sendable(jobUnitDealer);
                int n = Tune2.this.getInt(jTextField);
                int n2 = Tune2.this.getInt(jTextField2);
                int n3 = Tune2.this.getInt(jTextField3);
                sendable.sendCMD(n, n2, n3, null);
                Tune2.this.addTextLine("[Send: ]" + Integer.toHexString(n) + ", " + Integer.toHexString(n2) + ", " + Integer.toHexString(n3));
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Reload txt");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tune2.this.tf.createTuneTexter().resetup();
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton("Clear");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tune2.this.consoleArea.setText(null);
            }
        });
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton("t");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tune2.this.um == null || !Tune2.this.um.getFrame().isDisplayable()) {
                    Tune2.this.um = new UsbCommunicator();
                }
            }
        });
        jPanel2.add(jButton4);
        JButton jButton5 = new JButton("read flash");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobUnitDealer jobUnitDealer = Tune2.this.getJobUnitDealer();
                jobUnitDealer.addJobUnit(new JobUnit(){

                    @Override
                    public void doJob(BufferredSourceManager bufferredSourceManager) {
                        DeviceFlashCommunicator deviceFlashCommunicator = new DeviceFlashCommunicator();
                        byte[] byArray = deviceFlashCommunicator.fetchPrefernce(bufferredSourceManager, false);
                        DefaultPrefControl defaultPrefControl = Tune2.this.tf.getDefaultPrefControl();
                        defaultPrefControl.loadSyncImageFromDevice(byArray);
                    }

                    @Override
                    public String getName() {
                        return "fetch flash";
                    }

                    @Override
                    public boolean merge(JobUnit jobUnit) {
                        return false;
                    }
                });
            }
        });
        jPanel2.add(jButton5);
        JLabel jLabel4 = new JLabel("n: 0x");
        jPanel2.add(jLabel4);
        final JTextField jTextField4 = new JTextField("0");
        jPanel2.add(jTextField4);
        jTextField4.setColumns(4);
        String[] stringArray = new String[]{"all n", "i*60", "(0~59)...", "random"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jPanel2.add(jComboBox);
        JButton jButton6 = new JButton("write flash");
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobUnitDealer jobUnitDealer = Tune2.this.getJobUnitDealer();
                int n = jComboBox.getSelectedIndex();
                String string = jTextField4.getText();
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                byte[] byArray = Tune2.prepareDevPref(n, n2);
                new PrefSync().sendPrefernce_Write(byArray, jobUnitDealer);
            }
        });
        jPanel2.add(jButton6);
    }

    public JobUnitDealer getJobUnitDealer() {
        return this.tf.getTinyTuneDelegate().getJobUnitDealer();
    }

    public static byte[] prepareDevPref(int n, int n2) {
        int n3 = 2002;
        byte[] byArray = new byte[n3];
        switch (n) {
            case 3: {
                Random random = new Random();
                int n4 = 0;
                int n5 = 0;
                while (n4 < n3) {
                    byArray[n4] = (byte)random.nextInt(256);
                    ++n4;
                    ++n5;
                }
                break;
            }
            case 2: {
                int n6 = 0;
                int n7 = 0;
                while (n6 < n3) {
                    byArray[n6] = (byte)(n6 % 60);
                    ++n6;
                    ++n7;
                }
                break;
            }
            case 1: {
                int n8 = 0;
                int n9 = 0;
                while (n8 < n3) {
                    byArray[n8] = (byte)(n8 / 60);
                    ++n8;
                    ++n9;
                }
                break;
            }
            case 0: {
                int n10 = 0;
                int n11 = 0;
                while (n10 < n3) {
                    byArray[n10] = (byte)n2;
                    ++n10;
                    ++n11;
                }
                break;
            }
        }
        return byArray;
    }

    public int getInt(JTextField jTextField) {
        return Integer.parseInt(jTextField.getText(), 16);
    }

    private void CreateHexPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3));
        jPanel.add((Component)jPanel2, "South");
        JLabel jLabel = new JLabel(" HEX byte 0x");
        jPanel2.add(jLabel);
        final JTextField jTextField = new JTextField();
        jTextField.setColumns(5);
        jPanel2.add(jTextField);
        JLabel jLabel2 = new JLabel(" HEX Int ");
        jPanel2.add(jLabel2);
        final JTextField jTextField2 = new JTextField();
        jTextField2.setColumns(6);
        jPanel2.add(jTextField2);
        JButton jButton = new JButton("Send");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobUnitDealer jobUnitDealer = Tune2.this.getJobUnitDealer();
                Sendable sendable = new Sendable(jobUnitDealer);
                int n = Tune2.this.getInt(jTextField);
                int n2 = Tune2.this.getInt(jTextField2);
                sendable.sendCMD2(n, n2, new DefaultCMDResponser());
                Tune2.this.addTextLine("[Send: ]" + Integer.toHexString(n) + ", " + Integer.toHexString(n2));
            }
        });
        jPanel2.add(jButton);
        this.trglbl = new JLabel();
        jPanel2.add(this.trglbl);
        this.trglbl.setPreferredSize(new Dimension(300, 30));
    }

    private void addText(Object object) {
        this.consoleArea.append(object.toString());
        this.consoleArea.setCaretPosition(this.consoleArea.getDocument().getLength());
    }

    private void addTextLine(Object object) {
        this.consoleArea.append(object.toString());
        this.consoleArea.append("\r\n");
        this.consoleArea.setCaretPosition(this.consoleArea.getDocument().getLength());
    }
}

