/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.device.interpolate.dynamic;

import com.owon.uppersoft.vds.core.wf.rt.PlugInfo;
import com.owon.uppersoft.vds.device.interpolate.TinyPlugHelper;
import com.owon.uppersoft.vds.device.interpolate.dynamic.DynamicPlugUtil;
import com.owon.uppersoft.vds.device.interpolate.dynamic.SineTables;
import java.nio.ByteBuffer;

public class DynamicPlugHelper
extends TinyPlugHelper {
    private static final int FULLSCREEN_400 = 400;
    private ByteBuffer[] temp;
    private ByteBuffer[] trgs;

    public DynamicPlugHelper(int n) {
        this.temp = new ByteBuffer[n];
        this.trgs = new ByteBuffer[n];
    }

    private ByteBuffer allocate(boolean bl, int n, int n2) {
        ByteBuffer[] byteBufferArray;
        ByteBuffer[] byteBufferArray2 = byteBufferArray = bl ? this.trgs : this.temp;
        if (n2 < 0 || n2 >= byteBufferArray.length) {
            System.err.println("err DynamicPlugHelper allocate chl: " + n2 + ", len: " + n + ", forTrg: " + bl);
            return null;
        }
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer == null) {
            byteBuffer = byteBufferArray[n2] = ByteBuffer.allocate(12000);
        }
        byteBuffer.position(0);
        byteBuffer.limit(n);
        return byteBuffer;
    }

    @Override
    protected ByteBuffer plugJob(int n, ByteBuffer byteBuffer, PlugInfo plugInfo, boolean bl, int n2) {
        ByteBuffer byteBuffer2 = null;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        int n5 = n4 - n3;
        byte[] byArray = byteBuffer.array();
        int n6 = (int)this.getPlugRate(n);
        this.logln("plugrate: " + n6);
        if (n == 400) {
            byteBuffer2 = DynamicPlugHelper.lineplug2_5(byteBuffer);
            plugInfo.sinePlugRate = 1;
            plugInfo.linearPlugRate = 2.5;
        } else {
            int n7 = n5 * n6;
            ByteBuffer byteBuffer3 = this.allocate(bl, n7, n2);
            byte[] byArray2 = byteBuffer3.array();
            int[][] nArray = SineTables.sincTabSp(n6);
            if (nArray == null) {
                return this.doLineJob(n, n6, byteBuffer, plugInfo);
            }
            DynamicPlugUtil.sinc_interps(byArray, n3, n4, byArray2, n6, nArray);
            byteBuffer2 = ByteBuffer.wrap(byArray2, 0, n7);
            plugInfo.sinePlugRate = n6;
            plugInfo.linearPlugRate = 1.0;
        }
        return byteBuffer2;
    }

    private ByteBuffer doLineJob(int n, int n2, ByteBuffer byteBuffer, PlugInfo plugInfo) {
        ByteBuffer byteBuffer2 = null;
        switch (n) {
            case 400: {
                byteBuffer2 = DynamicPlugHelper.lineplug2_5(byteBuffer);
                plugInfo.sinePlugRate = 1;
                plugInfo.linearPlugRate = 2.5;
                break;
            }
            case 10: 
            case 20: 
            case 40: 
            case 100: 
            case 200: {
                byteBuffer2 = DynamicPlugHelper.lineplug(byteBuffer, n2);
                plugInfo.sinePlugRate = 1;
                plugInfo.linearPlugRate = n2;
            }
        }
        return byteBuffer2;
    }

    @Override
    public double getPlugRate(int n) {
        switch (n) {
            case 400: {
                return 2.5;
            }
            case 200: {
                return 5.0;
            }
            case 100: {
                return 10.0;
            }
            case 40: {
                return 25.0;
            }
            case 20: {
                return 50.0;
            }
            case 10: {
                return 100.0;
            }
        }
        return -1.0;
    }
}

