/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.device.interpolate;

import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.nio.ByteBuffer;

public class PlugPullContext
implements Logable {
    private boolean forTrg;
    private int bufferId;
    private ByteBuffer raw_adc;
    private ByteBuffer pluged_adc;
    private int skip;
    private int demand;
    private int basePos;
    private int baseLimit;

    public PlugPullContext(boolean bl, int n) {
        this.forTrg = bl;
        this.bufferId = n;
    }

    public boolean isForTrg() {
        return this.forTrg;
    }

    public int getPlugedBuffer_Id() {
        return this.bufferId;
    }

    public ByteBuffer getRaw_adc() {
        return this.raw_adc;
    }

    public void setRaw_adc(ByteBuffer byteBuffer) {
        this.raw_adc = byteBuffer;
    }

    public ByteBuffer getPluged_adc() {
        return this.pluged_adc;
    }

    public void setPluged_adc(ByteBuffer byteBuffer) {
        this.pluged_adc = byteBuffer;
        this.markRange();
    }

    private void markRange() {
        this.basePos = this.pluged_adc.position();
        this.baseLimit = this.pluged_adc.limit();
        this.logln(SFormatter.UIformat("[LowRange]basePos: %d, baseLimit: %d", this.basePos, this.baseLimit));
    }

    public int getDemand() {
        return this.demand;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getBaseLimit() {
        return this.baseLimit;
    }

    public void arRange() {
        this.pluged_adc.position(this.skip);
        this.pluged_adc.limit(this.skip + this.demand);
    }

    public void markDemandRange(int n, int n2) {
        this.skip = n;
        this.demand = n2;
        this.logln(SFormatter.UIformat("[DemandRange]skip: %d, demand: %d", n, n2));
    }

    protected void limitRange() {
        if (this.skip < this.basePos) {
            this.skip = this.basePos;
        }
        if (this.skip + this.demand > this.baseLimit) {
            this.skip = this.baseLimit - this.demand;
        }
    }

    public void shift(int n) {
        this.skip += n;
        this.logln("shift: " + n + ", new skip: " + this.skip);
        this.limitRange();
        this.arRange();
    }

    @Override
    public void log(Object object) {
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }

    public void logInfo() {
        this.logln(SFormatter.UIformat("[DemandRange]skip: %d, demand: %d", this.skip, this.demand));
        this.logln(SFormatter.UIformat("[LowRange]basePos: %d, baseLimit: %d", this.basePos, this.baseLimit));
    }
}

