/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.data;

import java.awt.Color;

public class RGB {
    public int red;
    public int green;
    public int blue;

    public RGB() {
        this(Color.WHITE);
    }

    public RGB(String string) {
        if (string == null || string.length() != 6) {
            this.setRGB(Color.WHITE);
            return;
        }
        string = string.trim();
        this.red = Integer.parseInt(string.substring(0, 2), 16);
        this.green = Integer.parseInt(string.substring(2, 4), 16);
        this.blue = Integer.parseInt(string.substring(4, 6), 16);
    }

    public RGB(Color color) {
        this.setRGB(color);
    }

    public void setRGB(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
    }

    public RGB(int n, int n2, int n3) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public String toHexString() {
        StringBuilder stringBuilder = new StringBuilder(6);
        String string = Integer.toHexString(this.red);
        if (string.length() == 1) {
            stringBuilder.append(0);
        }
        stringBuilder.append(string);
        string = Integer.toHexString(this.green);
        if (string.length() == 1) {
            stringBuilder.append(0);
        }
        stringBuilder.append(string);
        string = Integer.toHexString(this.blue);
        if (string.length() == 1) {
            stringBuilder.append(0);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        return "(" + this.red + "," + this.green + "," + this.blue + ")";
    }

    public short getRGB565() {
        return (short)(this.red << 8 & 0xF800 | this.green << 3 & 0x7E0 | this.blue >>> 3);
    }

    public static float[] toHSB(int n, float[] fArray) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 0 & 0xFF;
        Color.RGBtoHSB(n2, n3, n4, fArray);
        return fArray;
    }

    public static void main(String[] stringArray) {
        String string = "66cc00";
        System.out.println(new RGB(string).toHexString());
    }
}

