/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.zoom;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.vds.core.aspect.control.ITimeControl;
import com.owon.uppersoft.vds.core.aspect.control.TimeConfProvider;
import com.owon.uppersoft.vds.ui.paint.LineDrawTool;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;

public class AssitControl {
    public static final int MAIN_STATUS = 0;
    public static final int ASSIT_STATUS = 1;
    public static final int ZOOM_STATUS = 2;
    public static final int NO_STATUS = -1;
    public static boolean FastMWstwich = true;
    public final int BORDER = 500;
    public int b1;
    public int b2;
    public int zhtp;
    public int mtbIdx;
    public int mhtp;
    private int ztbIdx;
    private ITimeControl tc;
    public Color color;
    private int selected = 0;
    private int prevSelected = -1;
    private int distance;
    private int middleb1b2;
    private TimeConfProvider tcp;
    private PropertyChangeSupport pcs;
    public static final String UPDATE_ZOOM_HRI_TRG = "updateZoomHriTrg";
    public static final String UPDATE_ZOOM_TIMEBASE = "updateZoomTimebase";

    public AssitControl(ITimeControl iTimeControl, Pref pref, TimeConfProvider timeConfProvider, PropertyChangeSupport propertyChangeSupport) {
        this.tc = iTimeControl;
        this.tcp = timeConfProvider;
        this.pcs = propertyChangeSupport;
        propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("onHorTrgPosChangedByTimebase")) {
                    int n = (Integer)propertyChangeEvent.getOldValue();
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    AssitControl.this.onHorTrgPosChangedByTimebase(n, n2);
                }
            }
        });
        this.load(pref);
        int n = BigDecimal.valueOf(500L).multiply(timeConfProvider.ratio(this.ztbIdx, iTimeControl.getTimebaseIdx())).intValue();
        this.b1 = this.middleb1b2 + n;
        this.b2 = this.middleb1b2 - n;
        if (this.b1 > 500 || this.b2 < -500) {
            this.b1 = 500;
            this.b2 = -500;
        }
        this.mtbIdx = iTimeControl.getTimebaseIdx();
        this.mhtp = iTimeControl.getHorizontalTriggerPosition();
    }

    private void screenMoveWithin(int n, int n2) {
        this.b1 += n;
        this.b2 += n;
        if (n2 <= this.b2) {
            this.tc.c_setHorizontalTriggerPosition(this.b2);
        }
    }

    private void horizontalTriggerMove(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < this.b2) {
            this.tc.c_setHorizontalTriggerPosition(this.b2);
        } else {
            this.tc.c_setHorizontalTriggerPosition(n3);
        }
    }

    public void assistMoveb1b2Center() {
        int n = -(this.b1 + this.b2) / 2;
        this.assistSetMoveb1b2(n);
    }

    public void assistSetMoveb1b2(int n) {
        int n2;
        int n3 = this.tc.getHorizontalTriggerPosition();
        int n4 = this.b1 + n;
        if (n4 <= 500 & (n2 = this.b2 + n) >= -500) {
            this.screenMoveWithin(n, n3);
        } else if (n4 > 500) {
            if (this.b1 < 500) {
                int n5 = 500 - this.b1;
                this.screenMoveWithin(n5, n3);
                this.horizontalTriggerMove(n -= n5, n3);
            } else if (this.b1 == 500) {
                this.horizontalTriggerMove(n, n3);
            }
        } else if (n2 < -500) {
            if (this.b2 > -500) {
                int n6 = -500 - this.b2;
                this.screenMoveWithin(n6, n3);
                this.horizontalTriggerMove(n -= n6, n3);
            } else if (this.b2 == -500) {
                this.horizontalTriggerMove(n, n3);
            }
        }
    }

    public void assistSetcomputDeltabb1b2(int n, int n2) {
        this.ztbIdx = n;
        if (n2 == n) {
            this.b1 = 500;
            this.b2 = -500;
            return;
        }
        int n3 = BigDecimal.valueOf(500L).multiply(this.tcp.ratio(n, n2)).intValue();
        int n4 = (this.b1 + this.b2) / 2;
        int n5 = n4 + n3;
        int n6 = n4 - n3;
        if (n5 > 500) {
            this.b1 = 500;
            this.b2 = n6 - (n5 - 500);
        } else if (n6 < -500) {
            this.b1 = n5 + -500 - n6;
            this.b2 = -500;
        } else {
            this.b1 = n4 + n3;
            this.b2 = n4 - n3;
        }
    }

    public int getZTBidx() {
        return this.ztbIdx;
    }

    public void setZTBidx(int n) {
        this.ztbIdx = n;
    }

    public void setSelected(int n) {
        this.prevSelected = this.selected;
        this.selected = n;
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isPressedtheSame(int n) {
        return this.prevSelected == n;
    }

    public boolean isonAssistSet() {
        return this.getSelected() == 1;
    }

    private void onHorTrgPosChangedByTimebase(int n, int n2) {
        if (this.isonZoom()) {
            this.setZTBidx(n);
            this.keepZtbNotbiggerthanMtb(n);
        } else if (this.isonAssistSet()) {
            this.mtbIdx = n;
            this.mhtp = n2;
        }
    }

    public boolean isonZoom() {
        return this.getSelected() == 2;
    }

    public boolean isonMain() {
        return this.getSelected() == 0;
    }

    private void reLocateHTP2Zoom() {
        int n = this.tc.getHorizontalTriggerPosition();
        double d = this.tcp.ratio(this.tc.getTimebaseIdx(), this.ztbIdx).doubleValue();
        this.zhtp = (int)((double)(n - (this.b1 + this.b2) / 2) * d);
        this.tc.c_setTimebase_HorTrgPos(this.ztbIdx, this.zhtp);
    }

    private void Main2Zoom() {
        if (this.ztbIdx > this.mtbIdx) {
            this.ztbIdx = this.mtbIdx;
            this.b1 = 500;
            this.b2 = -500;
        }
        if (!Platform.getControlManager().shouldAdjustHorTrgPos()) {
            return;
        }
        this.reLocateHTP2Zoom();
    }

    public void assistSet2Zoom() {
        this.reLocateHTP2Zoom();
    }

    private void reLocateb1b2pos2AssistSet() {
        if (this.ztbIdx == this.mtbIdx) {
            this.b1 = 500;
            this.b2 = -500;
            return;
        }
        int n = this.mhtp - BigDecimal.valueOf(this.tc.getHorizontalTriggerPosition()).multiply(this.tcp.ratio(this.ztbIdx, this.mtbIdx)).intValue();
        int n2 = BigDecimal.valueOf(500L).multiply(this.tcp.ratio(this.ztbIdx, this.mtbIdx)).intValue();
        int n3 = n + n2;
        int n4 = n - n2;
        if (n3 > 500) {
            this.b1 = 500;
            this.b2 = n4 - (n3 - 500);
        } else if (n4 < -500) {
            this.b1 = n3 + -500 - n4;
            this.b2 = -500;
        } else {
            this.b1 = n + n2;
            this.b2 = n - n2;
        }
    }

    private void zoom2Main() {
        this.reLocateb1b2pos2AssistSet();
        this.tc.c_setTimebase_HorTrgPos(this.mtbIdx, this.mhtp);
    }

    private void assistSet2Main() {
        this.distance = this.tc.getHorizontalTriggerPosition() - (this.b1 + this.b2) / 2;
        this.tc.c_setTimebase_HorTrgPos(this.mtbIdx, this.mhtp);
    }

    private void keepb1b2RelativeHtp() {
        int n = this.mhtp - this.distance;
        int n2 = BigDecimal.valueOf(500L).multiply(this.tcp.ratio(this.ztbIdx, this.mtbIdx)).intValue();
        int n3 = n + n2;
        int n4 = n - n2;
        if (n3 > 500) {
            this.b1 = 500;
            this.b2 = n4 - (n3 - 500);
        } else if (n4 < -500) {
            this.b1 = n3 + -500 - n4;
            this.b2 = -500;
        } else {
            this.b1 = n + n2;
            this.b2 = n - n2;
        }
    }

    private void main2AssistSet() {
        this.mtbIdx = this.tc.getTimebaseIdx();
        this.mhtp = this.tc.getHorizontalTriggerPosition();
        if (this.ztbIdx > this.mtbIdx) {
            this.ztbIdx = this.mtbIdx;
        }
        this.keepb1b2RelativeHtp();
    }

    private void zoom2AssistSet() {
        this.reLocateb1b2pos2AssistSet();
        this.tc.c_setTimebase_HorTrgPos(this.mtbIdx, this.mhtp);
    }

    public void switch2Zoom(ControlManager controlManager) {
        this.mtbIdx = this.tc.getTimebaseIdx();
        this.mhtp = this.tc.getHorizontalTriggerPosition();
        if (this.prevSelected == 0) {
            this.Main2Zoom();
        } else if (this.prevSelected == 1) {
            this.assistSet2Zoom();
        }
    }

    public void switch2Main() {
        if (this.prevSelected == 1) {
            this.assistSet2Main();
        } else if (this.prevSelected == 2) {
            this.zoom2Main();
        }
    }

    public void switch2AssistSet() {
        if (this.prevSelected == 0) {
            this.main2AssistSet();
        } else if (this.prevSelected == 2) {
            this.zoom2AssistSet();
        }
    }

    public void keepZtbNotbiggerthanMtb(int n) {
        if (n > this.mtbIdx) {
            int n2;
            int n3 = this.mtbIdx;
            this.mtbIdx = n;
            this.mhtp = n2 = BigDecimal.valueOf(this.mhtp).multiply(this.tcp.ratio(n3, n)).intValue();
            this.pcs.firePropertyChange(UPDATE_ZOOM_HRI_TRG, null, null);
        }
        this.pcs.firePropertyChange(UPDATE_ZOOM_TIMEBASE, null, null);
    }

    public void load(Pref pref) {
        this.ztbIdx = pref.loadInt("Zoom.ztimebaseidx");
        if (this.ztbIdx > this.tc.getTimebaseIdx()) {
            this.ztbIdx = this.tc.getTimebaseIdx();
        }
        this.middleb1b2 = pref.loadInt("Zoom.middleofborders");
        this.color = pref.loadColor("Zoom.rgb", Color.WHITE);
    }

    public void persist(Pref pref) {
        pref.persistInt("Zoom.ztimebaseidx", this.ztbIdx);
        int n = (this.b1 + this.b2) / 2;
        pref.persistInt("Zoom.middleofborders", n);
        pref.persistColor("Zoom.rgb", this.color);
    }

    public void drawMtbMhtp(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.isonZoom()) {
            int n = rectangle.x + rectangle.width * 16 / 20;
            int n2 = rectangle.x + rectangle.width * 18 / 20;
            int n3 = rectangle.y + rectangle.height - 19;
            int n4 = rectangle.y + rectangle.height - 4;
            graphics2D.setColor(this.color);
            graphics2D.drawString("M: " + this.tcp.getTimebaseLabel(this.mtbIdx), n, n3);
            graphics2D.drawString("Tm:  " + this.tc.getHTPLabel(this.mtbIdx, this.mhtp), n2, n3);
            graphics2D.drawString("W: " + this.tcp.getTimebaseLabel(this.ztbIdx), n, n4);
            graphics2D.drawString("Tw:  " + this.tc.getHTPLabel(this.ztbIdx, this.tc.getHorizontalTriggerPosition()), n2, n4);
        }
    }

    public void drawMarks(Graphics2D graphics2D, Rectangle rectangle) {
        int n = 500 + rectangle.x - this.b1;
        int n2 = 500 + rectangle.x - this.b2;
        if (this.isonAssistSet()) {
            graphics2D.setColor(this.color);
            LineDrawTool.drawUnequalDashesLine(graphics2D, rectangle.y, n, rectangle.y + rectangle.height);
            LineDrawTool.drawUnequalDashesLine(graphics2D, rectangle.y, n2, rectangle.y + rectangle.height);
        }
        this.drawMtbMhtp(graphics2D, rectangle);
    }

    public void factoryload(Pref pref) {
        this.load(pref);
        this.switch2Main();
        this.setSelected(0);
    }

    public void changeZoomstatus(ControlManager controlManager, int n) {
        if (this.getSelected() != n) {
            this.setSelected(n);
            switch (n) {
                case 0: {
                    this.switch2Main();
                }
                case 2: {
                    this.switch2Zoom(controlManager);
                }
            }
        }
    }

    public void updateZoomHtp() {
        if (this.isonZoom()) {
            this.zhtp = this.tc.getHorizontalTriggerPosition();
            this.pcs.firePropertyChange(UPDATE_ZOOM_HRI_TRG, null, null);
        }
    }
}

