/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.wf.rt;

import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.data.OfflineInfo;
import com.owon.uppersoft.vds.core.wf.rt.FreqInfo;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;

public class ChannelDataInfo
extends FreqInfo {
    public static final int Max_8bit = 125;
    public static final int Min_8bit = -125;
    public static final int Max = 125;
    public static final int Min = -125;
    public int chl;
    public int datalen;
    public int initPos;
    public int screendatalen;
    public int slowMove;
    private int inverseType = 0;
    private LinkedList<ByteBuffer> buflist = new LinkedList();
    public OfflineInfo oi = new OfflineInfo();
    public int xoffset;
    public boolean BeyondMax = false;
    public boolean BeyondMin = false;

    public ChannelDataInfo() {
        this.reset();
    }

    private void resetInverseType() {
        this.setInverseType(0);
    }

    public void setInverseType_Record(CByteArrayInputStream cByteArrayInputStream, int n) {
        if (n >= 1) {
            this.setInverseType(cByteArrayInputStream.nextInt());
        } else {
            this.resetInverseType();
        }
    }

    public LinkedList<ByteBuffer> getBuflist() {
        return this.buflist;
    }

    public void reset() {
        this.BeyondMin = false;
        this.BeyondMax = false;
        this.buflist.clear();
    }

    public void setUniqueAdcbuf(ByteBuffer byteBuffer) {
        this.buflist.clear();
        this.addAdcBuf(byteBuffer);
    }

    public ByteBuffer getUniqueAdcbuf() {
        int n = this.buflist.size();
        if (n <= 0) {
            return null;
        }
        return this.buflist.peek();
    }

    public ByteBuffer popAdcbuf() {
        int n = this.buflist.size();
        if (n <= 0) {
            return null;
        }
        return this.buflist.pop();
    }

    public void reduceAdcbuf() {
        int n = this.buflist.size();
        if (n == 0) {
            return;
        }
        ByteBuffer byteBuffer = this.buflist.peekLast();
        this.setUniqueAdcbuf(byteBuffer);
    }

    public void addAdcBuf(ByteBuffer byteBuffer) {
        this.addSpecialAdcBuf(byteBuffer);
    }

    private void addSpecialAdcBuf(ByteBuffer byteBuffer) {
        this.buflist.add(byteBuffer);
    }

    public void forceGround(int n) {
        int n2 = this.buflist.size();
        if (n2 <= 0) {
            return;
        }
        ByteBuffer byteBuffer = this.buflist.peek();
        this.gndByteBuffer(byteBuffer, n);
        this.setUniqueAdcbuf(byteBuffer);
    }

    protected void gndByteBuffer(ByteBuffer byteBuffer, int n) {
        int n2 = n;
        if (n2 > 125) {
            n2 = 125;
        } else if (n2 < -125) {
            n2 = -125;
        }
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        Arrays.fill(byteBuffer.array(), n3, n4, (byte)n2);
    }

    public void setInverseType(int n) {
        this.inverseType = n;
    }

    public int getInverseType() {
        return this.inverseType;
    }

    public void handleADCBoundNInverse(int n, boolean bl) {
        for (ByteBuffer byteBuffer : this.buflist) {
            this.handleADCBoundNInverseForFrame(n, bl, byteBuffer);
        }
    }

    public void applyFilter(double d, boolean bl) {
    }

    public final void handleADCBoundNInverseForFrame(int n, boolean bl, ByteBuffer byteBuffer) {
        if (bl) {
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n4 = n << 1;
            for (int i = n2; i < n3; ++i) {
                int n5 = n4 - byArray[i];
                if (n5 > 125) {
                    byArray[i] = 125;
                    this.BeyondMax = true;
                    continue;
                }
                if (n5 < -125) {
                    byArray[i] = -125;
                    this.BeyondMin = true;
                    continue;
                }
                byArray[i] = (byte)n5;
            }
        } else {
            int n6 = byteBuffer.position();
            int n7 = byteBuffer.limit();
            byte[] byArray = byteBuffer.array();
            for (int i = n6; i < n7; ++i) {
                byte by = byArray[i];
                if (by > 125) {
                    byArray[i] = 125;
                    this.BeyondMax = true;
                    continue;
                }
                if (by >= -125) continue;
                byArray[i] = -125;
                this.BeyondMin = true;
            }
        }
    }
}

