/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.wf.dm;

import com.owon.uppersoft.vds.core.aspect.control.DeepProvider;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public abstract class DMInfo {
    public byte DMem = 0;
    public LinkedList<DMDataInfo> channels = new LinkedList();
    public int timebase;
    public int horTrgPos;
    public int machine_type;
    public int dataComplete;
    public int channelNum;
    public int status;
    public byte chlflag;
    public int dmidx;
    private int screendatalen;
    public int datalen;
    public int slowMove;
    public int initPos;
    public RandomAccessFile raf;
    public PropertyChangeListener pcl;
    public File file;
    public int triggerStatus;
    private int channelStatus;
    public int file_version;
    protected boolean isPKDetect = false;
    public int extend;
    private DeepProvider dp;

    public DMInfo(DeepProvider deepProvider) {
        this.dp = deepProvider;
    }

    public void setPKDetect_DM(CByteArrayInputStream cByteArrayInputStream) {
        this.isPKDetect = cByteArrayInputStream.nextBoolean();
    }

    public void setPKDetect(boolean bl) {
        this.isPKDetect = bl;
    }

    public boolean isPKDetect() {
        return this.isPKDetect;
    }

    public boolean setMore_OfflineDM(CByteArrayInputStream cByteArrayInputStream) {
        this.extend = cByteArrayInputStream.nextInt();
        int n = this.extend >>> 24;
        return n == 1;
    }

    public void log() {
        this.config("***************\r\n");
        this.config(SFormatter.dataformat("dso_id: %d\r\n", this.machine_type));
        this.config(SFormatter.dataformat("file_format_id: %d\r\n", this.file_version));
        this.config(SFormatter.dataformat("DMem: %s\r\n", Character.valueOf((char)this.DMem)));
        this.config(SFormatter.dataformat("horTrgPos: %d\r\n", this.horTrgPos));
        this.config(SFormatter.dataformat("timebase: %d\r\n", this.timebase));
    }

    private void config(String string) {
        System.out.println(string);
    }

    public int setChannelStatus(int n) {
        this.channelStatus = n;
        this.channelNum = Integer.bitCount(n);
        return this.channelNum;
    }

    public int getChannelStatus() {
        return this.channelStatus;
    }

    public int getDeepMemoryLength(int n) {
        return this.dp.getLength(n);
    }

    public int getScreendatalen() {
        return this.screendatalen;
    }

    public void setScreendatalen(DMDataInfo dMDataInfo) {
        this.screendatalen = dMDataInfo.screendatalen;
    }
}

