/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.wf.dm;

import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.wf.rt.FreqInfo;
import com.owon.uppersoft.vds.core.wf.rt.PlugInfo;
import com.owon.uppersoft.vds.util.format.EndianUtil;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public abstract class DMDataInfo
extends FreqInfo {
    public int datalen;
    public int slowMove;
    public int pos0;
    public int filePointer;
    public int initPos;
    public int screendatalen;
    public int chl;
    public int probeMultiIdx;
    public int vbIdx;
    public PlugInfo pi = new PlugInfo();
    public boolean shouldInverse;
    public int inverseType = 0;

    public void setPullTrg_OfflineDM(CByteArrayInputStream cByteArrayInputStream, int n) {
        this.pi.plugDataLength = cByteArrayInputStream.nextInt();
        this.pi.sinePlugRate = cByteArrayInputStream.nextInt();
        this.pi.linearPlugRate = cByteArrayInputStream.nextFloat();
        this.pi.pluggedTrgOffset = cByteArrayInputStream.nextInt();
    }

    public void setInverseType_OfflineDM(CByteArrayInputStream cByteArrayInputStream, int n) {
        this.inverseType = cByteArrayInputStream.nextInt();
    }

    public int receivePlugInfo(byte[] byArray, int n) {
        this.pi.plugDataLength = EndianUtil.nextIntB(byArray, n);
        this.pi.sinePlugRate = EndianUtil.nextIntB(byArray, n += 4);
        this.pi.linearPlugRate = EndianUtil.nextFloatB(byArray, n += 4);
        this.pi.pluggedTrgOffset = EndianUtil.nextIntB(byArray, n += 4);
        return n += 4;
    }

    public void receivePlugInfo(ByteBuffer byteBuffer) {
        this.pi.plugDataLength = byteBuffer.getInt();
        this.pi.sinePlugRate = byteBuffer.getInt();
        this.pi.linearPlugRate = byteBuffer.getFloat();
        this.pi.pluggedTrgOffset = byteBuffer.getInt();
        this.println("pi.plugDataLength: " + this.pi.plugDataLength + ",4");
        this.println("pi.sinePlugRate: " + this.pi.sinePlugRate + ",4");
        this.println("pi.linearPlugRate: " + this.pi.linearPlugRate + ",4");
        this.println("pi.pluggedTrgOffset: " + this.pi.pluggedTrgOffset + ",4");
    }

    private void println(String string) {
    }

    public int readPlugInfo(byte[] byArray, int n) {
        this.pi.plugDataLength = EndianUtil.nextIntB(byArray, n);
        this.pi.sinePlugRate = EndianUtil.nextIntB(byArray, n += 4);
        this.pi.linearPlugRate = EndianUtil.nextFloatB(byArray, n += 4);
        this.pi.pluggedTrgOffset = EndianUtil.nextIntB(byArray, n += 4);
        return n += 4;
    }

    public void logReceive() {
        this.configln("-------DMDataInfo-------\r\n");
        this.configln(SFormatter.dataformat("chl: %d", this.chl));
        this.configln(SFormatter.dataformat("initPos: %d", this.initPos));
        this.configln(SFormatter.dataformat("screendatalen: %d", this.screendatalen));
        this.configln(SFormatter.dataformat("datalen: %d", this.datalen));
        this.configln(SFormatter.dataformat("slowMove: %d", this.slowMove));
        this.configln(SFormatter.dataformat("plugDataLength: %d", this.pi.plugDataLength));
        this.configln(SFormatter.dataformat("sinePlugRate: %d", this.pi.sinePlugRate));
        this.configln(SFormatter.dataformat("linearPlugRate: %.4f", this.pi.linearPlugRate));
        this.configln(SFormatter.dataformat("pluggedTrgOffset: %d", this.pi.pluggedTrgOffset));
        this.configln(SFormatter.dataformat("filePointer: %d", this.filePointer));
    }

    private void configln(String string) {
        System.out.println(string);
    }

    protected void resetInverseType() {
        this.inverseType = 0;
    }

    public void writeRandomAccessFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.initPos);
        randomAccessFile.writeInt(this.screendatalen);
        randomAccessFile.writeInt(this.pi.plugDataLength);
        randomAccessFile.writeInt(this.pi.sinePlugRate);
        randomAccessFile.writeFloat((float)this.pi.linearPlugRate);
        randomAccessFile.writeInt(this.pi.pluggedTrgOffset);
        randomAccessFile.writeInt(this.datalen);
        randomAccessFile.writeInt(this.slowMove);
        randomAccessFile.writeInt(this.pos0);
        randomAccessFile.writeInt(this.vbIdx);
        randomAccessFile.writeInt(this.probeMultiIdx);
        randomAccessFile.writeFloat(this.getFrequencyFloat());
        randomAccessFile.writeFloat(1.0f / this.getFrequencyFloat());
    }
}

