/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.wf;

import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.common.dm.LocInfo;
import com.owon.uppersoft.vds.core.aspect.control.Pos0_VBChangeInfluence;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.rt.AverageContainer;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.util.Pref;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public abstract class WaveFormInfo {
    public AverageContainer ac = new AverageContainer();
    public ChannelInfo ci;
    private LocInfo dmli;

    public WaveFormInfo(int n, VoltageProvider voltageProvider, Pos0_VBChangeInfluence pos0_VBChangeInfluence) {
        this.ci = new ChannelInfo(n, voltageProvider, pos0_VBChangeInfluence);
        this.dmli = this.createLocInfo();
    }

    protected abstract LocInfo createLocInfo();

    public void load(Pref pref) {
        this.ci.load(pref);
    }

    public void persist(Pref pref) {
        this.ci.persist(pref);
    }

    public String toString() {
        return this.ci.getName();
    }

    protected void resetDMIntBuf(ScreenContext screenContext, int n, BigDecimal bigDecimal) {
        int n2 = screenContext.getHcenter();
        boolean bl = screenContext.isScreenMode_3();
        int n3 = bl ? n2 + n : n2 + (n << 1);
        this.resetIntBuf_dm(bigDecimal, n3, bl);
    }

    public void prepareDM(ScreenContext screenContext, DMDataInfo dMDataInfo, BigDecimal bigDecimal, int n, int n2, MachineType machineType, DMInfo dMInfo) {
        this.dmli.prepareDM(screenContext, dMDataInfo, bigDecimal, n2, n, dMDataInfo.shouldInverse, machineType, dMInfo);
        this.resetDMIntBufDefaultY(screenContext);
    }

    public ByteBuffer getADC_Buf() {
        return this.dmli.getADC_Buf();
    }

    public void drawView_dm(Graphics graphics, int n, int n2, int n3, int n4) {
        this.dmli.drawView(graphics, n, n2, n3, n4);
    }

    public void releaseDM() {
        this.dmli.release();
    }

    public void addWaveFormsXloc(int n, ScreenContext screenContext) {
        this.dmli.addWaveFormsXloc(n);
        this.resetDMIntBufDefaultY(screenContext);
    }

    public void setTimebaseIndex(int n, int n2, ScreenContext screenContext) {
        this.dmli.setTimebaseIndex(n);
        this.resetDMIntBufDefaultY(screenContext);
    }

    protected void resetDMIntBufDefaultY(ScreenContext screenContext) {
        this.dmli.resetIntBuf(BigDecimal.valueOf(1L), screenContext.getHcenter(), screenContext.isScreenMode_3());
    }

    public int getDrawMode() {
        return this.dmli.getDrawMode();
    }

    public double getDMGap() {
        return this.dmli.getGap();
    }

    public int getXOffset_DM() {
        return this.dmli.getXoffset();
    }

    public int getDataLen() {
        return this.dmli.datalen;
    }

    public int getDMFilePointer() {
        return this.dmli.filePointer;
    }

    protected void resetIntBuf_dm(BigDecimal bigDecimal, int n, boolean bl) {
        this.dmli.resetIntBuf(bigDecimal, n, bl);
    }
}

