/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.wf;

import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.core.rt.IDataMaxMin;
import com.owon.uppersoft.vds.util.PrimaryTypeUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class RTLocInfo
implements IDataMaxMin {
    public static int AREA_WIDTH = 1000;
    public ByteBuffer adcbuf;
    public IntBuffer pixbuf;
    private int chln;

    public RTLocInfo(int n) {
        this.chln = n;
    }

    private void prepare() {
        if (this.pixbuf == null) {
            this.pixbuf = IntBuffer.allocate((AREA_WIDTH << 2) + 1000);
            this.pixbuf.position(0);
            this.pixbuf.limit(0);
        }
    }

    @Override
    public int getMax() {
        return 125;
    }

    @Override
    public int getMin() {
        return -125;
    }

    protected void release() {
        this.adcbuf = null;
        this.pixbuf = null;
    }

    public void resetIntBuf(BigDecimal bigDecimal, int n, boolean bl) {
        ByteBuffer byteBuffer = this.adcbuf;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int[] nArray = this.pixbuf.array();
        int n4 = 0;
        this.pixbuf.position(n4);
        if (PrimaryTypeUtil.canHoldAsInt(bigDecimal)) {
            int n5 = bigDecimal.intValue();
            if (bl) {
                if (n5 == 1) {
                    while (n2 < n3) {
                        nArray[n4] = n - byArray[n2];
                        ++n2;
                        ++n4;
                    }
                } else {
                    while (n2 < n3) {
                        nArray[n4] = n - byArray[n2] * n5;
                        ++n2;
                        ++n4;
                    }
                }
            } else if (n5 == 1) {
                while (n2 < n3) {
                    nArray[n4] = n - (byArray[n2] << 1);
                    ++n2;
                    ++n4;
                }
            } else {
                while (n2 < n3) {
                    nArray[n4] = n - (byArray[n2] << 1) * n5;
                    ++n2;
                    ++n4;
                }
            }
        } else {
            double d = bigDecimal.doubleValue();
            if (bl) {
                while (n2 < n3) {
                    nArray[n4] = n - (int)((double)byArray[n2] * d);
                    ++n2;
                    ++n4;
                }
            } else {
                while (n2 < n3) {
                    nArray[n4] = n - (int)((double)(byArray[n2] << 1) * d);
                    ++n2;
                    ++n4;
                }
            }
        }
        this.pixbuf.limit(n4);
    }

    public MinMax collect_max_min() {
        byte by;
        if (this.adcbuf == null) {
            return null;
        }
        int n = this.adcbuf.position();
        int n2 = this.adcbuf.limit();
        byte[] byArray = this.adcbuf.array();
        if (n >= n2) {
            return null;
        }
        byte by2 = by = byArray[n];
        for (int i = n + 1; i < n2; ++i) {
            byte by3 = byArray[i];
            if (by3 > by) {
                by = by3;
                continue;
            }
            if (by3 >= by2) continue;
            by2 = by3;
        }
        return new MinMax(by2, by);
    }

    public void resetRTIntBuf(ByteBuffer byteBuffer, int n, boolean bl, BigDecimal bigDecimal) {
        this.prepare();
        this.adcbuf = byteBuffer;
        this.resetIntBuf(bigDecimal, n, bl);
    }

    public int getChln() {
        return this.chln;
    }
}

