/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.usb.help;

import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.uppersoft.vds.core.usb.help.IUSBCheckHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextMenuManager
implements PopupMenuListener {
    private static final String ACTION_DISCONNECT = "Action.disconnect";
    private static final String ACTION_CONNECT_LAN = "Action.connectLAN";
    private static final String ACTION_INSTALL_USBDRV = "Action.installUSBDRV";
    private static final String ACTION_NO_USB_FOUND = "Action.noUSBFound";
    private static final String ACTION_CONNECT_USB = "Action.connectUSB";
    private static final String ACTION_USB_SLEEP = "Label.UsbSleep";
    private static final String ACTION_USB_WAKE = "Label.UsbWake";
    private JPopupMenu ctxMenu;
    private Component c;
    private boolean onContextMenu = false;

    public ContextMenuManager(JPopupMenu jPopupMenu, Component component) {
        this.ctxMenu = jPopupMenu;
        this.c = component;
        this.ctxMenu.addPopupMenuListener(this);
    }

    public boolean isOnContextMenu() {
        return this.onContextMenu;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.onContextMenu = false;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.onContextMenu = true;
    }

    public void showContextMenu_Offline(final IUSBCheckHelper iUSBCheckHelper, int n, ResourceBundle resourceBundle) {
        this.onContextMenu = true;
        List<IDevice> list = iUSBCheckHelper.getDeviceList();
        this.ctxMenu.removeAll();
        final boolean bl = list != null && list.size() != 0;
        JMenu jMenu = new JMenu(resourceBundle.getString(bl ? ACTION_CONNECT_USB : ACTION_NO_USB_FOUND));
        if (bl) {
            for (final IDevice iDevice : list) {
                String string = Integer.toHexString(iDevice.getBcdUSB());
                String string2 = iDevice.toString() + ", bcd: 0x" + string;
                JMenuItem jMenuItem = new JMenuItem(string2);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (bl) {
                            iUSBCheckHelper.askConnectUSB(iDevice);
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
        }
        this.ctxMenu.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString(ACTION_CONNECT_LAN));
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.ctxMenu.add(jMenuItem);
        this.ctxMenu.show(this.c, n, 0);
    }

    public void showContextMenu_Online(final IUSBCheckHelper iUSBCheckHelper, int n, ResourceBundle resourceBundle) {
        this.ctxMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString(ACTION_DISCONNECT));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iUSBCheckHelper.askDisconnect();
            }
        });
        this.ctxMenu.add(jMenuItem);
        this.ctxMenu.show(this.c, n, 0);
    }

    public void showContextMenu_RightClick(final IUSBCheckHelper iUSBCheckHelper, int n, ResourceBundle resourceBundle) {
        this.ctxMenu.removeAll();
        final boolean bl = iUSBCheckHelper.isNoCheck();
        JMenuItem jMenuItem = new JMenuItem(bl ? resourceBundle.getString(ACTION_USB_WAKE) : resourceBundle.getString(ACTION_USB_SLEEP));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iUSBCheckHelper.setNoCheck(!bl);
                if (!bl) {
                    iUSBCheckHelper.askDisconnect();
                }
            }
        });
        this.ctxMenu.add(jMenuItem);
        this.ctxMenu.show(this.c, n, 0);
    }

    public void closeContextMenu() {
        this.ctxMenu.setVisible(false);
    }
}

