/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.usb;

import ch.ntb.usb.LibusbJava;
import ch.ntb.usb.USBException;
import ch.ntb.usb.Usb_Bus;
import ch.ntb.usb.Usb_Config_Descriptor;
import ch.ntb.usb.Usb_Device;
import ch.ntb.usb.Usb_Device_Descriptor;
import ch.ntb.usb.Usb_Endpoint_Descriptor;
import ch.ntb.usb.Usb_Interface;
import ch.ntb.usb.Usb_Interface_Descriptor;
import com.owon.uppersoft.dso.source.usb.USBPortsFilter;
import com.owon.uppersoft.vds.core.usb.ComparableDevice;
import com.owon.uppersoft.vds.core.usb.IDevice;
import com.owon.vds.firm.protocol.AddressAttachCommand;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CDevice
extends ComparableDevice
implements IDevice {
    public static int CONTEXT = 0;
    private String id;
    private int context;
    private Usb_Device dev = null;
    private long dev_handle = 0L;
    private short idVendor;
    private short idProduct;
    private boolean logResult = false;
    private static Map<String, CDevice> _cache = new HashMap<String, CDevice>();

    private static void logln(String string) {
        System.out.println(string);
    }

    protected CDevice(String string, Usb_Device usb_Device, short s, short s2, int n) {
        this.id = string;
        this.dev = usb_Device;
        this.idVendor = s;
        this.idProduct = s2;
        this.context = n;
    }

    @Override
    public boolean equals(IDevice iDevice) {
        return this.id.equals(((CDevice)iDevice).id);
    }

    @Override
    public boolean isOpen() {
        return this.dev_handle != 0L;
    }

    @Override
    public void open() throws USBException {
        if (this.dev == null) {
            throw new USBException("device is null");
        }
        if (this.context != CONTEXT) {
            throw new USBException("context changed, device is no longer valid.");
        }
        if (this.dev_handle != 0L) {
            throw new USBException("device opened, close or reset first");
        }
        this.dev_handle = LibusbJava.usb_open(this.dev);
        if (this.dev_handle <= 0L) {
            String string = LibusbJava.usb_strerror() + " (" + this.dev_handle + ")";
            this.dev_handle = 0L;
            throw new USBException("LibusbJava.usb_open: " + string);
        }
        if (LibusbJava.usb_claim_interface(this.dev_handle, this.bInterfaceNumber) != 0) {
            String string = LibusbJava.usb_strerror();
            throw new USBException("LibusbJava.usb_claim_interface: " + string);
        }
    }

    @Override
    public void close() throws USBException {
        if (this.dev_handle == 0L) {
            return;
        }
        LibusbJava.usb_release_interface(this.dev_handle, this.bInterfaceNumber);
        LibusbJava.usb_close(this.dev_handle);
        this.dev_handle = 0L;
    }

    @Override
    public void reset() throws USBException {
        if (this.dev_handle == 0L) {
            return;
        }
        LibusbJava.usb_reset(this.dev_handle);
        this.dev_handle = 0L;
    }

    @Override
    public int writeBulk(byte[] byArray, int n, int n2) throws USBException {
        int n3;
        if (this.dev_handle == 0L) {
            throw new USBException("invalid device handle");
        }
        if (this.context != CONTEXT) {
            throw new USBException("context changed, device is no longer valide.");
        }
        if (byArray == null) {
            throw new USBException("data must not be null");
        }
        if (n <= 0 || n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("invalid size: " + n);
        }
        this.logResult = false;
        if (n <= 9) {
            n3 = CDevice.readI4(byArray, 0);
            switch (n3) {
                case 1: {
                    break;
                }
                case 4096: {
                    break;
                }
                case 122: {
                    break;
                }
                case 74: {
                    break;
                }
                case 75: {
                    break;
                }
                default: {
                    int n4 = 0;
                    switch (byArray[4]) {
                        case 4: {
                            n4 = CDevice.readI4(byArray, 5);
                            break;
                        }
                        case 2: {
                            n4 = CDevice.readI2(byArray, 5);
                            break;
                        }
                        case 1: {
                            n4 = CDevice.readI1(byArray, 5);
                        }
                    }
                    this.logResult = true;
                    String string = AddressAttachCommand.list.get(n3);
                    String string2 = "0x" + Integer.toHexString(n4);
                    System.out.print("[Send @" + string + " " + string2 + "]");
                }
            }
        }
        if ((n3 = LibusbJava.usb_bulk_write(this.dev_handle, this.WriteEndpoint, byArray, n, n2)) < 0) {
            String string = LibusbJava.usb_strerror();
            throw new USBException("LibusbJava.usb_bulk_write: " + string);
        }
        return n3;
    }

    @Override
    public int readBulk(byte[] byArray, int n, int n2) throws USBException {
        if (this.dev_handle == 0L) {
            throw new USBException("invalid device handle");
        }
        if (this.context != CONTEXT) {
            throw new USBException("context changed, device is no longer valide.");
        }
        if (byArray == null) {
            throw new USBException("data must not be null");
        }
        if (n <= 0 || n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("invalid size: " + n);
        }
        int n3 = LibusbJava.usb_bulk_read(this.dev_handle, this.ReadEndpoint | 0x80, byArray, n, n2);
        if (n3 < 0) {
            String string = LibusbJava.usb_strerror();
            throw new USBException("LibusbJava.usb_bulk_read: " + string);
        }
        if (this.logResult) {
            if (n3 == 5) {
                char c = (char)byArray[0];
                int n4 = CDevice.readI4(byArray, 1);
                System.err.println(" recv " + c + " 0x" + Integer.toHexString(n4));
            } else {
                System.err.println(" recv " + n3 + " bytes");
            }
        }
        return n3;
    }

    public static void init() {
        CONTEXT = (CONTEXT + 1) % Short.MAX_VALUE;
        LibusbJava.usb_init();
        LibusbJava.usb_find_busses();
        LibusbJava.usb_find_devices();
    }

    public static void release() {
        CONTEXT = (CONTEXT + 1) % Short.MAX_VALUE;
        LibusbJava.usb_init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IDevice> getDevices(short s, short s2, USBPortsFilter uSBPortsFilter) throws USBException {
        Object object;
        Usb_Bus usb_Bus;
        CDevice.init();
        LinkedList<IDevice> linkedList = new LinkedList<IDevice>();
        int n = 0;
        if (usb_Bus == null) {
            throw new USBException("LibusbJava.usb_get_busses: " + LibusbJava.usb_strerror());
        }
        for (usb_Bus = LibusbJava.usb_get_busses(); usb_Bus != null; usb_Bus = usb_Bus.getNext()) {
            for (object = usb_Bus.getDevices(); object != null; object = ((Usb_Device)object).getNext()) {
                Usb_Interface_Descriptor usb_Interface_Descriptor;
                Usb_Endpoint_Descriptor[] usb_Endpoint_DescriptorArray;
                Usb_Interface usb_Interface;
                Usb_Interface_Descriptor[] usb_Interface_DescriptorArray;
                Usb_Config_Descriptor usb_Config_Descriptor;
                Usb_Interface[] usb_InterfaceArray;
                ++n;
                Usb_Device_Descriptor usb_Device_Descriptor = ((Usb_Device)object).getDescriptor();
                if (usb_Device_Descriptor.getIdVendor() != s || usb_Device_Descriptor.getIdProduct() != s2) continue;
                String string = n + ":" + ((Usb_Device)object).getFilename();
                CDevice cDevice = _cache.getOrDefault(string, null);
                if (cDevice != null) {
                    cDevice.dev = object;
                    cDevice.context = CONTEXT;
                    linkedList.add(cDevice);
                    continue;
                }
                Usb_Config_Descriptor[] usb_Config_DescriptorArray = ((Usb_Device)object).getConfig();
                if (usb_Config_DescriptorArray == null || usb_Config_DescriptorArray.length == 0 || (usb_InterfaceArray = (usb_Config_Descriptor = usb_Config_DescriptorArray[0]).getInterface()) == null || usb_InterfaceArray.length == 0 || (usb_Interface_DescriptorArray = (usb_Interface = usb_InterfaceArray[0]).getAltsetting()) == null || usb_Interface_DescriptorArray.length == 0 || (usb_Endpoint_DescriptorArray = (usb_Interface_Descriptor = usb_Interface_DescriptorArray[0]).getEndpoint()) == null || usb_Endpoint_DescriptorArray.length < 2) continue;
                cDevice = new CDevice(string, (Usb_Device)object, s, s2, CONTEXT);
                cDevice.bcdUSB = usb_Device_Descriptor.getBcdUSB();
                cDevice.bConfigurationValue = usb_Config_Descriptor.getBConfigurationValue();
                cDevice.bInterfaceNumber = usb_Interface_Descriptor.getBInterfaceNumber();
                cDevice.bAlternateSetting = usb_Interface_Descriptor.getBAlternateSetting();
                for (Usb_Endpoint_Descriptor usb_Endpoint_Descriptor : usb_Endpoint_DescriptorArray) {
                    byte by = usb_Endpoint_Descriptor.getBEndpointAddress();
                    int n2 = usb_Endpoint_Descriptor.getBEndpointAddress() & 0xFF;
                    int n3 = usb_Endpoint_Descriptor.getWMaxPacketSize() * 16;
                    if ((by & 0x80) > 0) {
                        cDevice.ReadEndpoint = n2;
                        cDevice.RdEpMaxPacketSize = n3;
                        continue;
                    }
                    cDevice.WriteEndpoint = n2;
                    cDevice.WrEpMaxPacketSize = n3;
                }
                try {
                    cDevice.open();
                    if (uSBPortsFilter != null && !uSBPortsFilter.collectPort(cDevice)) continue;
                    linkedList.add(cDevice);
                    _cache.put(string, cDevice);
                    System.out.println("found usb device " + cDevice.getSerialNumber() + " idVendor:0x" + Integer.toHexString(cDevice.idVendor) + " idProduct:0x" + Integer.toHexString(cDevice.idProduct));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    cDevice.close();
                }
            }
        }
        object = _cache.entrySet().iterator();
        while (object.hasNext()) {
            if (((CDevice)((Map.Entry)object.next()).getValue()).context == CONTEXT) continue;
            object.remove();
        }
        return linkedList;
    }

    private static int readI4(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static short readI2(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        return (short)n2;
    }

    private static byte readI1(byte[] byArray, int n) {
        return byArray[n];
    }
}

