/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.update.download;

import com.owon.uppersoft.vds.core.update.UpdateFrame;
import com.owon.uppersoft.vds.core.update.download.DownloadFile;
import com.owon.uppersoft.vds.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class UpdateTask
implements Runnable {
    private byte[] buf = new byte[10240];
    private boolean isCancel = false;
    private UpdateFrame frame;
    private List<DownloadFile> files;
    private String url;

    public UpdateTask(UpdateFrame updateFrame, String string, List<DownloadFile> list) {
        this.frame = updateFrame;
        this.url = string;
        this.files = list;
    }

    @Override
    public void run() {
        try {
            URL uRL = new URL(this.url);
            for (DownloadFile downloadFile : this.files) {
                if (this.isCancel) {
                    return;
                }
                if (this.getFile(uRL, downloadFile)) continue;
                this.frame.downloadFailed();
                return;
            }
            if (this.isCancel) {
                return;
            }
            this.frame.downloadFinished();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    private boolean getFile(URL uRL, DownloadFile downloadFile) {
        String string = downloadFile.getRelativePath();
        try {
            BufferedInputStream bufferedInputStream = null;
            HttpURLConnection httpURLConnection = null;
            URL uRL2 = new URL(uRL, downloadFile.getRelativePath());
            httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            this.frame.setCurrentDownloadFile(downloadFile, uRL2);
            File file = new File(this.frame.getDownloadTempDir(), string);
            httpURLConnection.setReadTimeout(3000);
            httpURLConnection.connect();
            String string2 = httpURLConnection.getHeaderField("Content-Length");
            if (string2 == null) {
                return false;
            }
            long l = Long.parseLong(string2);
            if (l <= 0L) {
                return false;
            }
            downloadFile.setFileLength(l);
            long l2 = 0L;
            FileUtil.checkPath(file);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(l2);
            int n = 0;
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            while ((n = bufferedInputStream.read(this.buf)) != -1) {
                if (this.isCancel) {
                    randomAccessFile.close();
                    bufferedInputStream.close();
                    httpURLConnection.disconnect();
                    this.onCancel(file);
                    return false;
                }
                randomAccessFile.write(this.buf, 0, n);
                downloadFile.addToRetrived(n);
                this.frame.updateProgress();
                Thread.sleep(0L);
            }
            randomAccessFile.close();
            bufferedInputStream.close();
            httpURLConnection.disconnect();
            if (downloadFile.getRetrived() < l) {
                return false;
            }
            downloadFile.setLocalTempFile(file);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected void backTransmitFromDisturb(HttpURLConnection httpURLConnection, long l) {
        httpURLConnection.setRequestProperty("User-Agent", "NetFox");
        httpURLConnection.setRequestProperty("RANGE", "bytes=" + l + "-");
    }

    private void onCancel(File file) {
        file.delete();
    }

    public void setCancel() {
        this.isCancel = true;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

