/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.update;

import com.owon.uppersoft.vds.core.aspect.Localizable;
import com.owon.uppersoft.vds.core.update.IUpdatable;
import com.owon.uppersoft.vds.core.update.UpdateDetection;
import com.owon.uppersoft.vds.core.update.download.DownloadFile;
import com.owon.uppersoft.vds.core.update.download.UpdateTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class UpdateFrame
extends AbstractTableModel
implements Localizable {
    public static final String INFO_TITLE = "Info.Title";
    public static final String INFO_DOWNLOADING = "Info.Downloading";
    public static final String INFO_DO_UPDATE = "Info.DoUpdate";
    public static final String INFO_DO_CANCEL = "Info.DoCancel";
    public static final String ERROR_INTERNET_CONNECTION = "Error.InternetConnection";
    public static final String INFO_RESTART = "Info.Restart";
    public static final String INFO_DOWNLOAD_PROGRESS = "Info.DownloadProgress";
    public static final String INFO_DOWNLOAD_FILE = "Info.DownloadFile";
    private static final long serialVersionUID = 1L;
    private JLabel txtUrl;
    private Thread taskThd;
    private UpdateTask task;
    private List<DownloadFile> files;
    private UpdateDetection ud;
    private JButton cancelButton;
    private JButton updateButton;
    private JTable table;
    private JScrollPane tvscrollpane;
    protected JFrame updateframe;
    private IUpdatable iu;
    private UpdateNRestart updateNRestart = new UpdateNRestart();
    private UpdateNext updateNext = new UpdateNext();

    public UpdateFrame(UpdateDetection updateDetection, String string, List<DownloadFile> list) {
        this.ud = updateDetection;
        this.iu = updateDetection.getUpdatable();
        this.files = list;
        this.createContents();
        this.localize(this.iu.bundle());
        this.task = new UpdateTask(this, string, list);
        this.taskThd = new Thread(this.task);
    }

    private void createContents() {
        this.updateframe = new JFrame();
        this.iu.getWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.updateframe.setDefaultCloseOperation(2);
        this.updateframe.setLocationRelativeTo(null);
        this.updateframe.setPreferredSize(new Dimension(430, 250));
        Container container = this.updateframe.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        this.txtUrl = new JLabel();
        this.txtUrl.setPreferredSize(new Dimension(430, 30));
        this.table = new JTable(this);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setRowHeight(25);
        this.table.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(350);
        tableColumnModel.getColumn(1).setPreferredWidth(100);
        this.tvscrollpane = new JScrollPane(this.table);
        this.updateButton = new JButton();
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateFrame.this.updateButton.setEnabled(false);
                UpdateFrame.this.taskThd.start();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UpdateFrame.this.task.setCancel();
                    UpdateFrame.this.taskThd.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                UpdateFrame.this.iu.notifyDestroy();
                UpdateFrame.this.updateframe.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.updateButton);
        jPanel.add(this.cancelButton);
        container.add((Component)this.txtUrl, "North");
        container.add((Component)this.tvscrollpane, "Center");
        container.add((Component)jPanel, "South");
        this.updateframe.setVisible(true);
        this.updateframe.pack();
        this.updateframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UpdateFrame.this.task.setCancel();
                if (UpdateFrame.this.taskThd.isAlive()) {
                    try {
                        UpdateFrame.this.taskThd.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                UpdateFrame.this.iu.notifyDestroy();
            }
        });
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.updateframe.setTitle(resourceBundle.getString(INFO_TITLE));
        this.txtUrl.setText(resourceBundle.getString(INFO_DOWNLOADING));
        this.table.getColumnModel().getColumn(0).setHeaderValue(resourceBundle.getString(INFO_DOWNLOAD_FILE));
        this.table.getColumnModel().getColumn(1).setHeaderValue(resourceBundle.getString(INFO_DOWNLOAD_PROGRESS));
        this.updateframe.repaint();
        this.updateButton.setText(resourceBundle.getString(INFO_DO_UPDATE));
        this.cancelButton.setText(resourceBundle.getString(INFO_DO_CANCEL));
    }

    public void toFront() {
        this.updateframe.toFront();
    }

    public File getDownloadTempDir() {
        return this.ud.getDownloadTempDir();
    }

    public void downloadFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!UpdateFrame.this.task.isCancel()) {
                    ResourceBundle resourceBundle = UpdateFrame.this.iu.bundle();
                    String string = resourceBundle.getString(UpdateFrame.ERROR_INTERNET_CONNECTION);
                    JOptionPane.showMessageDialog(UpdateFrame.this.updateframe, string);
                }
                UpdateFrame.this.iu.notifyDestroy();
                UpdateFrame.this.updateframe.dispose();
            }
        });
    }

    public void downloadFinished() {
        ResourceBundle resourceBundle = this.iu.bundle();
        String string = resourceBundle.getString(INFO_RESTART);
        int n = JOptionPane.showConfirmDialog(this.iu.getWindow(), string, null, 0, 3);
        if (n == 0) {
            SwingUtilities.invokeLater(this.updateNRestart);
        } else if (n == 1) {
            this.task.setCancel();
            this.iu.notifyDestroy();
            this.updateframe.dispose();
        } else {
            SwingUtilities.invokeLater(this.updateNext);
        }
    }

    public void setCurrentDownloadFile(DownloadFile downloadFile, URL uRL) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void updateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateFrame.this.table.repaint();
            }
        });
    }

    @Override
    public String getColumnName(int n) {
        ResourceBundle resourceBundle = this.iu.bundle();
        switch (n) {
            case 0: {
                return resourceBundle.getString(INFO_DOWNLOAD_FILE);
            }
            case 1: {
                return resourceBundle.getString(INFO_DOWNLOAD_PROGRESS);
            }
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.files.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DownloadFile downloadFile = this.files.get(n);
        switch (n2) {
            case 0: {
                return downloadFile.getRelativePath().replaceAll("owon.", "");
            }
            case 1: {
                return downloadFile.getPercent();
            }
        }
        return "?";
    }

    class UpdateNext
    implements Runnable {
        UpdateNext() {
        }

        @Override
        public void run() {
            if (UpdateFrame.this.updateframe.isActive()) {
                UpdateFrame.this.cancelButton.setEnabled(false);
                UpdateFrame.this.updateframe.dispose();
            }
            UpdateFrame.this.iu.notifyDestroy();
            UpdateFrame.this.ud.filesUpdate(UpdateFrame.this.files);
        }
    }

    class UpdateNRestart
    implements Runnable {
        UpdateNRestart() {
        }

        @Override
        public void run() {
            if (UpdateFrame.this.updateframe.isActive()) {
                UpdateFrame.this.cancelButton.setEnabled(false);
                UpdateFrame.this.updateframe.dispose();
            }
            UpdateFrame.this.iu.notifyDestroy();
            UpdateFrame.this.iu.close();
            UpdateFrame.this.ud.filesUpdate(UpdateFrame.this.files);
            String string = UpdateFrame.this.ud.getExecName();
            if (string.length() == 0) {
                UpdateFrame.this.iu.startAgain();
            } else {
                try {
                    Process process = Runtime.getRuntime().exec(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

