/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.update;

import com.owon.uppersoft.vds.core.update.IUpdatable;
import com.owon.uppersoft.vds.core.update.download.DownloadFile;
import com.owon.uppersoft.vds.util.FileUtil;
import com.owon.uppersoft.vds.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateDetection {
    private IUpdatable iu;
    private File localUpdateXML;
    private byte[] downloadBuffer = new byte[10240];
    private File downloadTempDir;
    public static final String String_bundle = "bundle";
    public static final String String_productType = "productType";
    public static final String String_os = "os";
    public static final String String_typeVersion = "typeVersion";
    public static final String String_eclipseproduct = "eclipseproduct";
    public static final String String_typeVersion3_3 = "3.3";
    public static final String String_productVersionStart = "productVersionStart";
    public static final String String_productVersionEnd = "productVersionEnd";
    public static final String String_urlbranch = "urlbranch";
    public static final String String_dir = "dir";
    public static final String String_localName = "localName";
    public static final String String_remoteName = "remoteName";
    public static final String String_updateType = "updateType";
    public static final String String_file = "file";
    public static final String String_plugins = "plugins";
    public static final String String_remote = "remote";
    public static final String String_id = "id";
    public static final String String_version = "version";
    public static final String String_delFile = "delFile";
    public static final String String_zip = "zip";
    public static final String String_format = "format";
    public static final String String_replace = "replace";
    public static final String String_execName = "execName";
    private List<DownloadFile> urls;
    private String execName = "";
    private File localDir;
    private String[] localFileNames;

    public UpdateDetection(IUpdatable iUpdatable) {
        this.iu = iUpdatable;
        this.downloadTempDir = new File(iUpdatable.getConfigurationDir(), "downloadTemp");
        FileUtil.deleteFile(this.downloadTempDir);
        this.downloadTempDir.mkdirs();
        this.localUpdateXML = new File(this.downloadTempDir, iUpdatable.getRelativePath());
        FileUtil.checkPath(this.localUpdateXML);
    }

    public File getLocalUpdateXML() {
        return this.localUpdateXML;
    }

    public IUpdatable getUpdatable() {
        return this.iu;
    }

    public File getDownloadTempDir() {
        return this.downloadTempDir;
    }

    public void filesUpdate(List<DownloadFile> list) {
        for (DownloadFile downloadFile : list) {
            File file = downloadFile.getLocalTempFile();
            String string = downloadFile.getDestFile();
            if (downloadFile.isZip()) {
                File file2 = new File(string);
                if (string.length() == 0) {
                    try {
                        file2 = file2.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                } else {
                    FileUtil.deleteFile(file2);
                }
                ZipUtil.unzip(file, file2);
                FileUtil.deleteFile(file);
                continue;
            }
            FileUtil.replaceFile(file, new File(string));
        }
        File file = new File(this.iu.getRelativePath());
        FileUtil.replaceFile(this.localUpdateXML, file);
    }

    public String detectServers() {
        List<String> list = this.iu.getUpdatableServers();
        for (String string : list) {
            File file = this.getFile(string, this.localUpdateXML);
            if (file != null) {
                return string;
            }
            int n = 0;
            if (n <= 0) continue;
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return null;
    }

    public File getFile(String string, File file) {
        try {
            FileOutputStream fileOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            int n = 0;
            URL uRL = new URL(new URL(string), this.iu.getRelativePath());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.setReadTimeout(3000);
            httpURLConnection.connect();
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            fileOutputStream = new FileOutputStream(file);
            while ((n = bufferedInputStream.read(this.downloadBuffer)) != -1) {
                fileOutputStream.write(this.downloadBuffer, 0, n);
            }
            fileOutputStream.close();
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return file;
    }

    public String getExecName() {
        return this.execName;
    }

    public List<DownloadFile> getDownloadFileURLs() {
        return this.urls;
    }

    public boolean isUpdate() {
        if (this.urls == null) {
            this.urls = new LinkedList<DownloadFile>();
        } else {
            this.urls.clear();
        }
        try {
            Object object;
            String string;
            String string2;
            Object object2;
            Object object3;
            Element element;
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new FileInputStream(this.localUpdateXML));
            inputSource.setEncoding("UTF-8");
            Document document = documentBuilder.parse(inputSource);
            Element element2 = document.getDocumentElement();
            Node node2 = null;
            String string3 = "";
            for (node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                boolean bl;
                if (node.getNodeType() != 1 || !node.getNodeName().equals(String_bundle)) continue;
                element = (Element)node;
                object3 = element.getAttribute(String_productType);
                object2 = element.getAttribute(String_os);
                string2 = element.getAttribute(String_typeVersion);
                string = element.getAttribute(String_productVersionStart);
                object = element.getAttribute(String_productVersionEnd);
                string3 = element.getAttribute(String_urlbranch);
                int n = UpdateDetection.compareVersion(string, this.iu.getProductVersion());
                int n2 = UpdateDetection.compareVersion((String)object, this.iu.getProductVersion());
                boolean bl2 = bl = ((String)object3).equals(String_eclipseproduct) && string2.equals(String_typeVersion3_3) && n <= 0 && n2 >= 0;
                if (!bl) continue;
                if (n2 == 0) {
                    return true;
                }
                node2 = element;
                break;
            }
            if (node2 == null) {
                return false;
            }
            object3 = null;
            for (object2 = node2.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                if (object2.getNodeType() != 1 || !object2.getNodeName().equals(String_dir)) continue;
                node = (Element)object2;
                string2 = node.getAttribute(String_remoteName);
                string = node.getAttribute(String_localName);
                if (string3.length() != 0) {
                    string2 = string3 + "/" + string2;
                }
                if (node.getAttribute(String_format).equals(String_zip) && node.getAttribute(String_updateType).equals(String_replace)) {
                    object = node.getAttribute(String_execName);
                    if (string.length() == 0) {
                        this.execName = object;
                    }
                    DownloadFile downloadFile = new DownloadFile(string, string2);
                    this.urls.add(downloadFile);
                    downloadFile.setZip(true);
                    continue;
                }
                this.localDir = new File(string);
                this.localDir.mkdirs();
                this.localFileNames = this.localDir.list();
                for (object = object2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    if (object.getNodeType() != 1 || (string7 = object.getNodeName()).equals(String_file) || (string6 = this.getLocalVer(string5 = (element = (Element)object).getAttribute(String_id), string4 = element.getAttribute(String_version))) == null) continue;
                    String string8 = element.getTextContent().trim();
                    boolean bl = string7.equals(String_dir) && element.getAttribute(String_format).equals(String_zip);
                    DownloadFile downloadFile = new DownloadFile(string + "/" + (bl ? string8.substring(0, string8.lastIndexOf(".")) : string8), string2 + "/" + string8);
                    this.urls.add(downloadFile);
                    downloadFile.setZip(bl);
                    if (string6.length() == 0) continue;
                    object3 = document.createElement(String_delFile);
                    element.appendChild((Node)object3);
                    object3.setTextContent(string6);
                }
            }
            if (object3 != null) {
                this.transFormerDoc(document);
            }
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public int transFormerDoc(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(this.localUpdateXML);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            return 3;
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
            return 3;
        }
        return 0;
    }

    private String getLocalVer(String string, String string2) {
        for (String string3 : this.localFileNames) {
            String string4;
            int n = string3.indexOf(string);
            if (n < 0) continue;
            int n2 = string3.lastIndexOf(".jar");
            if (n2 < 0) {
                n2 = string3.length();
            }
            if (UpdateDetection.compareVersion(string2, string4 = string3.substring(string.length() + 1, n2)) > 0) {
                return this.localDir.getName() + File.separator + string3;
            }
            return null;
        }
        return "";
    }

    public static int compareVersion(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            if (!stringTokenizer2.hasMoreTokens()) {
                return 1;
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = n2 - (n = Integer.parseInt(stringTokenizer2.nextToken()));
            if (n3 == 0) continue;
            return n3;
        }
        return stringTokenizer2.hasMoreTokens() ? -1 : 0;
    }

    public static boolean isVersionUpdatable(String string, String string2, String string3) {
        return UpdateDetection.compareVersion(string3, string) >= 0 && UpdateDetection.compareVersion(string, string2) >= 0;
    }

    public static void main(String[] stringArray) {
        System.err.println(UpdateDetection.isVersionUpdatable("1.0.0", "1.0.0", "1.0.2"));
    }
}

