/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.update;

import com.owon.uppersoft.vds.core.update.IUpdatable;
import com.owon.uppersoft.vds.core.update.UpdateDetection;
import com.owon.uppersoft.vds.core.update.UpdateFrame;
import com.owon.uppersoft.vds.core.update.download.DownloadFile;
import com.owon.uppersoft.vds.ui.dialog.ProgressMonitorDialog;
import com.owon.uppersoft.vds.util.FileUtil;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class CheckUpdateFrame
implements Runnable {
    public static final String ERROR_INTERNET_CONNECTION = "Error.InternetConnection";
    public static final String INFO_COMPARE_VERSION = "Info.CompareVersion";
    public static final String INFO_DOWN_MANUAL = "Info.DownManual";
    public static final String INFO_NEWEST_VERSION = "Info.NewestVersion";
    public static final String INFO_PROMPT_UPDATE = "Info.PromptUpdate";
    public static final String INFO_DO_CANCEL = "Info.DoCancel";
    public static final String INFO_DETECT_SERVERS = "Info.DetectServers";
    public static final String INFO_PROGRESS_TITLE = "Info.ProgressTitle";
    private IUpdatable iu;
    private Runnable r;
    private Thread thd;
    private String terminatMes;
    private String cancelMes;
    private ProgressMonitorDialog pbar;
    private UpdateFrame uf;

    public CheckUpdateFrame(IUpdatable iUpdatable) {
        this.iu = iUpdatable;
        this.pbar = new ProgressMonitorDialog(0, 100);
        this.localize();
    }

    public void toFront() {
        if (this.pbar != null) {
            this.pbar.toFront();
        }
        if (this.uf != null) {
            this.uf.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            try {
                List<DownloadFile> list;
                this.pbar.setValue(0);
                this.onCancel(INFO_DETECT_SERVERS, 5);
                final UpdateDetection updateDetection = new UpdateDetection(this.iu);
                final String string = updateDetection.detectServers();
                if (string == null) {
                    this.onTerminated(ERROR_INTERNET_CONNECTION);
                }
                this.onCancel(INFO_COMPARE_VERSION, 20);
                boolean bl = updateDetection.isUpdate();
                this.onCancel("", 40);
                if (!bl) {
                    this.onTerminated(INFO_DOWN_MANUAL);
                }
                if ((list = updateDetection.getDownloadFileURLs()).size() == 0) {
                    this.onCancel("", 60);
                    FileUtil.deleteFile(updateDetection.getLocalUpdateXML());
                    this.onCancel("", 80);
                    this.onTerminated(INFO_NEWEST_VERSION);
                    break block8;
                }
                this.onCancel(INFO_PROMPT_UPDATE, 80);
                boolean bl2 = this.iu.getWindow().isDisplayable();
                if (bl2) {
                    this.r = new Runnable(){

                        @Override
                        public void run() {
                            CheckUpdateFrame.this.uf = new UpdateFrame(updateDetection, string, list);
                        }
                    };
                    this.thd = new Thread(this.r);
                    this.thd.start();
                }
                return;
            }
            catch (Exception exception) {
            }
            finally {
                this.pbar.close();
            }
        }
    }

    protected void onTerminated(final String string) throws Exception {
        this.r = new Runnable(){

            @Override
            public void run() {
                CheckUpdateFrame.this.terminatMes = CheckUpdateFrame.this.iu.bundle().getString(string);
                JOptionPane.showMessageDialog(null, CheckUpdateFrame.this.terminatMes);
                CheckUpdateFrame.this.iu.notifyDestroy();
                CheckUpdateFrame.this.pbar.close();
            }
        };
        this.thd = new Thread(this.r);
        this.thd.start();
        throw new Exception();
    }

    protected void onCancel(String string, int n) throws Exception {
        this.pbar.setValue(n);
        if (string != null && string.length() != 0) {
            this.cancelMes = this.iu.bundle().getString(string);
            this.pbar.setNote(this.cancelMes);
        }
        if (!this.pbar.isDisplayable()) {
            if (this.uf == null) {
                this.iu.notifyDestroy();
            }
            this.thd.join();
            this.r = null;
            this.pbar.close();
            throw new Exception();
        }
        Thread.sleep(1400L);
    }

    public UpdateFrame getUpdateFrame() {
        return this.uf;
    }

    public CheckUpdateFrame getCheckUpdateFrame() {
        return this;
    }

    public void localize() {
        ResourceBundle resourceBundle = this.iu.bundle();
        this.pbar.setTitle(resourceBundle.getString(INFO_PROGRESS_TITLE));
        this.pbar.setMessage(resourceBundle.getString(INFO_DETECT_SERVERS));
        this.pbar.setButtonText(resourceBundle.getString(INFO_DO_CANCEL));
    }
}

