/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.sample;

import com.owon.uppersoft.vds.util.format.ParseUtil;
import java.math.BigDecimal;

public enum SampleRate {
    SAMPLE_3_2G,
    SAMPLE_2G,
    SAMPLE_1_6G,
    SAMPLE_1G,
    SAMPLE_800M,
    SAMPLE_500M,
    SAMPLE_400M,
    SAMPLE_250M,
    SAMPLE_200M,
    SAMPLE_125M,
    SAMPLE_100M,
    SAMPLE_50M,
    SAMPLE_25M,
    SAMPLE_12_5M,
    SAMPLE_10M,
    SAMPLE_5M,
    SAMPLE_2_5M,
    SAMPLE_1_25M,
    SAMPLE_1M,
    SAMPLE_500K,
    SAMPLE_250K,
    SAMPLE_125K,
    SAMPLE_100K,
    SAMPLE_50K,
    SAMPLE_25K,
    SAMPLE_12_5K,
    SAMPLE_10K,
    SAMPLE_5K,
    SAMPLE_2_5K,
    SAMPLE_1_25K,
    SAMPLE_1K,
    SAMPLE_500,
    SAMPLE_250,
    SAMPLE_125,
    SAMPLE_100,
    SAMPLE_50,
    SAMPLE_25,
    SAMPLE_12_5,
    SAMPLE_10,
    SAMPLE_5,
    SAMPLE_2_5,
    SAMPLE_1_25,
    SAMPLE_1,
    SAMPLE_0_5;

    private BigDecimal bdvalue;
    private String label;
    public static final String sampleRateUpdated = "sampleRateUpdated";
    private static final BigDecimal[] bdSamplesALL;
    public static final SampleRate[] VALUES;
    private static final String[] SamplesALL;

    private SampleRate() {
        String string2 = this.name();
        string2 = string2.substring("SAMPLE_".length());
        string2 = string2.replace("_", ".");
        this.bdvalue = ParseUtil.translate_KMGValue(string2);
        this.bdvalue = this.bdvalue.divide(BigDecimal.valueOf(1000L));
        this.label = "(" + string2 + "S/s)";
    }

    public String getSampleRateTxt() {
        return this.label;
    }

    public BigDecimal getBDValue_kHz() {
        return this.bdvalue;
    }

    public BigDecimal getBDValue_Hz() {
        return this.bdvalue.multiply(BigDecimal.valueOf(1000L));
    }

    public int compute(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2 = this.bdvalue;
        BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
        bigDecimal3 = bigDecimal3.multiply(BigDecimal.valueOf(n * 1000));
        return bigDecimal3.intValue();
    }

    public static void main(String[] stringArray) {
        SampleRate.getSampleRateByDiv1000(new BigDecimal("5.0E+8"));
    }

    public static final SampleRate getSampleRateByDiv1000(BigDecimal bigDecimal) {
        bigDecimal = bigDecimal.divide(BigDecimal.valueOf(1000L));
        return SampleRate.getSampleRate(bigDecimal);
    }

    public static final SampleRate getSampleRate(BigDecimal bigDecimal) {
        for (SampleRate sampleRate : VALUES) {
            if (bigDecimal.compareTo(sampleRate.bdvalue) != 0) continue;
            return sampleRate;
        }
        System.err.println("err:" + bigDecimal);
        return null;
    }

    static {
        bdSamplesALL = new BigDecimal[]{BigDecimal.valueOf(3200000L), BigDecimal.valueOf(2000000L), BigDecimal.valueOf(1600000L), BigDecimal.valueOf(1000000L), BigDecimal.valueOf(800000L), BigDecimal.valueOf(500000L), BigDecimal.valueOf(400000L), BigDecimal.valueOf(250000L), BigDecimal.valueOf(200000L), BigDecimal.valueOf(125000L), BigDecimal.valueOf(100000L), BigDecimal.valueOf(50000L), BigDecimal.valueOf(25000L), BigDecimal.valueOf(12500L), BigDecimal.valueOf(10000L), BigDecimal.valueOf(5000L), BigDecimal.valueOf(2500L), BigDecimal.valueOf(1250L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(500L), BigDecimal.valueOf(250L), BigDecimal.valueOf(125L), BigDecimal.valueOf(100L), BigDecimal.valueOf(50L), BigDecimal.valueOf(25L), new BigDecimal("12.5"), BigDecimal.valueOf(10L), BigDecimal.valueOf(5L), new BigDecimal("2.5"), new BigDecimal("1.25"), BigDecimal.valueOf(1L), new BigDecimal("0.5"), new BigDecimal("0.25"), new BigDecimal("0.125"), new BigDecimal("0.1"), new BigDecimal("0.05"), new BigDecimal("0.025"), new BigDecimal("0.0125"), new BigDecimal("0.01"), new BigDecimal("0.005"), new BigDecimal("0.0025"), new BigDecimal("0.00125"), new BigDecimal("0.001"), new BigDecimal("0.0005")};
        VALUES = SampleRate.values();
        SamplesALL = new String[]{"(3.2GS/s)", "(2GS/s)", "(1.6GS/s)", "(1GS/s)", "(800MS/s)", "(500MS/s)", "(400MS/s)", "(250MS/s)", "(200MS/s)", "(125MS/s)", "(100MS/s)", "(50MS/s)", "(25MS/s)", "(12.5MS/s)", "(10MS/s)", "(5MS/s)", "(2.5MS/s)", "(1.25MS/s)", "(1MS/s)", "(500KS/s)", "(250KS/s)", "(125KS/s)", "(100KS/s)", "(50KS/s)", "(25KS/s)", "(12.5KS/s)", "(10KS/s)", "(5KS/s)", "(2.5KS/s)", "(1.25KS/s)", "(1KS/s)", "(500S/s)", "(250S/s)", "(125S/s)", "(100S/s)", "(50S/s)", "(25S/s)", "(12.5S/s)", "(10S/s)", "(5S/s)", "(2.5S/s)", "(1.25S/s)", "(1S/s)", "(0.5S/s)"};
    }
}

