/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.pref;

import com.owon.uppersoft.vds.ui.resource.SwingResourceManager;
import com.owon.uppersoft.vds.util.Pref;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class StaticPref {
    protected String productId;
    protected String manufacturerId;
    protected String serialId;
    protected String versionId;
    protected String internalVersionId;
    protected String updateServer;
    protected String website;
    protected boolean updatable;
    protected String launcher;
    protected String localeDir;
    protected String exampleDir;
    protected String reinstallUSBDriverCommand;
    protected int fileHisCount;
    protected String[] localeNames;
    public static final String Neutral_String = "neutral";
    public static final String OWON_String = "OWON";
    public static final String LogoPath = "/com/owon/uppersoft/dso/image/logo.png";

    public StaticPref(InputStream inputStream) {
        this.load(inputStream);
    }

    public static void main(String[] stringArray) {
        InputStream inputStream = StaticPref.class.getResourceAsStream("/com/owon/uppersoft/dso/pref/default.ini");
        StaticPref staticPref = new StaticPref(inputStream);
        System.out.println(staticPref.isNeutral());
        System.out.println(staticPref.getUpdateXML());
        System.out.println(staticPref.getVersionText());
    }

    protected void load(String string) {
        this.load(new File(string));
    }

    protected void load(File file) {
        try {
            this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    protected void load(InputStream inputStream) {
        Pref pref = new Pref();
        try {
            pref.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.load(pref);
    }

    public void load(Pref pref) {
        this.productId = pref.getProperty("productId");
        this.manufacturerId = pref.getProperty("manufacturerId");
        this.versionId = pref.getProperty("versionId");
        this.serialId = pref.getProperty("serialId");
        this.internalVersionId = pref.getProperty("internalVersionId");
        this.updateServer = pref.getProperty("updateServer");
        this.updatable = pref.loadBoolean("updatable");
        this.launcher = pref.getProperty("launcher");
        this.localeDir = pref.getProperty("localeDir");
        this.exampleDir = pref.getProperty("exampleDir");
        this.reinstallUSBDriverCommand = pref.getProperty("reinstallUSBDriverCommand");
        this.fileHisCount = pref.loadInt("fileHisCount");
        String string = pref.getProperty("availableLocales", "");
        this.localeNames = string.split(";");
        this.website = pref.getProperty("website").trim();
    }

    public String[] getAvailableLocaleNames() {
        return this.localeNames;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String string) {
        this.productId = string;
    }

    public String getManufacturerId() {
        return this.manufacturerId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getInternalVersionId() {
        return this.internalVersionId;
    }

    public String getUpdateServer() {
        return this.updateServer;
    }

    public boolean getUpdatable() {
        return this.updatable;
    }

    public String getLauncher() {
        return this.launcher;
    }

    protected String getExampleDir() {
        return this.exampleDir;
    }

    protected int getFileHisCount() {
        return this.fileHisCount;
    }

    protected String getLocaleDir() {
        return this.localeDir;
    }

    public String getUpdateXML() {
        return this.manufacturerId + "_" + this.getSerialId() + ".xml";
    }

    public String getVersionText() {
        return this.versionId + " (build " + this.internalVersionId + ")";
    }

    public String getSerialId() {
        return this.serialId;
    }

    public boolean isNeutral() {
        return this.manufacturerId.equalsIgnoreCase(Neutral_String);
    }

    public boolean isOwon() {
        return this.manufacturerId.equalsIgnoreCase(OWON_String);
    }

    public String getReinstallUSBDriverCommand() {
        return this.reinstallUSBDriverCommand;
    }

    public String getWebsite() {
        return this.website;
    }

    protected String getOEMLogoPath() {
        return "";
    }

    public Icon getLogoIcon(StaticPref staticPref) {
        String string = LogoPath;
        if (!staticPref.isOwon()) {
            string = this.getOEMLogoPath();
        }
        ImageIcon imageIcon = SwingResourceManager.getIcon(StaticPref.class, string);
        return imageIcon;
    }
}

