/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.pref;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.util.DBG;
import com.owon.uppersoft.dso.util.PropertiesItem;
import com.owon.uppersoft.vds.core.aspect.help.ILoadPersist;
import com.owon.uppersoft.vds.core.pref.StaticPref;
import com.owon.uppersoft.vds.data.LocaleObject;
import com.owon.uppersoft.vds.util.Pref;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Config
implements PropertiesItem {
    private Pref defalutProperties;
    private Pref sessionProperties;
    private final StaticPref staticPref;
    private List<LocaleObject> locales;
    private List<LocaleObject> locales_support_native;
    private int localeIndex = 0;
    private Pref save_properties;

    protected int getDefaultLocaleIndex(Locale locale) {
        int n = this.locales.size();
        for (int i = 0; i < n; ++i) {
            if (!this.locales.get(i).getLocale().equals(locale)) continue;
            return i;
        }
        return -1;
    }

    public List<LocaleObject> getSupport_native_Locales() {
        return this.locales_support_native;
    }

    public Config(Pref pref, Pref pref2, InputStream inputStream, boolean bl) {
        this.sessionProperties = pref;
        this.defalutProperties = pref2;
        DBG.prepareLogType(pref.loadInt("log_type"), new File(Platform.DATA_DIR));
        this.staticPref = this.createStaticPref(inputStream);
        this.initLocales();
        Locale locale = bl ? Locale.getDefault() : pref.loadLocale();
        System.out.println("locale: " + locale + ", " + Locale.getDefault().toString() + ", " + bl);
        this.loadConfigurationFromProperties(locale);
        I18nProvider.updateLocale(this.locales.get(this.localeIndex).getLocale());
    }

    protected StaticPref createStaticPref(InputStream inputStream) {
        return new StaticPref(inputStream);
    }

    private void initLocales() {
        String[] stringArray = this.getStaticPref().getAvailableLocaleNames();
        int n = stringArray.length;
        this.locales = new LinkedList<LocaleObject>();
        this.locales_support_native = new LinkedList<LocaleObject>();
        for (int i = 0; i < n; ++i) {
            LocaleObject localeObject = new LocaleObject(Pref.forLocale(stringArray[i]));
            this.locales.add(localeObject);
            this.locales_support_native.add(localeObject);
        }
    }

    private void loadConfigurationFromProperties(Locale locale) {
        this.setLocaleIndex(this.getDefaultLocaleIndex(locale));
        if (this.localeIndex < 0) {
            this.setLocaleIndex(0);
        }
    }

    protected void persistConfigurationToProperties(Pref pref) {
        pref.persistLocale(this.locales.get(this.localeIndex).getLocale());
    }

    public void persist(File file, ILoadPersist iLoadPersist) {
        this.save_properties = this.defalutProperties;
        iLoadPersist.persist(this.save_properties);
        this.persistConfigurationToProperties(this.save_properties);
        try {
            this.save_properties.store(new FileOutputStream(file), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setLocaleIndex(int n) {
        this.localeIndex = n;
    }

    public int getLocaleIndex() {
        return this.localeIndex;
    }

    public StaticPref getStaticPref() {
        return this.staticPref;
    }

    public List<LocaleObject> getLocales() {
        return this.locales;
    }

    public void updateLocales(List<LocaleObject> list) {
    }

    public Pref getSaveProperties() {
        return this.save_properties;
    }

    public Pref getFactoryProperties() {
        return (Pref)this.defalutProperties.clone();
    }

    public Pref getSessionProperties() {
        return this.sessionProperties;
    }

    public void setSessionProperties(Pref pref) {
        this.sessionProperties = pref;
    }
}

