/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.measure;

import com.owon.uppersoft.dso.function.Markable;
import com.owon.uppersoft.dso.function.perspective.CompositeWaveForm;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.help.IWF;
import com.owon.uppersoft.vds.core.measure.MeasureADC;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.core.measure.VR;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public class VerticalValueMeasure {
    public int Vbase;
    public int Vtop;
    public int Vamp;
    public int VmaxPos;
    public int VminPos;
    public int Vmax;
    public int Vmin;
    public int Vpp;
    private int Vsum;
    private int Vnum;
    public double Vavg;
    public double Vrms;
    private float Overshoot;
    private float Preshoot;
    private static int kk = 256;
    private static int[] MEM_1k;
    public boolean Vmax_VminBeyond;

    public void getVtopVbase(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3;
        VerticalValueMeasure.rewind();
        byte[] byArray = byteBuffer.array();
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        for (n3 = n4; n3 < n5; ++n3) {
            int n6 = byArray[n4] + 128;
            MEM_1k[n6] = MEM_1k[n6] + 1;
        }
        int n7 = MEM_1k.length;
        int n8 = (int)(this.Vavg + 128.0 + (double)n);
        int n9 = MEM_1k[0];
        int n10 = MEM_1k[n8];
        int n11 = n8;
        int n12 = n8;
        for (n2 = 0; n2 < n8; ++n2) {
            n3 = MEM_1k[n2];
            if (n3 <= n9) continue;
            n9 = n3;
            n11 = n2;
        }
        for (n2 = n8; n2 < n7; ++n2) {
            n3 = MEM_1k[n2];
            if (n3 <= n10) continue;
            n10 = n3;
            n12 = n2;
        }
        this.Vtop = n12 - 128 - n;
        this.Vbase = n11 - 128 - n;
        this.Vamp = Math.abs(this.Vtop - this.Vbase);
    }

    public void getVtopVbase(IntBuffer intBuffer) {
        int n;
        int n2;
        int n3;
        double d;
        VerticalValueMeasure.rewind();
        int[] nArray = intBuffer.array();
        int n4 = intBuffer.position();
        int n5 = intBuffer.limit();
        double d2 = d = this.Vpp < 256 ? 1.0 : (double)(256 / this.Vpp);
        if (d == 1.0) {
            for (n3 = n4; n3 < n5; ++n3) {
                int n6 = nArray[n3] - this.Vmin;
                MEM_1k[n6] = MEM_1k[n6] + 1;
            }
        } else {
            for (n3 = n4; n3 < n5; ++n3) {
                int n7 = (int)((double)(nArray[n3] - this.Vmin) * d);
                MEM_1k[n7] = MEM_1k[n7] + 1;
            }
        }
        n3 = (int)((this.Vavg - (double)this.Vmin) * d);
        int n8 = MEM_1k[0];
        int n9 = MEM_1k[n3];
        int n10 = n3;
        int n11 = n3;
        for (n2 = 0; n2 < n3; ++n2) {
            n = MEM_1k[n2];
            if (n <= n8) continue;
            n8 = n;
            n10 = n2;
        }
        for (n2 = n3; n2 < MEM_1k.length; ++n2) {
            n = MEM_1k[n2];
            if (n <= n9) continue;
            n9 = n;
            n11 = n2;
        }
        this.Vbase = (int)((double)n10 / d + (double)this.Vmin);
        this.Vtop = (int)((double)n11 / d + (double)this.Vmin);
        this.Vamp = Math.abs(this.Vtop - this.Vbase);
    }

    private static void rewind() {
        if (MEM_1k == null || MEM_1k.length < kk) {
            MEM_1k = new int[kk];
        }
        Arrays.fill(MEM_1k, 0);
    }

    public void getVmaxVmin(MeasureADC measureADC) {
        int n;
        int n2;
        int[] nArray = measureADC.array;
        int n3 = measureADC.l;
        int n4 = n2 = measureADC.p;
        int n5 = n2;
        int n6 = 0;
        int n7 = n3 - n2;
        long l = 0L;
        int n8 = n = nArray[n2];
        int n9 = n2;
        while (n2 < n3) {
            int n10 = nArray[n2];
            if (n10 > n8) {
                n8 = n10;
                n4 = n2;
            } else if (n10 < n) {
                n = n10;
                n5 = n2;
            }
            n6 += n10;
            l += (long)(n10 * n10);
            ++n2;
        }
        n2 = n9;
        this.Vmax = n8;
        this.Vmin = n;
        this.VmaxPos = n4;
        this.VminPos = n5;
        this.Vpp = Math.abs(this.Vmax - this.Vmin);
        this.Vsum = n6;
        this.Vnum = n7;
        this.Vavg = (double)n6 / (double)n7;
        this.Vrms = Math.sqrt((double)l / (double)n7);
    }

    private void getShoots() {
        if (this.Vamp == 0) {
            this.Preshoot = -1.0f;
            this.Overshoot = -1.0f;
        } else {
            this.Overshoot = (float)(this.Vmax - this.Vtop) / (float)this.Vamp;
            this.Preshoot = (float)(this.Vbase - this.Vmin) / (float)this.Vamp;
        }
    }

    private void rest(Markable markable, boolean bl, double d, double d2, VR[] vRArray, boolean bl2, boolean bl3) {
        this.Vmax_VminBeyond = bl2 || bl3;
        boolean bl4 = this.Vmax == this.Vmin;
        boolean bl5 = this.Vtop > this.Vmax || bl4;
        boolean bl6 = this.Vbase < this.Vmin || bl4;
        boolean bl7 = bl5 || bl6;
        VR.setVerticalValue(markable, vRArray, MeasureT.PKPK, (double)this.Vpp * d2, this.Vmax_VminBeyond, bl4, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.MAX, (double)this.Vmax * d2, this.Vmax_VminBeyond, bl4, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.MIN, (double)this.Vmin * d2, this.Vmax_VminBeyond, bl4, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.AVERage, this.Vavg * d2, this.Vmax_VminBeyond, bl4, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.CYCRms, this.Vrms * d2, this.Vmax_VminBeyond, bl4, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.VAMP, (double)this.Vamp * d2, this.Vmax_VminBeyond, bl7, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.VTOP, (double)this.Vtop * d2, this.Vmax_VminBeyond, bl5, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.VBASe, (double)this.Vbase * d2, this.Vmax_VminBeyond, bl6, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.OVERshoot, this.Overshoot, this.Vmax_VminBeyond, bl7, bl);
        VR.setVerticalValue(markable, vRArray, MeasureT.PREShoot, this.Preshoot, this.Vmax_VminBeyond, bl7, bl);
    }

    public void doMeasure(VR[] vRArray, IWF iWF, boolean bl, double d, double d2, ByteBuffer byteBuffer) {
        this.getVmaxVmin(iWF.getMeasureADC());
        this.getVtopVbase(byteBuffer, iWF.getFirstLoadPos0());
        this.getShoots();
        ChannelInfo channelInfo = ((WaveForm)iWF).wfi.ci;
        this.rest(channelInfo, bl, d, d2, vRArray, iWF.isADCBeyondMax(), iWF.isADCBeyondMin());
    }

    public void doMeasure(VR[] vRArray, CompositeWaveForm compositeWaveForm, double d, double d2, IntBuffer intBuffer) {
        this.getVmaxVmin(compositeWaveForm.getMeasureADC());
        this.getVtopVbase(intBuffer);
        this.getShoots();
        CompositeWaveForm compositeWaveForm2 = compositeWaveForm;
        this.rest(compositeWaveForm2, false, d, d2, vRArray, compositeWaveForm.isADCBeyondMax(), compositeWaveForm.isADCBeyondMin());
    }
}

