/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.measure;

import com.owon.uppersoft.dso.function.Markable;
import com.owon.uppersoft.vds.core.measure.MeasureT;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;

public class VR {
    public boolean on = false;
    public double v;
    public Object mt;
    public String vu = " ";

    public VR(Object object) {
        this.mt = object;
    }

    public String toString() {
        return this.mt.toString();
    }

    public static VR[] createVRs() {
        MeasureT[] measureTArray = MeasureT.VALUES;
        int n = measureTArray.length;
        VR[] vRArray = new VR[n];
        for (int i = 0; i < n; ++i) {
            vRArray[i] = new VR((Object)measureTArray[i]);
        }
        return vRArray;
    }

    public static void setHorizontalValue(VR[] vRArray, MeasureT measureT, double d, boolean bl, boolean bl2, double d2) {
        int n = measureT.idx;
        vRArray[n].v = d;
        if (bl2) {
            switch (measureT) {
                case PDUTy: 
                case NDUTy: 
                case FREQuency: 
                case PERiod: 
                case RTime: 
                case FTime: 
                case PWIDth: 
                case NWIDth: {
                    vRArray[n].vu = "?";
                    return;
                }
            }
        }
        switch (measureT) {
            case FREQuency: {
                if (d2 > 0.0 && d > d2) {
                    vRArray[n].vu = "?";
                    break;
                }
                if (d <= 0.0 || bl) {
                    vRArray[n].vu = "?";
                    break;
                }
                vRArray[n].vu = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz(d);
                break;
            }
            case PERiod: {
                double d3 = 1.0 / d2;
                if (d3 > 0.0 && d < d3) {
                    vRArray[n].vu = "?";
                    break;
                }
            }
            case PWIDth: 
            case NWIDth: {
                if (d <= 0.0 || bl) {
                    vRArray[n].vu = "?";
                    break;
                }
                vRArray[n].vu = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d * 1000.0);
                break;
            }
            case PDUTy: 
            case NDUTy: {
                if (d < 0.0 || bl) {
                    vRArray[n].vu = "?";
                    break;
                }
                vRArray[n].vu = UnitConversionUtil.getPercent(d);
                break;
            }
            default: {
                VR.errprintln("unknow MeasureT: " + (Object)((Object)measureT));
            }
        }
    }

    public static void setVerticalValue(Markable markable, VR[] vRArray, MeasureT measureT, double d, boolean bl, boolean bl2, boolean bl3) {
        int n = measureT.idx;
        vRArray[n].v = d;
        if (bl3) {
            switch (measureT) {
                case OVERshoot: 
                case PREShoot: {
                    vRArray[n].vu = "?";
                    return;
                }
            }
        }
        switch (measureT) {
            case OVERshoot: 
            case PREShoot: {
                if (d < 0.0) {
                    vRArray[n].vu = "?";
                    break;
                }
                vRArray[n].vu = UnitConversionUtil.getPercent(d);
                break;
            }
            case PKPK: 
            case MAX: 
            case MIN: 
            case AVERage: 
            case CYCRms: 
            case VAMP: 
            case VTOP: 
            case VBASe: {
                if (bl2) {
                    vRArray[n].vu = "?";
                    break;
                }
                vRArray[n].vu = markable.getValueLabel(d);
                if (!bl) break;
                vRArray[n].vu = vRArray[n].vu + "?";
                break;
            }
            default: {
                VR.errprintln("unknow MeasureT: " + (Object)((Object)measureT));
            }
        }
    }

    public static void setRise_FallTimeValue(VR[] vRArray, MeasureT measureT, double d, boolean bl, int n, boolean bl2) {
        int n2 = measureT.idx;
        vRArray[n2].v = d;
        if (bl2) {
            vRArray[n2].vu = "?";
            return;
        }
        switch (measureT) {
            case RTime: 
            case FTime: {
                if (d <= 0.0 || bl) {
                    vRArray[n2].vu = "?";
                    break;
                }
                vRArray[n2].vu = UnitConversionUtil.getSimplifiedTimebaseLabel_mS(d * 1000.0);
                if (n != 1) break;
                vRArray[n2].vu = "<" + vRArray[n2].vu;
                break;
            }
            default: {
                VR.errprintln("unknow MeasureT: " + (Object)((Object)measureT));
            }
        }
    }

    private static void errprintln(String string) {
        System.err.println(string);
    }
}

