/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.measure;

import com.owon.uppersoft.vds.core.measure.MeasureElem;
import com.owon.uppersoft.vds.ui.widget.custom.CCheckBox;
import com.owon.uppersoft.vds.util.Pref;
import java.util.LinkedList;

public class MeasureModel {
    public static final String Refresh_MeasurePane_Selected = "refresh_MeasurePane_Selected";
    private final int columnMax = 7;
    private int channelNumbers;
    public LinkedList<MeasureElem> othMTlinked = new LinkedList();
    public LinkedList<Integer> MTlinked = new LinkedList();
    private LinkedList<Integer> CHlinked = new LinkedList();

    public MeasureModel(int n, Pref pref) {
        this.channelNumbers = n;
        this.load(pref);
    }

    public boolean isCHlinkEmpty() {
        return this.CHlinked.isEmpty();
    }

    public boolean isMTlinkEmpty() {
        return this.MTlinked.isEmpty();
    }

    private boolean isOthlinkEmpty() {
        return this.getOthLinkedCount() == 0;
    }

    public int getOthLinkedCount() {
        int n = 0;
        for (MeasureElem measureElem : this.othMTlinked) {
            if (!measureElem.on) continue;
            ++n;
        }
        return n;
    }

    public int getColumnMax() {
        return this.isOthlinkEmpty() ? 7 : 6;
    }

    public int getColumnCount() {
        return this.MTlinked.size();
    }

    public void persist(Pref pref) {
        pref.persistIntegerList("MeasureChannels", this.CHlinked, ",");
        pref.persistIntegerList("MeasureTypes", this.MTlinked, ",");
        pref.persistMeasureElem(this.othMTlinked);
    }

    public void load(Pref pref) {
        this.CHlinked = pref.loadIntegerList("MeasureChannels", ",");
        this.MTlinked = pref.loadIntegerList("MeasureTypes", ",");
        LinkedList<Integer> linkedList = pref.loadIntegerList("MeasureDelayCode", ",");
        this.assembleOthMeasureQueue(linkedList);
    }

    private void assembleOthMeasureQueue(LinkedList<Integer> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        if (this.channelNumbers >= 2) {
            linkedList2.add("AutoMeasure.EdgeDelay1->2");
            linkedList2.add("AutoMeasure._EdgeDealy1->2");
            linkedList3.add("RDELAY12");
            linkedList3.add("FDELAY12");
        }
        if (this.channelNumbers >= 4) {
            linkedList2.add("AutoMeasure.EdgeDelay3->4");
            linkedList2.add("AutoMeasure._EdgeDealy3->4");
            linkedList3.add("RDELAY34");
            linkedList3.add("FDELAY34");
        }
        this.othMTlinked.clear();
        int n = linkedList2.size();
        for (int i = 0; i < n; ++i) {
            MeasureElem measureElem = new MeasureElem(i);
            measureElem.on = false;
            if (linkedList.contains(i)) {
                measureElem.on = true;
            }
            measureElem.label = (String)linkedList2.get(i);
            measureElem.name = (String)linkedList3.get(i);
            measureElem.Value = 0.0;
            measureElem.vu = "?";
            this.othMTlinked.add(measureElem);
        }
    }

    public boolean enforcePermit() {
        boolean bl = false;
        int n = this.getColumnCount();
        int n2 = this.getOthLinkedCount();
        if (n > 0 || n2 > 0) {
            bl = true;
        }
        return bl;
    }

    public void addChElem(int n) {
        if (!this.CHlinked.contains(n)) {
            this.CHlinked.add(n);
        }
    }

    public void delChElem(int n) {
        if (this.CHlinked.contains(n)) {
            this.CHlinked.remove((Object)n);
        }
    }

    public void addMtElem(int n) {
        if (this.MTlinked.contains(n)) {
            return;
        }
        if (this.MTlinked.size() >= this.getColumnMax()) {
            this.MTlinked.removeFirst();
        }
        this.MTlinked.add(n);
    }

    public boolean delMtElem(Integer n) {
        if (this.MTlinked.contains(n)) {
            this.MTlinked.remove(n);
            return true;
        }
        return false;
    }

    public void moveMtElem(int n, int n2) {
        if (n == n2 || n2 < 0 || n < 0) {
            return;
        }
        Integer n3 = this.MTlinked.get(n);
        if (n > n2) {
            this.MTlinked.add(n2, n3);
            this.MTlinked.remove(++n);
        } else {
            this.MTlinked.add(++n2, n3);
            this.MTlinked.remove(n);
        }
    }

    public double getDelayValue(String string, int n) {
        String string2 = n < 2 ? "12" : "34";
        string = (string + string2).toUpperCase();
        for (MeasureElem measureElem : this.othMTlinked) {
            String string3 = measureElem.name.toUpperCase();
            if (!string.equalsIgnoreCase(string3)) continue;
            return measureElem.Value;
        }
        return -1.0;
    }

    public boolean addOrDelDelay(boolean bl, String string) {
        String string2;
        boolean bl2 = false;
        string = string.toUpperCase();
        for (int i = 0; i < this.othMTlinked.size() && (!(string2 = this.othMTlinked.get((int)i).name.toUpperCase()).startsWith(string) || (bl2 = this.selectDelay(bl, i))); ++i) {
        }
        return bl2;
    }

    public boolean selectDelay(boolean bl, int n) {
        int n2 = this.othMTlinked.size();
        if (n < 0 || n > n2 - 1) {
            return false;
        }
        MeasureElem measureElem = this.othMTlinked.get(n);
        if (measureElem == null) {
            return false;
        }
        if (bl && this.MTlinked.size() >= 7) {
            this.MTlinked.removeLast();
        }
        measureElem.on = bl;
        return true;
    }

    public void removeAllMeasures() {
        this.CHlinked.clear();
        this.MTlinked.clear();
        for (MeasureElem measureElem : this.othMTlinked) {
            measureElem.on = false;
        }
    }

    public void updateMeasureSelected(CCheckBox[] cCheckBoxArray, CCheckBox[] cCheckBoxArray2, CCheckBox[] cCheckBoxArray3) {
        boolean bl;
        int n;
        for (n = 0; n < cCheckBoxArray.length; ++n) {
            bl = this.CHlinked.contains(n);
            cCheckBoxArray[n].setSelected(bl);
        }
        for (n = 0; n < cCheckBoxArray2.length; ++n) {
            bl = this.MTlinked.contains(n);
            cCheckBoxArray2[n].setSelected(bl);
        }
        for (MeasureElem measureElem : this.othMTlinked) {
            cCheckBoxArray3[measureElem.idx].setSelected(measureElem.on);
        }
    }

    public void removeSelCol(int n) {
        if (n >= 0 && n < this.getColumnCount()) {
            this.MTlinked.get(n);
            this.MTlinked.remove(n);
        }
    }

    public String getCHlinkElem() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.CHlinked.isEmpty()) {
            stringBuilder.append("CHANNEL ALL CLOSE");
            return stringBuilder.toString();
        }
        for (Integer n : this.CHlinked) {
            if (n >= this.channelNumbers) continue;
            stringBuilder.append("CH" + (n + 1) + " ");
        }
        return stringBuilder.toString();
    }

    public boolean hasCHlinkElem(Integer n) {
        return this.CHlinked.contains(n);
    }

    @Deprecated
    private void printMTlink() {
        for (Integer n : this.MTlinked) {
            System.out.print("," + n);
        }
        System.out.println();
    }

    @Deprecated
    public boolean addOrDelRDelay(boolean bl) {
        boolean bl2 = false;
        bl2 = this.selectDelay(bl, 0);
        if (this.othMTlinked.size() >= 4) {
            bl2 = bl2 && this.selectDelay(bl, 2);
        }
        return bl2;
    }

    @Deprecated
    public boolean addOrDelFDelay(boolean bl) {
        boolean bl2 = false;
        bl2 = this.selectDelay(bl, 1);
        if (this.othMTlinked.size() >= 4) {
            bl2 = bl2 && this.selectDelay(bl, 3);
        }
        return bl2;
    }

    @Deprecated
    public Integer getMeasureTypeElem(int n) {
        if (n >= 0 && n < this.MTlinked.size()) {
            return this.MTlinked.get(n);
        }
        return null;
    }
}

