/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.machine;

import com.owon.uppersoft.vds.core.sample.SampleRate;
import com.owon.uppersoft.vds.util.PrimaryTypeUtil;
import com.owon.uppersoft.vds.util.format.ParseUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.StringTokenizer;

public abstract class MachineInfo {
    protected static final String MachineInfo_DeepMemory = "DeepMemory";
    protected static final String MachineInfo_SlowMoveTimebase = "SlowMoveTimebase";
    protected static final String MachineInfo_ProbeRate = "ProbeRate";
    protected static final String MachineInfo_Voltbase = "Voltbase";
    protected static final String MachineInfo_Timebase = "Timebase";
    protected static final String MachineInfo_ChannelConfig = "ChannelConfig";
    protected static final String MachineInfo_Grids = "Grids";
    protected static final String MachineInfo_ADCSampleRate = "ADCSampleRate";
    protected static final String MachineInfo_FFTTimebase = "FFTTimebase";
    private static final String N_A = "N/A";
    public String[] FFTTimeBases;
    public BigDecimal[] BDFFTTimeBases;
    protected SampleRate[] channelMaxSampleRate;
    private int channel_numbers = 2;
    public int sampling_configuration_count = 2;
    public String SlowMoveTimebase;
    public String[] ProbeTexts;
    public Integer[] ProbeMulties;
    public int[][] intVOLTAGE;
    public BigDecimal[] bdTIMEBASE;
    public String[] DEEP;
    public int[] DEEPValue;
    public String[] TIMEBASE;
    protected SampleRate[][] SampleRates;
    protected int[][] FullScreenData;
    private static final int SampleType_1CH = 0;
    private static final int SampleType_2CH = 1;
    private static final int SampleType_4CH = 2;
    private static final int Channel_NONE = -1;
    private static final int Pos0Range_RelayThredshold_IntVoltage = 100;
    private static final int Pos0Range_RelayThredshold_ExtraDivdior = 50;
    private static final int Pos0Range_RelayThredshold_Dividor = 1000;
    private SampleRate ADC_CLOCK_SampleRate;
    private int SlowMoveIdx = -1;
    private int deepNum;

    private void setup(InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                int n = (string = string.trim()).length();
                if (n == 0 || string.startsWith("//") || string.charAt(0) != '[') continue;
                int n2 = string.indexOf(93, 1);
                String string2 = string.substring(1, n2);
                this.handleItem(bufferedReader, string2);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.endOfInit();
    }

    private void handleItem(BufferedReader bufferedReader, String string) throws IOException {
        if (string.equals(MachineInfo_ADCSampleRate)) {
            String string2 = this.nextTrimLine(bufferedReader);
            this.ADC_CLOCK_SampleRate = SampleRate.valueOf(string2);
        } else if (string.equals(MachineInfo_DeepMemory)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n = stringTokenizer.countTokens();
            this.DEEP = new String[n];
            this.DEEPValue = new int[n];
            this.deepNum = n;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                this.DEEP[n2] = string3 = ParseUtil.trimQuotes(stringTokenizer.nextToken());
                this.DEEPValue[n2] = ParseUtil.translate_KM(string3);
                ++n2;
            }
        } else if (string.equals(MachineInfo_SlowMoveTimebase)) {
            String string4 = this.nextTrimLine(bufferedReader);
            this.SlowMoveTimebase = ParseUtil.trimQuotes(string4);
        } else if (string.equals(MachineInfo_ProbeRate)) {
            int n;
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n3 = n = stringTokenizer.countTokens();
            this.ProbeTexts = new String[n3];
            this.ProbeMulties = new Integer[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = ParseUtil.translateInt(stringTokenizer.nextToken());
                this.ProbeTexts[n4] = "x" + n5;
                this.ProbeMulties[n4] = n5;
                ++n4;
            }
        } else if (string.equals(MachineInfo_Voltbase)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n = stringTokenizer.countTokens();
            int n6 = this.ProbeMulties.length;
            this.intVOLTAGE = new int[n6][n];
            int n7 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                int n8 = ParseUtil.translateInt(stringTokenizer.nextToken());
                for (int i = 0; i < n6; ++i) {
                    this.intVOLTAGE[i][n7] = n8 * this.ProbeMulties[i];
                }
                ++n7;
            }
        } else if (string.equals(MachineInfo_Timebase)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n = stringTokenizer.countTokens();
            this.TIMEBASE = new String[n];
            this.bdTIMEBASE = new BigDecimal[n];
            int n9 = n;
            int n10 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string5;
                this.TIMEBASE[n10] = string5 = ParseUtil.trimQuotes(stringTokenizer.nextToken());
                this.bdTIMEBASE[n10] = ParseUtil.translate_numS(string5);
                ++n10;
            }
            this.SampleRates = new SampleRate[this.deepNum * this.sampling_configuration_count][n9];
            this.FullScreenData = new int[this.deepNum * this.sampling_configuration_count][n9];
        } else if (string.equals(MachineInfo_FFTTimebase)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n = stringTokenizer.countTokens();
            this.FFTTimeBases = new String[n];
            this.BDFFTTimeBases = new BigDecimal[n];
            int n11 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string6;
                this.FFTTimeBases[n11] = string6 = ParseUtil.trimQuotes(stringTokenizer.nextToken());
                this.BDFFTTimeBases[n11] = ParseUtil.translate_KMG(string6);
                ++n11;
            }
        } else if (string.startsWith(MachineInfo_ChannelConfig)) {
            StringTokenizer stringTokenizer = this.nextStringTokenizer(bufferedReader);
            int n = stringTokenizer.countTokens();
            if (n >= 2) {
                this.channel_numbers = ParseUtil.translateInt(stringTokenizer.nextToken());
                this.sampling_configuration_count = ParseUtil.translateInt(stringTokenizer.nextToken());
            }
            if (this.channel_numbers <= 0 || this.sampling_configuration_count <= 0) {
                this.channel_numbers = 2;
                this.sampling_configuration_count = 2;
            }
            this.computeChannelMaxSampleRate();
        } else {
            this.otherHandle(string, bufferedReader);
        }
    }

    protected void otherHandle(String string, BufferedReader bufferedReader) throws IOException {
    }

    protected StringTokenizer nextStringTokenizer(BufferedReader bufferedReader) throws IOException {
        String string = this.nextTrimLine(bufferedReader);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        return stringTokenizer;
    }

    protected String nextTrimLine(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine().trim();
    }

    protected void computeChannelMaxSampleRate() {
        this.channelMaxSampleRate = new SampleRate[this.sampling_configuration_count];
        for (int i = 0; i < this.sampling_configuration_count; ++i) {
            this.channelMaxSampleRate[i] = MachineInfo.computeChannelMaxSampleRate_ChannelsMerge(this.ADC_CLOCK_SampleRate, i);
        }
    }

    public static SampleRate computeChannelMaxSampleRate_ChannelsMerge(SampleRate sampleRate, int n) {
        return SampleRate.getSampleRateByDiv1000(sampleRate.getBDValue_Hz().divide(BigDecimal.valueOf(1 << n)));
    }

    protected void endOfInit() {
        this.fillSampleRates();
    }

    protected void loadSampleRates(String string, int n, int n2, int n3, BufferedReader bufferedReader) throws IOException {
        string = string.substring(string.indexOf(95) + 1);
        int n4 = string.charAt(1);
        int n5 = string.indexOf(95);
        int n6 = ParseUtil.getInStringArray(this.DEEP, string = string.substring(n5 + 1));
        if (n6 < 0 || this.channel_numbers + 48 < n4) {
            int n7 = n;
            for (int i = 0; i < n7; ++i) {
                String string2 = bufferedReader.readLine();
            }
            return;
        }
        switch (n4) {
            case 49: {
                n4 = 0;
                break;
            }
            case 50: {
                n4 = 1;
                break;
            }
            case 52: {
                n4 = 2;
            }
        }
        int n8 = n;
        SampleRate[] sampleRateArray = this.SampleRates[n4 * n2 + n6];
        int[] nArray = this.FullScreenData[n4 * n2 + n6];
        for (int i = 0; i < n8; ++i) {
            SampleRate sampleRate;
            String string3 = this.nextTrimLine(bufferedReader);
            string3 = string3.substring(0, string3.indexOf(44));
            sampleRateArray[i] = sampleRate = SampleRate.valueOf(string3);
            nArray[i] = sampleRate.compute(this.bdTIMEBASE[i], n3);
        }
    }

    protected void fillSampleRates() {
        int n = this.TIMEBASE.length;
        int n2 = this.DEEPValue.length;
        for (int i = 0; i < n; ++i) {
            BigDecimal bigDecimal = this.bdTIMEBASE[i].multiply(BigDecimal.valueOf(20L));
            for (int j = 0; j < this.sampling_configuration_count; ++j) {
                SampleRate sampleRate = this.channelMaxSampleRate[j];
                BigDecimal bigDecimal2 = sampleRate.getBDValue_Hz();
                for (int k = 0; k < n2; ++k) {
                    SampleRate sampleRate2;
                    int n3 = this.DEEPValue[k];
                    BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
                    if (!PrimaryTypeUtil.canHoldAsLong(bigDecimal3)) {
                        this.SampleRates[j * n2 + k][i] = sampleRate2 = sampleRate;
                    } else if (bigDecimal3.longValue() <= (long)n3) {
                        this.SampleRates[j * n2 + k][i] = sampleRate2 = sampleRate;
                    } else {
                        BigDecimal bigDecimal4 = BigDecimal.valueOf(n3).divide(bigDecimal);
                        sampleRate2 = SampleRate.getSampleRateByDiv1000(bigDecimal4);
                        if (sampleRate2 == null) {
                            // empty if block
                        }
                        this.SampleRates[j * n2 + k][i] = sampleRate2;
                    }
                    int n4 = sampleRate2.compute(this.bdTIMEBASE[i], 20);
                    this.FullScreenData[j * n2 + k][i] = n4;
                    int n5 = n4;
                }
            }
        }
    }

    public int getChannelNumbers() {
        return this.channel_numbers;
    }

    public BigDecimal getVoltagesBDRatioBetween(int n, int n2) {
        int[] nArray = this.intVOLTAGE[0];
        BigDecimal bigDecimal = BigDecimal.valueOf(nArray[n]).divide(BigDecimal.valueOf(nArray[n2]));
        return bigDecimal;
    }

    public double getVoltagesRatio(int n, int n2) {
        int[] nArray = this.intVOLTAGE[0];
        return (double)nArray[n] / (double)nArray[n2];
    }

    public String getTimebaseLabel(int n) {
        if (n < 0 || n >= this.TIMEBASE.length) {
            return N_A;
        }
        return this.TIMEBASE[n];
    }

    public int getTimebaseIndex(String string) {
        int n = this.TIMEBASE.length;
        for (int i = 0; i < n; ++i) {
            if (!this.TIMEBASE[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public int getChannelSampleType(int n) {
        if (n > 2) {
            return 2;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        return -1;
    }

    public abstract int fftAvailablePoints(int var1);

    public int getPos0HalfRange(int n) {
        if (this.getChannelNumbers() > 2) {
            return this.getPos0HalfRange_for4(n);
        }
        return this.getPos0HalfRange_for2(n);
    }

    public int getPos0HalfRange_for4(int n) {
        int n2 = 1000;
        n2 = n > 200 ? (n2 *= 50) : (n2 *= 2);
        return n2 / n * 25;
    }

    public int getPos0HalfRange_for2(int n) {
        int n2 = 1000;
        if (n > 100) {
            n2 *= 50;
        }
        return n2 / n * 25;
    }

    public SampleRate getADCSampleRate() {
        return this.ADC_CLOCK_SampleRate;
    }

    public BigDecimal ratio(int n, int n2) {
        return this.bdTIMEBASE[n].divide(this.bdTIMEBASE[n2]);
    }

    public int getDMIndexFromLength(int n) {
        int[] nArray = this.DEEPValue;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        this.outprintln("Mlen: can't be matched" + n);
        return -1;
    }

    protected MachineInfo(InputStream inputStream) {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) {
        if (inputStream != null) {
            this.setup(inputStream);
            this.SlowMoveIdx = this.getSlowMoveIdx();
        } else {
            this.SlowMoveIdx = -1;
        }
    }

    public SampleRate[] getSampleRate(int n, int n2) {
        int n3 = this.DEEP.length;
        SampleRate[] sampleRateArray = this.SampleRates[n * n3 + n2];
        return sampleRateArray;
    }

    public int[] getFullScreen(int n, int n2) {
        int n3 = this.DEEP.length;
        int[] nArray = this.FullScreenData[n * n3 + n2];
        return nArray;
    }

    protected int getSlowMoveIdx() {
        String[] stringArray = this.TIMEBASE;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(this.SlowMoveTimebase)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSlowMove(int n) {
        return n >= this.SlowMoveIdx;
    }

    protected void outprintln(String string) {
        System.out.println(string);
    }

    protected void outprint(String string) {
        System.out.println(string);
    }
}

