/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.fft.other;

public class InplaceFFT2 {
    static double[] cos;
    static double[] sin;

    public static void fft(double[] dArray, double[] dArray2) {
        double d;
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = (int)(Math.log(n3) / Math.log(2.0));
        if (n3 != 1 << n4) {
            throw new RuntimeException("FFT length must be power of 2");
        }
        double[] dArray3 = cos;
        double[] dArray4 = sin;
        if (dArray3 == null || dArray3.length != n3 >> 1) {
            dArray3 = cos = new double[n3 >> 1];
            dArray4 = sin = new double[n3 >> 1];
            n2 = n3 >> 1;
            while (n2-- > 0) {
                dArray3[n2] = Math.cos(Math.PI * -2 * (double)n2 / (double)n3);
                dArray4[n2] = Math.sin(Math.PI * -2 * (double)n2 / (double)n3);
            }
        }
        int n5 = 0;
        int n6 = n3 / 2;
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            for (n = n6; n5 >= n; n5 -= n, n /= 2) {
            }
            if (n2 >= (n5 += n)) continue;
            d = dArray[n2];
            dArray[n2] = dArray[n5];
            dArray[n5] = d;
            d = dArray2[n2];
            dArray2[n2] = dArray2[n5];
            dArray2[n5] = d;
        }
        n = 0;
        n6 = 1;
        for (n2 = 0; n2 < n4; ++n2) {
            n = n6;
            n6 += n6;
            int n7 = 0;
            for (n5 = 0; n5 < n; ++n5) {
                double d2 = dArray3[n7];
                double d3 = dArray4[n7];
                n7 += 1 << n4 - n2 - 1;
                for (int i = n5; i < n3; i += n6) {
                    d = d2 * dArray[i + n] - d3 * dArray2[i + n];
                    double d4 = d3 * dArray[i + n] + d2 * dArray2[i + n];
                    dArray[i + n] = dArray[i] - d;
                    dArray2[i + n] = dArray2[i] - d4;
                    dArray[i] = dArray[i] + d;
                    dArray2[i] = dArray2[i] + d4;
                }
            }
        }
    }
}

