/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.fft.other;

import com.owon.uppersoft.vds.core.fft.other.ComplexD;

public class InplaceFFT {
    public static void fft(ComplexD[] complexDArray) {
        int n;
        int n2;
        int n3 = complexDArray.length;
        if (Integer.highestOneBit(n3) != n3) {
            throw new RuntimeException("N is not a power of 2");
        }
        int n4 = 1 + Integer.numberOfLeadingZeros(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            n = Integer.reverse(n2) >>> n4;
            if (n <= n2) continue;
            ComplexD complexD = complexDArray[n];
            complexDArray[n] = complexDArray[n2];
            complexDArray[n2] = complexD;
        }
        for (n2 = 2; n2 <= n3; n2 += n2) {
            for (n = 0; n < n2 / 2; ++n) {
                double d = (double)(-2 * n) * Math.PI / (double)n2;
                ComplexD complexD = new ComplexD(Math.cos(d), Math.sin(d));
                for (int i = 0; i < n3 / n2; ++i) {
                    ComplexD complexD2 = complexD.times(complexDArray[i * n2 + n + n2 / 2]);
                    complexDArray[i * n2 + n + n2 / 2] = complexDArray[i * n2 + n].minus(complexD2);
                    complexDArray[i * n2 + n] = complexDArray[i * n2 + n].plus(complexD2);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 8;
        ComplexD[] complexDArray = new ComplexD[n2];
        for (n = 0; n < n2; ++n) {
            complexDArray[n] = new ComplexD(n + 1, 0.0);
        }
        for (n = 0; n < n2; ++n) {
            System.out.println(complexDArray[n]);
        }
        System.out.println();
        InplaceFFT.fft(complexDArray);
        for (n = 0; n < n2; ++n) {
            System.out.println(complexDArray[n]);
        }
        System.out.println();
    }
}

