/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.fft.other;

import com.owon.uppersoft.vds.core.fft.other.IComplex;

public class ComplexD
implements IComplex {
    public double re;
    public double im;

    public ComplexD() {
    }

    public ComplexD(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public String toString() {
        if (this.im == 0.0) {
            return this.re + "";
        }
        if (this.re == 0.0) {
            return this.im + "i";
        }
        if (this.im < 0.0) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public ComplexD plus(ComplexD complexD) {
        ComplexD complexD2 = this;
        double d = complexD2.re + complexD.re;
        double d2 = complexD2.im + complexD.im;
        return new ComplexD(d, d2);
    }

    public ComplexD minus(ComplexD complexD) {
        ComplexD complexD2 = this;
        double d = complexD2.re - complexD.re;
        double d2 = complexD2.im - complexD.im;
        return new ComplexD(d, d2);
    }

    public ComplexD times(ComplexD complexD) {
        ComplexD complexD2 = this;
        double d = complexD2.re * complexD.re - complexD2.im * complexD.im;
        double d2 = complexD2.re * complexD.im + complexD2.im * complexD.re;
        return new ComplexD(d, d2);
    }

    public ComplexD times(double d) {
        return new ComplexD(d * this.re, d * this.im);
    }

    public ComplexD conjugate() {
        return new ComplexD(this.re, -this.im);
    }

    public ComplexD reciprocal() {
        double d = this.re * this.re + this.im * this.im;
        return new ComplexD(this.re / d, -this.im / d);
    }

    @Override
    public double re() {
        return this.re;
    }

    @Override
    public double im() {
        return this.im;
    }

    public ComplexD divides(ComplexD complexD) {
        ComplexD complexD2 = this;
        return complexD2.times(complexD.reciprocal());
    }

    public ComplexD exp() {
        return new ComplexD(Math.exp(this.re) * Math.cos(this.im), Math.exp(this.re) * Math.sin(this.im));
    }

    public ComplexD sin() {
        return new ComplexD(Math.sin(this.re) * Math.cosh(this.im), Math.cos(this.re) * Math.sinh(this.im));
    }

    public ComplexD cos() {
        return new ComplexD(Math.cos(this.re) * Math.cosh(this.im), -Math.sin(this.re) * Math.sinh(this.im));
    }

    public ComplexD tan() {
        return this.sin().divides(this.cos());
    }

    public static ComplexD plus(ComplexD complexD, ComplexD complexD2) {
        double d = complexD.re + complexD2.re;
        double d2 = complexD.im + complexD2.im;
        ComplexD complexD3 = new ComplexD(d, d2);
        return complexD3;
    }

    public static void main(String[] stringArray) {
        ComplexD complexD = new ComplexD();
        ComplexD complexD2 = new ComplexD(-3.0, 4.0);
        System.out.println("a            = " + complexD);
        System.out.println("b            = " + complexD2);
        System.out.println("Re(a)        = " + complexD.re());
        System.out.println("Im(a)        = " + complexD.im());
        System.out.println("b + a        = " + complexD2.plus(complexD));
        System.out.println("a - b        = " + complexD.minus(complexD2));
        System.out.println("a * b        = " + complexD.times(complexD2));
        System.out.println("b * a        = " + complexD2.times(complexD));
        System.out.println("a / b        = " + complexD.divides(complexD2));
        System.out.println("(a / b) * b  = " + complexD.divides(complexD2).times(complexD2));
        System.out.println("conj(a)      = " + complexD.conjugate());
        System.out.println("|a|          = " + complexD.abs());
        System.out.println("tan(a)       = " + complexD.tan());
    }
}

