/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.fft;

public enum WndType {
    Hamming,
    Rectangle,
    Blackman,
    Hann,
    Flattop,
    Triangular;

    double[] win = null;

    public String toString() {
        return this.name();
    }

    public double[] getWindow(int n) {
        if (this == Rectangle) {
            return null;
        }
        if (this.win != null && this.win.length == n) {
            return this.win;
        }
        double[] dArray = new double[n];
        switch (this) {
            case Hamming: {
                double d = 0.5398876953125;
                double d2 = 0.53 / d;
                double d3 = 0.46 / d;
                double d4 = Math.PI * 2 / (double)(n - 1);
                int n2 = n;
                while (n2-- > 0) {
                    dArray[n2] = d2 - d3 * Math.cos(d4 * (double)n2);
                }
                break;
            }
            case Hann: {
                double d = 0.4998779296875;
                double d5 = 0.5 / d;
                double d6 = 0.5 / d;
                double d7 = Math.PI * 2 / (double)(n - 1);
                int n3 = n;
                while (n3-- > 0) {
                    dArray[n3] = d5 - d6 * Math.cos(d7 * (double)n3);
                }
                break;
            }
            case Blackman: {
                double d = 0.4198974609375;
                double d8 = 0.42 / d;
                double d9 = 0.5 / d;
                double d10 = 0.08 / d;
                double d11 = Math.PI * 2 / (double)(n - 1);
                double d12 = Math.PI * 4 / (double)(n - 1);
                int n4 = n;
                while (n4-- > 0) {
                    dArray[n4] = d8 - d9 * Math.cos(d11 * (double)n4) + d10 * Math.cos(d12 * (double)n4);
                }
                break;
            }
            case Flattop: {
                double d = 0.21552621562475585;
                double d13 = 0.21557895 / d;
                double d14 = 0.41663158 / d;
                double d15 = 0.277263158 / d;
                double d16 = 0.083578947 / d;
                double d17 = 0.006947368 / d;
                double d18 = Math.PI * 2 / (double)(n - 1);
                double d19 = Math.PI * 4 / (double)(n - 1);
                double d20 = Math.PI * 6 / (double)(n - 1);
                double d21 = Math.PI * 8 / (double)(n - 1);
                int n5 = n;
                while (n5-- > 0) {
                    dArray[n5] = d13 - d14 * Math.cos(d18 * (double)n5) + d15 * Math.cos(d19 * (double)n5) - d16 * Math.cos(d20 * (double)n5) + d17 * Math.cos(d21 * (double)n5);
                }
                break;
            }
            case Triangular: {
                double d = 0.4998778998778999;
                double d22 = 2.0 / (double)(n - 1) / d;
                double d23 = 2.0 / d;
                int n6 = n >> 1;
                while (n6-- > 0) {
                    dArray[n6] = (double)n6 * d22;
                }
                for (n6 = n >> 1; n6 < n; ++n6) {
                    dArray[n6] = d23 - (double)n6 * d22;
                }
                break;
            }
        }
        this.win = dArray;
        return dArray;
    }
}

