/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.fft;

import com.owon.uppersoft.vds.core.fft.WndType;
import com.owon.uppersoft.vds.core.fft.other.InplaceFFT2;

public class FFTUtil {
    public static final int FFT_SIZE = 4096;

    public static final int rfft_abs(int[] nArray, WndType wndType) {
        double[] dArray = new double[4096];
        double[] dArray2 = new double[4096];
        FFTUtil.compute_fft(nArray, wndType, dArray, dArray2);
        for (int i = 0; i < 2048; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            nArray[i] = (int)Math.sqrt(d * d + d2 * d2);
        }
        return 2048;
    }

    private static final void compute_fft(int[] nArray, WndType wndType, double[] dArray, double[] dArray2) {
        double[] dArray3 = wndType.getWindow(4096);
        if (dArray3 == null) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (double)nArray[i] * dArray3[i];
            }
        }
        InplaceFFT2.fft(dArray, dArray2);
    }

    public static final void plugValues(byte[] byArray, int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n2 - n;
        int n8 = Integer.highestOneBit(n7);
        int n9 = n3 / n8;
        int n10 = n8 >> 1;
        int n11 = n;
        int n12 = n2;
        int n13 = n11 + n12 >> 1;
        n11 = n13 - n10;
        n12 = n13 + n10;
        nArray[0] = byArray[n11] - n4;
        int n14 = 0;
        int n15 = 0 + n9;
        int n16 = n11 + 1;
        while (n15 < n3) {
            int n17 = nArray[n14];
            int n18 = nArray[n15] = byArray[n16] - n4;
            n6 = (int)((double)(n18 - n17) / (double)n9);
            for (n5 = n14 + 1; n5 < n15; ++n5) {
                nArray[n5] = n17 += n6;
            }
            n14 = n15;
            n15 += n9;
            ++n16;
        }
        n6 = nArray[n14];
        for (n5 = n14 + 1; n5 < n3; ++n5) {
            nArray[n5] = n6;
        }
    }

    public static final void plugValues(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n2 - n;
        int n8 = Integer.highestOneBit(n7);
        int n9 = n3 / n8;
        int n10 = n8 >> 1;
        int n11 = n;
        int n12 = n2;
        int n13 = n11 + n12 >> 1;
        n11 = n13 - n10;
        n12 = n13 + n10;
        nArray2[0] = nArray[n11] - n4;
        int n14 = 0;
        int n15 = 0 + n9;
        int n16 = n11 + 1;
        while (n15 < n3) {
            int n17 = nArray2[n14];
            int n18 = nArray2[n15] = nArray[n16] - n4;
            n6 = (int)((double)(n18 - n17) / (double)n9);
            for (n5 = n14 + 1; n5 < n15; ++n5) {
                nArray2[n5] = n17 += n6;
            }
            n14 = n15;
            n15 += n9;
            ++n16;
        }
        n6 = nArray2[n14];
        for (n5 = n14 + 1; n5 < n3; ++n5) {
            nArray2[n5] = n6;
        }
    }
}

