/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class CByteArrayInputStream {
    private ByteBuffer buf = null;
    private FileChannel fc = null;
    private File file = null;
    private boolean toDel = false;

    public CByteArrayInputStream(File file) {
        this(file, false);
    }

    private CByteArrayInputStream(File file, boolean bl) {
        this.file = file;
        this.toDel = bl;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            this.fc = randomAccessFile.getChannel();
            this.buf = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.buf.order(ByteOrder.BIG_ENDIAN);
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public CByteArrayInputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.toDel = false;
        this.buf.order(ByteOrder.BIG_ENDIAN);
    }

    public CByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = ByteBuffer.wrap(byArray, n, n2);
        this.toDel = false;
        this.buf.order(ByteOrder.BIG_ENDIAN);
    }

    protected void setToDel(boolean bl) {
        this.toDel = bl;
    }

    protected boolean isToDel() {
        return this.toDel;
    }

    public InputStream getInputStream() {
        if (this.buf.hasArray()) {
            return new ByteArrayInputStream(this.buf.array(), this.buf.position(), this.buf.limit());
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        if (this.fc == null) {
            return;
        }
        try {
            this.fc.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.fc = null;
        this.buf = null;
        System.gc();
        if (this.toDel) {
            try {
                this.file.delete();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public final void get(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        this.get(byArray, byteBuffer.position(), byteBuffer.remaining());
    }

    public final void get(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        if (n3 < n + n2) {
            System.err.println("CByteArrayInputStream : bslen < len");
            return;
        }
        if (this.buf.hasArray()) {
            byte[] byArray2 = this.buf.array();
            int n4 = this.buf.position();
            System.arraycopy(byArray2, n4, byArray, n, n2);
            return;
        }
        this.buf.get(byArray, n, n2);
    }

    public final void getIntArray(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            nArray[i] = this.buf.getInt();
        }
    }

    public final void getByteAsIntArray(int[] nArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            nArray[i] = this.buf.get();
        }
    }

    public final void gap_get(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            nArray[n5] = this.buf.get();
            ++n4;
            n5 += n3;
        }
    }

    public final int byteAt(int n) {
        return this.buf.get(n);
    }

    public final int nextInt() {
        return this.buf.getInt();
    }

    public final float nextFloat() {
        return this.buf.getFloat();
    }

    public final double nextDouble() {
        return this.buf.getDouble();
    }

    public final int pointer() {
        return this.buf.position();
    }

    public final void reset(int n) {
        this.buf.position(n);
    }

    public final void skip(int n) {
        this.buf.position(this.buf.position() + n);
    }

    public final int available() {
        return this.buf.remaining();
    }

    public final byte nextByte() {
        return this.buf.get();
    }

    public final boolean nextBoolean() {
        return this.buf.get() != 0;
    }
}

