/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.core.control;

import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.ParseUtil;
import java.awt.Color;

public class MathControl {
    public static final String MATH_MATHON = "Math.mathon";
    public static final String MATH_OPERATION = "Math.operation";
    public static final String MATH_VBIDX = "Math.vbidx";
    public static final String MATH_M2 = "Math.m2";
    public static final String MATH_M1 = "Math.m1";
    public static final String[] operations = new String[]{"+", "-", "*", "/"};
    public boolean mathon;
    public int m1;
    public int m2;
    public int operation;
    public Color color;
    public int probeIndex = 0;
    private int mathvbidx = -1;
    private String[][] MathVolts;
    public String[] MathVolt = new String[]{"1n", "2n", "5n", "10n", "20n", "50n", "100n", "200n", "500n", "1u", "2u", "5u", "10u", "20u", "50u", "100u", "200u", "500u", "1m", "2m", "5m", "10m", "20m", "50m", "100m", "200m", "500m", "1", "2", "5", "10", "20", "50", "100", "200", "500", "1K", "2K", "5K", "10K", "20K", "50K", "100K", "200K", "500K", "1M", "2M", "5M", "10M", "20M", "50M", "100M", "200M", "500M"};
    public double[] dbMathVoltage;

    public boolean isMathChannelUse(int n) {
        return this.mathon && (n == this.m1 || n == this.m2);
    }

    public boolean isInclude(int n) {
        return n == this.m1 || n == this.m2;
    }

    private double estimateVoltBase(double d, double d2) {
        switch (this.operation) {
            case 0: {
                return (d + d2) / 2.0;
            }
            case 1: {
                return Math.max(d, d2);
            }
            case 2: {
                return d + d2;
            }
            case 3: {
                return (d + d2) / 2.0;
            }
        }
        return Math.max(d, d2);
    }

    public void updateMathVbIdx(WaveForm waveForm, WaveForm waveForm2) {
        if (this.mathvbidx < 0 || this.mathvbidx >= this.dbMathVoltage.length) {
            this.refreshMathVoltBase(waveForm, waveForm2);
        }
    }

    public void refreshMathVoltBase(WaveForm waveForm, WaveForm waveForm2) {
        double d = waveForm.wfi.ci.getVoltValue();
        double d2 = waveForm2.wfi.ci.getVoltValue();
        double d3 = this.estimateVoltBase(d, d2);
        for (int i = 0; i < this.dbMathVoltage.length; ++i) {
            if (!(this.dbMathVoltage[i] >= d3)) continue;
            this.mathvbidx = i;
            break;
        }
    }

    public MathControl(Pref pref) {
        this.initVOLTAGEMath();
        this.load(pref);
    }

    public void load(Pref pref) {
        this.m1 = pref.loadInt(MATH_M1);
        this.m2 = pref.loadInt(MATH_M2);
        this.operation = pref.loadInt(MATH_OPERATION);
        this.mathvbidx = pref.loadInt(MATH_VBIDX, -1);
        this.color = pref.loadColor("Math.rgb", Color.GREEN);
        this.mathon = pref.loadBoolean(MATH_MATHON);
    }

    public void persist(Pref pref) {
        pref.persistInt(MATH_M1, this.m1);
        pref.persistInt(MATH_M2, this.m2);
        pref.persistInt(MATH_OPERATION, this.operation);
        pref.persistInt(MATH_VBIDX, this.mathvbidx);
        pref.persistColor("Math.rgb", this.color);
        pref.persistBoolean(MATH_MATHON, this.mathon);
    }

    public String[] getMathVBs() {
        return this.MathVolts[this.operation];
    }

    private void initVOLTAGEMath() {
        int n;
        int n2 = this.MathVolt.length;
        int n3 = operations.length;
        this.dbMathVoltage = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.dbMathVoltage[n] = this.getDouble_mV(this.MathVolt[n]);
        }
        this.MathVolts = new String[n3][n2];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.MathVolts[n][i] = n == 2 ? this.MathVolt[i] + "VV" : (n == 3 ? this.MathVolt[i] + "V/V" : this.MathVolt[i] + "V");
            }
        }
    }

    private double getDouble_mV(String string) {
        string = string.trim();
        String string2 = string.substring(0, string.length() - 1);
        double d = string.endsWith("n") ? (double)ParseUtil.translateInt(string2) / 1000000.0 : (string.endsWith("u") ? (double)ParseUtil.translateInt(string2) / 1000.0 : (string.endsWith("m") ? (double)ParseUtil.translateInt(string2) : (string.endsWith("K") ? (double)ParseUtil.translateInt(string2) * 1000000.0 : (string.endsWith("M") ? (double)ParseUtil.translateInt(string2) * 1.0E9 : (double)ParseUtil.translateInt(string) * 1000.0))));
        return d;
    }

    public String getLabel_mV(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return "?";
        }
        double d2 = Math.abs(d);
        String string = d2 < 1.0 ? String.format("%.2f \u00b5", d * 1000.0) : (d2 < 1000.0 ? String.format("%.2f m", d) : (d2 < 1000000.0 ? String.format("%.2f ", d / 1000.0) : String.format("%.2f K", d / 1000000.0)));
        switch (this.operation) {
            case 2: {
                return string + "VV";
            }
            case 3: {
                return string + "V/V";
            }
        }
        return string + "V";
    }

    public int getMathvbidx() {
        return this.mathvbidx;
    }

    public void setMathvbidx(int n) {
        this.mathvbidx = n;
    }
}

