/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto.jobs;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.vds.auto.WFAutoRoutine;
import com.owon.uppersoft.vds.auto.jobs.ArrangeTimeJob;
import com.owon.uppersoft.vds.auto.jobs.JobRunner;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RecognizeJob
implements Runnable {
    private List<WFAutoRoutine> wfrlist;
    private List<WFAutoRoutine> next_wfrlist;
    private JobRunner jr;
    private CoreControl cc;

    public RecognizeJob() {
    }

    @Override
    public void run() {
        this.recognizeChannels();
    }

    private void recognizeChannels() {
        if (this.wfrlist.size() > 0) {
            Object object;
            Iterator<WFAutoRoutine> iterator = this.wfrlist.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!((WFAutoRoutine)object).routOut()) continue;
                iterator.remove();
                if (((WFAutoRoutine)object).getAutoStatus() == WFAutoRoutine.AutoStatus.NoInput) {
                    ((WFAutoRoutine)object).getWaveForm().wfi.ci.c_setOn(false);
                    continue;
                }
                this.next_wfrlist.add((WFAutoRoutine)object);
            }
            if (this.wfrlist.size() == 0 && this.next_wfrlist.size() == 0) {
                this.cc.getWaveFormInfoControl().preSetChannelsForFFT(0);
                object = Platform.getDataHouse().getWaveFormManager();
                ((WaveFormManager)object).getWaveForm(0).setTrg50Percent(this.cc.getTriggerControl());
                this.jr.tail();
            }
        } else {
            this.jr.replaceRunnable(new ArrangeTimeJob(this.next_wfrlist, this.jr));
        }
    }

    public RecognizeJob(List<WFAutoRoutine> list, JobRunner jobRunner, CoreControl coreControl) {
        this.wfrlist = list;
        this.jr = jobRunner;
        this.cc = coreControl;
        this.next_wfrlist = new LinkedList<WFAutoRoutine>();
    }
}

