/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto.jobs;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.WFAutoRoutine;
import com.owon.uppersoft.vds.auto.jobs.ArrangeTimeBaseJob;
import com.owon.uppersoft.vds.auto.jobs.JobRunner;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.device.interpret.util.DefaultCMDResponser;
import com.owon.uppersoft.vds.source.comm.ext.IntObject;
import java.util.List;

public class ArrangeTimeJob
implements Runnable,
Logable {
    private List<WFAutoRoutine> next_wfrlist;
    private JobRunner jr;
    private CoreControl cc;

    @Override
    public void run() {
        this.arrangeTime();
    }

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }

    public ArrangeTimeJob(List<WFAutoRoutine> list, JobRunner jobRunner) {
        this.jr = jobRunner;
        this.cc = Platform.getCoreControl();
        this.next_wfrlist = list;
    }

    private void arrangeTime() {
        final IntObject intObject = new IntObject();
        intObject.value = -1;
        if (!this.cc.getMachine().isVideoTrgSupport()) {
            this.toArrange(0);
            return;
        }
        this.jr.queryVideoTrgd(new DefaultCMDResponser(){

            @Override
            protected void handleResponse(int n) {
                intObject.value = n;
            }
        });
        this.jr.replaceRunnable(new Runnable(){

            private void sleepThread0(int n) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }

            @Override
            public void run() {
                while (intObject.value < 0) {
                    System.err.println("while");
                    this.sleepThread0(50);
                }
                int n = intObject.value & 1;
                ArrangeTimeJob.this.toArrange(n);
            }
        });
    }

    private void toArrange(final int n) {
        this.jr.replaceRunnable(new Runnable(){

            @Override
            public void run() {
                if (n != 0) {
                    int n4 = 0;
                    TriggerControl triggerControl = ArrangeTimeJob.this.cc.getTriggerControl();
                    triggerControl.c_setChannelMode(0);
                    triggerControl.setSingleChannel(n4);
                    TriggerSet triggerSet = triggerControl.getSingleTriggerSet();
                    triggerSet.setTrigger(triggerSet.video);
                    triggerControl.selfSubmit();
                    MachineInfo machineInfo = ArrangeTimeJob.this.cc.getMachineInfo();
                    int n2 = machineInfo.getTimebaseIndex("50us");
                    ArrangeTimeJob.this.cc.getTimeControl().c_setTimebaseIdx(n2, true);
                    ArrangeTimeJob.this.jr.doArrangeChannels(ArrangeTimeJob.this.next_wfrlist, n2);
                } else {
                    int n5 = ArrangeTimeJob.this.next_wfrlist.size();
                    if (n5 == 1) {
                        WaveForm waveForm = ((WFAutoRoutine)ArrangeTimeJob.this.next_wfrlist.get(0)).getWaveForm();
                        int n3 = waveForm.getChannelNumber();
                        TriggerControl triggerControl = ArrangeTimeJob.this.cc.getTriggerControl();
                        triggerControl.c_setChannelMode(0);
                        triggerControl.setSingleChannel(n3);
                        triggerControl.selfSubmit();
                    }
                    ArrangeTimeJob.this.jr.replaceRunnable(new ArrangeTimeBaseJob(ArrangeTimeJob.this.next_wfrlist, ArrangeTimeJob.this.jr, ArrangeTimeJob.this.cc));
                }
            }
        });
    }
}

