/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto.jobs;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.WFAutoRoutine;
import com.owon.uppersoft.vds.auto.jobs.JobRunner;
import java.math.BigDecimal;
import java.util.List;

public class ArrangeTimeBaseJob
implements Runnable {
    private int num;
    private List<WFAutoRoutine> next_wfrlist;
    private JobRunner jr;
    private CoreControl cc;

    public ArrangeTimeBaseJob(List<WFAutoRoutine> list, JobRunner jobRunner, CoreControl coreControl) {
        this.num = list.size();
        this.next_wfrlist = list;
        this.jr = jobRunner;
        this.cc = coreControl;
    }

    @Override
    public void run() {
        switch (this.num) {
            case 1: {
                boolean bl;
                WaveForm waveForm = this.next_wfrlist.get(0).getWaveForm();
                int n = waveForm.getChannelNumber();
                double d = waveForm.wfi.ci.getPeriod();
                this.logln(waveForm.toString() + " peroid " + d);
                int n2 = this.timebase(d, n);
                boolean bl2 = bl = n2 >= 0;
                if (bl) {
                    this.jr.doArrangeChannels(this.next_wfrlist, n2);
                    break;
                }
                this.jr.tail();
                break;
            }
            default: {
                boolean bl;
                double d = -1.0;
                int n = -1;
                for (WFAutoRoutine wFAutoRoutine : this.next_wfrlist) {
                    WaveForm waveForm = wFAutoRoutine.getWaveForm();
                    int n3 = waveForm.getChannelNumber();
                    double d2 = waveForm.wfi.ci.getPeriod();
                    this.logln(waveForm.toString() + " peroid " + d2);
                    if (Double.isInfinite(d2) || !(d2 > 0.0) || !(d2 > d)) continue;
                    n = n3;
                    d = d2;
                }
                if (d <= 0.0) break;
                int n4 = this.timebase(d, n);
                boolean bl3 = bl = n4 >= 0;
                if (bl) {
                    this.jr.doArrangeChannels(this.next_wfrlist, n4);
                    break;
                }
                this.jr.tail();
            }
        }
    }

    private void logln(Object object) {
        System.out.println(object);
    }

    private int timebase(double d, int n) {
        int n2;
        double d2 = d / 1000000.0 * 3.0 / 20.0;
        this.logln("sp: " + d2);
        BigDecimal[] bigDecimalArray = this.cc.getMachineInfo().bdTIMEBASE;
        int n3 = bigDecimalArray.length;
        int n4 = n3 - 1;
        int n5 = n2 = n3 >> 1;
        this.logln("init_tb: " + n2);
        double d3 = bigDecimalArray[n5].doubleValue();
        while (d3 > d2 && n5 - 1 >= 0) {
            this.logln("tbi: " + --n5);
            d3 = bigDecimalArray[n5].doubleValue();
        }
        this.logln("again: ");
        while (d3 < d2 && n5 + 1 <= n4) {
            this.logln("tbi: " + ++n5);
            d3 = bigDecimalArray[n5].doubleValue();
        }
        this.cc.getTimeControl().c_setTimebaseIdx(n5, true);
        return n5;
    }
}

