/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto.jobs;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.WFAutoArrange;
import com.owon.uppersoft.vds.auto.WFAutoRoutine;
import com.owon.uppersoft.vds.auto.jobs.JobRunner;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import java.util.Iterator;
import java.util.List;

public class ArrangeChannelsJob
implements Runnable,
Logable {
    private final int tbi;
    private List<WFAutoRoutine> next_wfrlist;
    private JobRunner jr;
    private CoreControl cc;
    private int[][] pos0Array = new int[][]{{0}, {50, -50}, {50, 0, -50}, {75, 25, -25, -75}};
    private double[] ampsArray = new double[]{0.8, 0.4, 0.4, 0.25};

    public ArrangeChannelsJob(int n, List<WFAutoRoutine> list, JobRunner jobRunner, CoreControl coreControl) {
        this.tbi = n;
        this.jr = jobRunner;
        this.cc = coreControl;
        this.next_wfrlist = list;
    }

    @Override
    public void run() {
        this.arrangeChannels(this.tbi);
    }

    private void arrangeChannels(int n) {
        Iterator<WFAutoRoutine> iterator = this.next_wfrlist.iterator();
        int n2 = this.next_wfrlist.size();
        if (n2 < 0 || n2 > 4) {
            System.err.println("arrangeChannels  chlnum < 0 || chlnum > 4");
            this.jr.tail();
            return;
        }
        VoltageProvider voltageProvider = this.cc.getVoltageProvider();
        int n3 = voltageProvider.getVoltageNumber();
        int n4 = n2 - 1;
        int n5 = (int)(this.ampsArray[n4] * 250.0);
        int n6 = 0;
        while (iterator.hasNext()) {
            WFAutoRoutine wFAutoRoutine = iterator.next();
            WaveForm waveForm = wFAutoRoutine.getWaveForm();
            WFAutoArrange wFAutoArrange = new WFAutoArrange(waveForm, n3, this.cc);
            wFAutoArrange.getReady2(this.pos0Array[n4][n6++], n5, this.computeVBIndex(n5, wFAutoRoutine.getAMP(), waveForm));
        }
        this.jr.replaceRunnable(new Runnable(){
            int i = 0;

            @Override
            public void run() {
                if (this.i < 1) {
                    ++this.i;
                    return;
                }
                for (WFAutoRoutine wFAutoRoutine : ArrangeChannelsJob.this.next_wfrlist) {
                    WaveForm waveForm = wFAutoRoutine.getWaveForm();
                    waveForm.setTrg50Percent(ArrangeChannelsJob.this.cc.getTriggerControl());
                }
                ArrangeChannelsJob.this.jr.tail();
            }
        });
    }

    private int computeVBIndex(int n, double d, WaveForm waveForm) {
        double d2;
        VoltageProvider voltageProvider = this.cc.getVoltageProvider();
        int n2 = voltageProvider.getVoltageNumber();
        int n3 = (int)((double)n * 0.8);
        int n4 = waveForm.getVoltbaseIndex();
        this.logln("wf: " + waveForm.getChannelNumber() + ", amp: " + d + ", vb:" + voltageProvider.getVoltageLabel(n4));
        int n5 = n4;
        while (d <= (double)n3 && n5 - 1 >= 0) {
            d2 = (double)voltageProvider.getVoltage(0, n5 - 1) / (double)voltageProvider.getVoltage(0, n5);
            this.logln((d /= d2) + ", " + --n5);
        }
        this.logln("again");
        while (d > (double)n && n5 + 1 < n2) {
            d2 = (double)voltageProvider.getVoltage(0, n5 + 1) / (double)voltageProvider.getVoltage(0, n5);
            this.logln((d /= d2) + ", " + ++n5);
        }
        return n5;
    }

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }
}

