/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.VBAim;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.vds.calibration.stuff.CalculatUtil;
import com.owon.vds.calibration.stuff.PKCalResult;
import java.nio.ByteBuffer;

public class WFAutoRoutine {
    private static final int HALF_ADC = 120;
    public static final int GRID_RANGE = 25;
    public static final int ADC_RANGE = 250;
    public static final int ADC_SCREEN_RANGE = 250;
    public static final int ADC_LOCKTRG_RANGE = 50;
    private AutoStatus as = AutoStatus.Init;
    private WaveForm wf;
    private int lastvb;
    private CoreControl cc;
    private int midvb;
    private int limitAMP;
    private VLog vl = new VLog();
    private int checkOffCount;
    private int allCheckCount;
    private VBAim vbaim = VBAim.both;
    public int amp = -1;

    public AutoStatus getAutoStatus() {
        return this.as;
    }

    public WaveForm getWaveForm() {
        return this.wf;
    }

    public WFAutoRoutine(WaveForm waveForm, int n, CoreControl coreControl, double d) {
        this.wf = waveForm;
        this.cc = coreControl;
        this.limitAMP = (int)(25.0 * d);
        this.lastvb = n - 1;
        this.midvb = n >> 1;
    }

    public void getReady() {
        this.as = AutoStatus.Init;
        this.checkOffCount = 0;
        this.allCheckCount = 0;
        this.vbaim = VBAim.both;
    }

    public boolean routOut() {
        this.vl.logln(".......routOut..... >> " + this.getChlName() + ", AutoStatus: " + (Object)((Object)this.as));
        switch (this.as) {
            case Init: {
                return this.checkOff();
            }
            case ContinueCheckVB: {
                return this.checkVBChangeTrend();
            }
            case POS_LEVEL: {
                return this.continuePosLevel();
            }
        }
        return true;
    }

    private boolean checkOff() {
        this.vl.logln("checkOff >> " + this.getChlName() + ", checkOffCount: " + this.checkOffCount + ", allCheckCount: " + this.allCheckCount);
        ByteBuffer byteBuffer = this.getADCBuffer();
        if (byteBuffer == null) {
            this.vl.logln("ByteBuffer bb null?");
            return false;
        }
        PKCalResult pKCalResult = CalculatUtil.computePK(byteBuffer);
        this.vl.logln(pKCalResult);
        int n = Math.abs(pKCalResult.max);
        int n2 = Math.abs(pKCalResult.min);
        if (n > this.limitAMP || n2 > this.limitAMP) {
            this.detemineOn();
            return false;
        }
        int n3 = n < this.limitAMP && n2 < this.limitAMP ? 1 : -1;
        this.checkOffCount += n3;
        ++this.allCheckCount;
        if (this.allCheckCount > 6) {
            this.as = AutoStatus.NoInput;
            this.vl.logln("checkOut NoInput >> " + this.getChlName());
            return true;
        }
        if (this.checkOffCount > 2) {
            this.as = AutoStatus.NoInput;
            this.vl.logln("checkOut NoInput >> " + this.getChlName());
            return true;
        }
        if (this.checkOffCount < -2) {
            this.detemineOn();
            return false;
        }
        return false;
    }

    private void detemineOn() {
        this.vl.logln("checkOut Input >> " + this.getChlName());
        this.setVoltBaseIndex(this.midvb);
        this.as = AutoStatus.ContinueCheckVB;
        this.vbaim = VBAim.both;
    }

    private boolean setVoltBaseIndex(int n) {
        boolean bl = this.wf.setVoltBaseIndex(n, false);
        return bl;
    }

    private ByteBuffer getADCBuffer() {
        return this.wf.getADC_Buffer();
    }

    private String getChlName() {
        return this.wf.toString();
    }

    public int getAMP() {
        this.vl.logln("getAMP");
        ByteBuffer byteBuffer = this.getADCBuffer();
        PKCalResult pKCalResult = CalculatUtil.computePK(byteBuffer);
        this.vl.logln(pKCalResult);
        double d = CalculatUtil.computeAverage(byteBuffer);
        this.vl.logln("avg: " + d);
        int n = this.getHalfAmp(pKCalResult, d) << 1;
        this.vl.logln("amp " + n);
        this.amp = n;
        return this.amp;
    }

    private int getHalfAmp(PKCalResult pKCalResult, double d) {
        int n = Math.abs(pKCalResult.max);
        int n2 = Math.abs(pKCalResult.min);
        int n3 = pKCalResult.pk;
        if ((d = Math.abs(d)) > (double)n3 && n3 < 5) {
            if (n > 120 && n2 > 120) {
                return n2;
            }
            return (int)d;
        }
        return n > n2 ? n : n2;
    }

    private boolean checkVBChangeTrend() {
        if (this.vbaim == null) {
            System.err.println("vbTrend(VBAim vbaim) err");
            return true;
        }
        int n = this.wf.getVoltbaseIndex();
        this.vl.logln("vb: " + this.cc.getVoltageProvider().getVoltageLabel(n));
        int n2 = this.getAMP();
        if (this.vbaim != VBAim.smaller && n2 >= 250) {
            if (n + 1 <= this.lastvb) {
                this.vbaim = VBAim.bigger;
                this.vl.logln("vb + 1 ");
                this.setVoltBaseIndex(n + 1);
                return false;
            }
            return this.toPosLevel();
        }
        if (this.vbaim != VBAim.bigger && n2 < 50) {
            if (n - 1 >= 0) {
                this.vbaim = VBAim.smaller;
                this.vl.logln("vb - 1 ");
                this.setVoltBaseIndex(n - 1);
                return false;
            }
            return this.toPosLevel();
        }
        return this.toPosLevel();
    }

    private boolean toPosLevel() {
        this.vbaim = VBAim.both;
        this.as = AutoStatus.POS_LEVEL;
        return false;
    }

    private boolean continuePosLevel() {
        this.as = AutoStatus.DONE;
        this.wf.setTrg50Percent(this.cc.getTriggerControl());
        return true;
    }

    public static enum AutoStatus {
        Init,
        ContinueCheckVB,
        NoInput,
        POS_LEVEL,
        DONE;

    }
}

