/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto;

import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.ArrangeStatus;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.vds.calibration.stuff.CalculatUtil;
import com.owon.vds.calibration.stuff.PKCalResult;
import java.nio.ByteBuffer;

public class WFAutoArrange {
    private static final int HALF_ADC = 120;
    public static final int GRID_RANGE = 25;
    public static final int ADC_RANGE = 250;
    public static final int ADC_SCREEN_RANGE = 250;
    public static final int ADC_LOCKTRG_RANGE = 100;
    private ArrangeStatus as;
    private WaveForm wf;
    private CoreControl cc;
    private int lastvb;
    private VLog vl = new VLog();
    private int pos0;
    private int chlAmpMax;
    private int chlAmpMin;

    public WFAutoArrange(WaveForm waveForm, int n, CoreControl coreControl) {
        this.wf = waveForm;
        this.cc = coreControl;
        this.lastvb = n - 1;
    }

    private boolean setVoltBaseIndex(int n) {
        boolean bl = this.wf.setVoltBaseIndex(n, false);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return bl;
    }

    private ByteBuffer getADCBuffer() {
        return this.wf.getADC_Buffer();
    }

    private String getChlName() {
        return this.wf.toString();
    }

    public WaveForm getWaveForm() {
        return this.wf;
    }

    public void getReady2(int n, int n2, int n3) {
        this.pos0 = n;
        this.as = ArrangeStatus.Init;
        this.chlAmpMax = n2;
        this.chlAmpMin = (int)((double)n2 * 0.8);
        this.vl.logln("getReady2 " + this.getChlName() + ", " + n + ", " + n2);
        this.vl.logln("chlAmpMax: " + this.chlAmpMax + ", chlAmpMin: " + this.chlAmpMin);
        this.wf.setZeroYLoc(n, true, false);
        this.as = ArrangeStatus.Init;
        this.setVoltBaseIndex(n3);
    }

    public boolean routOut() {
        this.vl.logln(".......routOut..... >> " + this.getChlName() + ", ArrangeStatus: " + (Object)((Object)this.as));
        switch (this.as) {
            case Init: {
                return this.checkVBChangeTrend();
            }
            case POS_LEVEL: {
                return this.continuePosLevel();
            }
        }
        return false;
    }

    private int getAMP() {
        this.vl.logln("getAMP");
        ByteBuffer byteBuffer = this.getADCBuffer();
        PKCalResult pKCalResult = CalculatUtil.computePK(byteBuffer);
        pKCalResult.withoutPos0(this.pos0);
        this.vl.logln(pKCalResult);
        double d = CalculatUtil.computeAverage(byteBuffer) - (double)this.pos0;
        this.vl.logln("avg: " + d);
        int n = this.getHalfAmp(pKCalResult, d) << 1;
        this.vl.logln("amp " + n);
        return n;
    }

    private int getHalfAmp(PKCalResult pKCalResult, double d) {
        int n = Math.abs(pKCalResult.max);
        int n2 = Math.abs(pKCalResult.min);
        int n3 = pKCalResult.pk;
        double d2 = Math.abs(d);
        if (d2 > (double)n3 && n3 < 5) {
            if (n > 120 && n2 > 120) {
                return n2;
            }
            return (int)d2;
        }
        return n > n2 ? n : n2;
    }

    private boolean checkVBChangeTrend() {
        return this.toPosLevel();
    }

    private boolean continuePosLevel() {
        this.as = ArrangeStatus.DONE;
        this.wf.setTrg50Percent(this.cc.getTriggerControl());
        return true;
    }

    private boolean toPosLevel() {
        this.as = ArrangeStatus.POS_LEVEL;
        return false;
    }
}

