/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.vds.auto;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.mode.control.SampleControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.wf.ON_WF_Iterator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.auto.WFAutoRoutine;
import com.owon.uppersoft.vds.auto.jobs.ArrangeChannelsJob;
import com.owon.uppersoft.vds.auto.jobs.JobRunner;
import com.owon.uppersoft.vds.auto.jobs.RecognizeJob;
import com.owon.uppersoft.vds.core.aspect.base.Logable;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.device.interpret.CMDResponser;
import com.owon.uppersoft.vds.device.interpret.DeviceAddressTable;
import com.owon.uppersoft.vds.source.comm.InterCommTiny;
import com.owon.uppersoft.vds.source.comm.Submitor2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AutosetRunner2
implements Logable,
JobRunner {
    private static final int TIMEBASE_10MS = 19;
    public static final int GRID_RANGE = 25;
    public static final int ADC_RANGE = 250;
    public static final int ADC_SCREEN_RANGE = 250;
    public static final int ADC_LOCKTRG_RANGE = 100;
    private WaveFormManager wfm;
    private ControlManager cm;
    private VoltageProvider vp;
    private Runnable donejob;
    private CoreControl cc;
    private InterCommTiny ict;
    private VLog vl = new VLog();
    private TriggerControl tc;
    private MainWindow mw;
    private DataHouse dh;
    public static final double limitGridLitterVB = 1.0;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equalsIgnoreCase("NewDataReceive")) {
                AutosetRunner2.this.call();
            }
        }
    };
    private Runnable run;
    private boolean isOver;

    public AutosetRunner2(Runnable runnable, InterCommTiny interCommTiny) {
        this.donejob = runnable;
        this.ict = interCommTiny;
        this.dh = Platform.getDataHouse();
        this.cm = this.dh.controlManager;
        this.cc = this.dh.controlManager.getCoreControl();
        this.wfm = this.dh.getWaveFormManager();
        this.vp = this.cc.getVoltageProvider();
        this.tc = this.cc.getTriggerControl();
        this.mw = Platform.getMainWindow();
    }

    @Override
    public void log(Object object) {
        System.out.print(object);
    }

    @Override
    public void logln(Object object) {
        System.out.println(object);
    }

    protected void beforeAutoset() {
        this.dh.getWaveFormManager().hideDraw();
        this.dh.closePersistence();
        this.cm.displayControl.setXYMode(false);
        this.mw.getToolPane().getButtonPane().switch_3in1_xy(false);
        this.mw.getChartScreen().updateXYView();
        this.cm.mathControl.mathon = false;
        this.cm.rc.forceStop();
        this.cm.ruleManager.getPFRuleControl().disableRule();
        this.cm.getFFTControl().c_setFFTon(false);
        this.cm.getWaveFormInfoControl().turnOnAllChannelsCouplingNotInverse();
        this.tc.c_setChannelMode(1);
        this.tc.resetAltTrgSet();
        this.tc.resetSingleTrgset();
        this.mw.getToolPane().getTrgInfoPane().updateInfos(this.tc);
        this.cc.getSampleControl().c_setModelIdx(SampleControl.Sample_PKDetect);
        this.cc.getSysControl().c_setSyncOut(1);
        int n = 19;
        this.cc.getTimeControl().c_setTimebase_HorTrgPos(n, 0);
        this.cm.getZoomAssctr().switch2Main();
        this.ict.getValueFeeder().forceFeedMiddle();
    }

    protected void afterAutoset() {
        this.ict.getValueFeeder().resumeFeedMiddle();
        this.mw.getToolPane().getTrgInfoPane().updateInfos(this.tc);
        this.cc.getSampleControl().c_setModelIdx(SampleControl.Sample_Sampling);
        this.dh.getWaveFormManager().resumeDraw();
        this.donejob.run();
    }

    public void getReady() {
        this.beforeAutoset();
        int n = this.vp.getVoltageNumber();
        int n2 = this.cc.getWaveFormInfoControl().getLowMachineChannels();
        ArrayList<WFAutoRoutine> arrayList = new ArrayList<WFAutoRoutine>(n2);
        ON_WF_Iterator oN_WF_Iterator = this.wfm.on_wf_Iterator();
        while (oN_WF_Iterator.hasNext()) {
            WaveForm waveForm = oN_WF_Iterator.next();
            waveForm.setZeroYLoc(0, true, false);
            waveForm.setVoltBaseIndex(0, false);
            WFAutoRoutine wFAutoRoutine = new WFAutoRoutine(waveForm, n, this.cc, 1.0);
            wFAutoRoutine.getReady();
            arrayList.add(wFAutoRoutine);
        }
        this.vl.logln("...START AUTOSET...");
        this.isOver = false;
        this.replaceRunnable(new RecognizeJob(arrayList, this, this.cc));
        this.ict.addPropertyChangeListener(this.pcl);
    }

    @Override
    public void replaceRunnable(Runnable runnable) {
        this.run = runnable;
    }

    @Override
    public void tail() {
        this.afterAutoset();
        this.logln("...roll...");
        this.replaceRunnable(null);
        this.ict.removePropertyChangeListener(this.pcl);
        this.isOver = true;
    }

    public void resumeCustomize() {
    }

    @Override
    public void queryVideoTrgd(CMDResponser cMDResponser) {
        DeviceAddressTable deviceAddressTable = this.ict.getTinyMachine().getDeviceAddressTable();
        Submitor2 submitor2 = (Submitor2)SubmitorFactory.reInit();
        submitor2.sendCMD(deviceAddressTable.VIDEOTRGD_ADD, 1, cMDResponser);
    }

    @Override
    public void doArrangeChannels(List<WFAutoRoutine> list, int n) {
        this.logln("1st wf: " + list.get(0).getWaveForm().getChannelNumber());
        Collections.sort(list, new Comparator<WFAutoRoutine>(){

            @Override
            public int compare(WFAutoRoutine wFAutoRoutine, WFAutoRoutine wFAutoRoutine2) {
                return wFAutoRoutine.getWaveForm().getChannelNumber() - wFAutoRoutine2.getWaveForm().getChannelNumber();
            }
        });
        this.replaceRunnable(new ArrangeChannelsJob(n, list, this, this.cc));
    }

    private void call() {
        if (this.isExit() || this.isOver) {
            return;
        }
        if (this.run != null) {
            this.run.run();
        }
    }

    private boolean isExit() {
        return this.cm.isExit();
    }
}

