/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.rt;

import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.data.MinMax;
import com.owon.uppersoft.vds.core.paint.IPaintOne;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.RTLocInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RTLocInfoManager {
    private List<RTLocInfo> rtlis;
    private WaveForm wf;
    public static final boolean OneFramePop = false;
    private boolean BeyondMax = false;
    private boolean BeyondMin = false;
    private MinMax min_max = new MinMax();
    private boolean init_min_max;

    public RTLocInfoManager(WaveForm waveForm) {
        this.wf = waveForm;
        this.rtlis = new LinkedList<RTLocInfo>();
    }

    public void restrictFrames(int n, int n2) {
        while (this.rtlis.size() < n) {
            this.rtlis.add(new RTLocInfo(n2));
        }
        while (this.rtlis.size() > n) {
            this.rtlis.remove(0);
        }
    }

    public void resetRTIntBuf(ChannelDataInfo channelDataInfo, ScreenContext screenContext, int n, int n2, LoadMedia loadMedia, BigDecimal bigDecimal) {
        int n3 = channelDataInfo.chl;
        LinkedList<ByteBuffer> linkedList = channelDataInfo.getBuflist();
        int n4 = linkedList.size();
        if (n4 <= 0) {
            return;
        }
        boolean bl = screenContext.isScreenMode_3();
        this.BeyondMax = channelDataInfo.BeyondMax;
        this.BeyondMin = channelDataInfo.BeyondMin;
        this.restrictFrames(n4, n3);
        Iterator<RTLocInfo> iterator = this.rtlis.iterator();
        for (ByteBuffer byteBuffer : linkedList) {
            byteBuffer.position(byteBuffer.position() + n);
            iterator.next().resetRTIntBuf(byteBuffer, n2, bl, bigDecimal);
        }
    }

    public void releaseRTLI() {
        this.rtlis.clear();
    }

    public void resetIntBuf(BigDecimal bigDecimal, int n, boolean bl) {
        if (this.rtlis.size() > 0) {
            RTLocInfo rTLocInfo = this.rtlis.get(0);
            rTLocInfo.resetIntBuf(bigDecimal, n, bl);
        }
    }

    public ByteBuffer getNextFrameADCBuffer(int n) {
        int n2 = this.rtlis.size();
        if (n2 == 0 || n >= n2) {
            return null;
        }
        return this.rtlis.get((int)n).adcbuf;
    }

    public ByteBuffer rtliADC_Buffer() {
        int n = this.rtlis.size();
        if (n == 0) {
            return null;
        }
        return this.rtlis.get((int)(n - 1)).adcbuf;
    }

    public boolean isRtADC_MaxBeyond() {
        return this.BeyondMax;
    }

    public boolean isRtADC_MinBeyond() {
        return this.BeyondMin;
    }

    public int getTrg50percentValue() {
        this.init_min_max = false;
        for (RTLocInfo rTLocInfo : this.rtlis) {
            MinMax minMax = rTLocInfo.collect_max_min();
            if (minMax == null) continue;
            this.compare_setXY(minMax);
        }
        if (!this.init_min_max) {
            return Integer.MAX_VALUE;
        }
        return this.min_max.getMiddle();
    }

    public int computeMiddle() {
        int n = this.rtlis.size();
        if (n == 0) {
            return Integer.MAX_VALUE;
        }
        RTLocInfo rTLocInfo = this.rtlis.get(n - 1);
        MinMax minMax = rTLocInfo.collect_max_min();
        if (minMax == null) {
            return Integer.MAX_VALUE;
        }
        return minMax.computeMiddle();
    }

    public void compare_setXY(MinMax minMax) {
        if (!this.init_min_max) {
            this.min_max.set(minMax);
            this.init_min_max = true;
            return;
        }
        this.min_max.mergeMinMax(minMax);
    }

    public IntBuffer save2RefIntBuffer() {
        int n = this.rtlis.size();
        if (n == 0) {
            return IntBuffer.allocate(0);
        }
        ByteBuffer byteBuffer = this.rtlis.get((int)(n - 1)).adcbuf;
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        IntBuffer intBuffer = IntBuffer.allocate(n2 - n3);
        int[] nArray = intBuffer.array();
        int n4 = 0;
        int n5 = n3;
        while (n5 < n2) {
            nArray[n4] = byArray[n5];
            ++n5;
            ++n4;
        }
        intBuffer.limit(n4);
        intBuffer.position(0);
        return intBuffer;
    }

    public RTLocInfo getFirst() {
        try {
            return this.rtlis.get(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void paintKinds(Graphics2D graphics2D, int n, int n2, boolean bl, Rectangle rectangle, boolean bl2, WFTimeScopeControl wFTimeScopeControl, ScreenContext screenContext) {
        if (this.rtlis.size() <= 0) {
            return;
        }
        try {
            IPaintOne iPaintOne = screenContext.getIPaintOne();
            for (RTLocInfo rTLocInfo : this.rtlis) {
                iPaintOne.paintONE(graphics2D, n, n2, bl, rectangle.y, rectangle.height, bl2, wFTimeScopeControl, rTLocInfo.pixbuf, wFTimeScopeControl.getPK_detect_type());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

