/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.dm2;

import com.owon.uppersoft.dso.wf.dm2.CenterPointInfo2;
import com.owon.uppersoft.dso.wf.dm2.DiluteInfoUnitTiny2;
import com.owon.uppersoft.dso.wf.dm2.TimebaseDiluteInfo;
import com.owon.uppersoft.vds.core.aspect.base.VLog;
import com.owon.uppersoft.vds.core.deep.struct.RangeInfo4in1;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.plug.Plug10;
import com.owon.uppersoft.vds.core.plug.VDSource;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.PlugInfo;
import com.owon.uppersoft.vds.util.LoadArrayUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class Pluger2 {
    public static final int AREA_WIDTH = 1000;
    private ByteBuffer insideBuffer = ByteBuffer.allocate(2000);
    private DiluteInfoUnitTiny2 diu;
    private TimebaseDiluteInfo[] tdis = new TimebaseDiluteInfo[6];
    private double gap;
    VLog vl = new VLog();
    private int ppi;
    private double curr_xoff;
    private boolean plug = false;
    public int initPos;
    private int curr_screendatalen;
    private int originalscreendatalen;
    public int plugDataLength;
    private int sinePlugRate;
    private int linearPlugRate;
    private int pluggedTrgOffset;
    public static final int DefaultExtendRange = 50;
    public static final int DefaultPlugPointsThredsold = 400;
    private TimebaseDiluteInfo curr_tdi;
    private int curr_points;
    private int drawPoints;

    public Pluger2(DiluteInfoUnitTiny2 diluteInfoUnitTiny2) {
        this.diu = diluteInfoUnitTiny2;
        this.plug = false;
        int n = 0;
        this.tdis[n] = new TimebaseDiluteInfo(n, 10, 10, 10);
        this.tdis[++n] = new TimebaseDiluteInfo(n, 20, 10, 5);
        this.tdis[++n] = new TimebaseDiluteInfo(n, 40, 10, 5);
        this.tdis[++n] = new TimebaseDiluteInfo(n, 100, 10, 1);
        this.tdis[++n] = new TimebaseDiluteInfo(n, 200, 10, 1);
        this.tdis[++n] = new TimebaseDiluteInfo(n, 400, 1, 5);
        ++n;
    }

    protected int getTimebaseIndexFromScreenDataLen(int n) {
        switch (n) {
            case 10: {
                return 0;
            }
            case 20: {
                return 1;
            }
            case 40: {
                return 2;
            }
            case 100: {
                return 3;
            }
            case 200: {
                return 4;
            }
            case 400: {
                return 5;
            }
        }
        return -1;
    }

    public double getGap() {
        return this.gap;
    }

    public int ppi2CPI() {
        return this.ppi / this.curr_tdi.getRates();
    }

    public int remainPPI2CPI() {
        return this.ppi % this.curr_tdi.getRates() + (int)(-this.curr_xoff / (double)(this.curr_screendatalen / 1000));
    }

    public void processPlugForInit(IntBuffer intBuffer) {
        int n = this.getTimebaseIndexFromScreenDataLen(this.originalscreendatalen);
        if (n < 0) {
            return;
        }
        this.curr_tdi = this.tdis[n];
        this.curr_tdi.setupInitPos_Pluged(this.initPos, this.pluggedTrgOffset);
        this.curr_tdi.logself();
        this.doPlug(intBuffer, this.initPos, this.plugDataLength);
        this.drawPoints = this.curr_points = this.curr_tdi.getPoints();
        this.ppi = this.curr_tdi.getInitPos_Pluged() + (this.curr_points >> 1);
        this.vl.logln("ppi:" + this.ppi);
        this.curr_xoff = 0.0;
        this.computeGap();
        intBuffer.position(this.pluggedTrgOffset);
        intBuffer.limit(this.pluggedTrgOffset + this.curr_points);
    }

    private void computeGap() {
        this.gap = 1000.0 / (double)this.curr_points;
    }

    private void doPlug_ext(IntBuffer intBuffer, int n, int n2) {
        int n3 = 10;
        this.insideBuffer.position(0);
        this.insideBuffer.limit(n2 + n3);
        this.diu.retrieveBuf(this.insideBuffer, n);
        this.sinePlugForInit(intBuffer, this.sinePlugRate);
        this.linearPlug(intBuffer, this.linearPlugRate);
    }

    private void doPlug(IntBuffer intBuffer, int n, int n2) {
        this.insideBuffer.position(0);
        this.insideBuffer.limit(n2);
        this.diu.retrieveBuf(this.insideBuffer, n);
        this.sinePlugForInit(intBuffer, this.sinePlugRate);
        this.linearPlug(intBuffer, this.linearPlugRate);
    }

    private void sinePlugForInit(IntBuffer intBuffer, int n) {
        int[] nArray = intBuffer.array();
        byte[] byArray = this.insideBuffer.array();
        int n2 = this.insideBuffer.position();
        int n3 = this.insideBuffer.limit();
        int n4 = n3 - n2;
        if (n <= 1) {
            int n5 = 0;
            while (n2 < n3) {
                nArray[n5] = byArray[n2];
                ++n2;
                ++n5;
            }
            intBuffer.position(0);
            intBuffer.limit(n5);
            return;
        }
        Plug10.sine_interpolate(nArray, byArray, n4, 0, n2);
        intBuffer.position(0);
        intBuffer.limit(n4 * n);
    }

    private void linearPlug(IntBuffer intBuffer, int n) {
        if (n <= 1) {
            return;
        }
        int[] nArray = intBuffer.array();
        int n2 = intBuffer.position();
        int n3 = intBuffer.limit();
        int n4 = n3 - n2;
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, n2, nArray2, 0, n4);
        VDSource.genSimulateLinearPlug(nArray, 0, nArray2, 0, n4, n);
        intBuffer.position(0);
        intBuffer.limit(n4 * n);
    }

    public TimebaseDiluteInfo getCurrentTimebaseDiluteInfo() {
        return this.curr_tdi;
    }

    public int getDrawMode() {
        if (this.drawPoints < 1000) {
            return 7;
        }
        switch (this.drawPoints) {
            case 1000: {
                return 1;
            }
            case 2000: {
                return 2;
            }
            case 4000: {
                return 4;
            }
        }
        System.err.println("");
        return -1;
    }

    public boolean isPlug() {
        return this.plug;
    }

    public void setPlug(boolean bl) {
        this.plug = bl;
    }

    private void logln(Object object) {
    }

    public void initPlugInfo(DMDataInfo dMDataInfo, MachineType machineType) {
        if (!this.plug) {
            this.logln("screendatalen >= 1k err in Pluger.java");
        }
        this.originalscreendatalen = this.curr_screendatalen = dMDataInfo.screendatalen;
        this.initPos = dMDataInfo.initPos;
        PlugInfo plugInfo = dMDataInfo.pi;
        this.plugDataLength = plugInfo.plugDataLength;
        this.sinePlugRate = plugInfo.sinePlugRate;
        this.linearPlugRate = (int)plugInfo.linearPlugRate;
        this.pluggedTrgOffset = plugInfo.pluggedTrgOffset;
    }

    public void setGap(double d) {
        this.gap = d;
    }

    public void computeMove(int n) {
        if (this.gap < 1.0) {
            this.ppi = (int)((double)this.ppi - (double)n / this.gap);
        } else {
            this.vl.logln("computeMove");
            this.vl.logln("m:" + n);
            this.vl.logln("gap:" + this.gap);
            int n2 = (int)((double)n / this.gap);
            this.ppi -= n2;
            this.curr_xoff += (double)n - this.gap * (double)n2;
            n2 = (int)(this.curr_xoff / this.gap);
            this.ppi -= n2;
            this.curr_xoff -= this.gap * (double)n2;
            this.vl.logln("ppi:" + this.ppi);
            this.vl.logln("curr_xoff:" + this.curr_xoff);
        }
    }

    public void translate2ScreenDatalenWithoutLoad(int n, CenterPointInfo2 centerPointInfo2) {
        this.translate2ScreenDatalen(n, null, centerPointInfo2);
    }

    public void translate2ScreenDatalen(int n, IntBuffer intBuffer, CenterPointInfo2 centerPointInfo2) {
        double d = (double)n / (double)this.curr_screendatalen;
        this.vl.logln("r: " + d);
        this.curr_screendatalen = n;
        this.drawPoints = this.curr_points = (int)((double)this.curr_points * d);
        this.curr_xoff *= d;
        this.computeGap();
        this.vl.logln("gap:" + this.gap);
        this.vl.logln("ppi:" + this.ppi);
        this.after0(intBuffer, centerPointInfo2);
    }

    private void after0(IntBuffer intBuffer, CenterPointInfo2 centerPointInfo2) {
        double d = this.curr_xoff;
        int n = (int)((double)this.ppi - 500.0 / this.gap);
        int n2 = n + this.curr_points;
        this.vl.logln("i0: " + n + ", i1: " + n2);
        if (d < 0.0) {
            int n3 = (int)(-d / this.gap) + 1;
            n2 = (int)((double)n2 + (double)n3 * this.gap);
        } else if (d > 0.0) {
            int n4 = (int)(d / this.gap);
            n = (int)((double)n - (double)n4 * this.gap);
            d -= (double)n4;
            n2 = (int)((double)n2 - (double)n4 * this.gap);
        }
        this.vl.logln("then i0: " + n + ", i1: " + n2);
        centerPointInfo2.setXBloc((int)d);
        this.vl.logln("xoff:" + d);
        if (intBuffer == null) {
            return;
        }
        this.afterTranslateCompress(n, n2, intBuffer, d);
    }

    private void afterTranslateCompress(int n, int n2, IntBuffer intBuffer, double d) {
        int n3 = this.curr_tdi.getRates();
        int n4 = n / n3;
        int n5 = (n2 - n) / n3 + 1;
        int n6 = n % n3;
        this.vl.logln("iPos: " + n4);
        this.vl.logln("len: " + n5);
        this.vl.logln("remain: " + n6);
        this.doPlug_ext(intBuffer, n4, n5);
        int n7 = intBuffer.remaining();
        int n8 = (int)((1000.0 - d + 1.0) * (double)this.curr_points / 1000.0);
        if (n7 > n8) {
            n7 = n8;
        }
        intBuffer.position(intBuffer.position() + n6);
        intBuffer.limit(intBuffer.position() + n7);
        this.vl.logln("curr_points: " + this.curr_points);
        this.vl.logln("hlen: " + n7);
        int n9 = (int)d;
        if (this.curr_points > 4000) {
            int n10;
            int[] nArray = new int[4100];
            int n11 = intBuffer.limit();
            int[] nArray2 = intBuffer.array();
            int n12 = this.curr_points / 1000;
            this.vl.logln("div: " + n12);
            RangeInfo4in1 rangeInfo4in1 = new RangeInfo4in1();
            int n13 = n10 = 0;
            for (int i = intBuffer.position(); i < n11 && n10 - n13 + n9 <= 4000; i += n12) {
                LoadArrayUtil._4for1(rangeInfo4in1, nArray2, i, n12);
                n10 = rangeInfo4in1.fillArray(nArray, n10);
            }
            System.arraycopy(nArray, 0, nArray2, 0, n10);
            intBuffer.position(0);
            intBuffer.limit(n10);
            this.vl.logln("rt_ptr: " + n10);
            this.drawPoints = 4000;
        }
    }
}

