/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.common.dm;

import com.owon.uppersoft.dso.wf.common.dm.VP1_4;
import com.owon.uppersoft.dso.wf.common.dm.VP2_25;
import com.owon.uppersoft.dso.wf.common.dm.VP2_5;
import com.owon.uppersoft.dso.wf.common.dm.VP4_5;
import com.owon.uppersoft.vds.data.Range;
import com.owon.uppersoft.vds.util.format.SFormatter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public abstract class VirtualPoint {
    public static int MaxCompressTempBufferSize;
    public static byte[] tmparray;
    public int sample;
    public int pixel;
    protected int point;
    private BigDecimal rate;
    public static final int FirstValueIdx = 0;
    public static final int MinValueIdx = 1;
    public static final int MaxValueIdx = 2;
    public static final int LastValueIdx = 3;

    public static final void prepare(int[] nArray) {
        if (tmparray != null && MaxCompressTempBufferSize != 0) {
            return;
        }
        int n = nArray.length;
        MaxCompressTempBufferSize = nArray[n - 1] / 1000;
        tmparray = new byte[MaxCompressTempBufferSize + 50];
    }

    public static final void release() {
        tmparray = null;
        MaxCompressTempBufferSize = 0;
    }

    public static final VirtualPoint getInstance(int n, int n2) {
        if (n == 0 || n2 == 0) {
            VirtualPoint.errprintln("computeSavePoints can not handle!");
            return null;
        }
        if (n % n2 == 0) {
            return new VP1_4(n / n2);
        }
        int n3 = n2;
        int n4 = n;
        while (n3 % 5 == 0 && n4 % 5 == 0) {
            n3 /= 5;
            n4 /= 5;
        }
        while (n3 % 2 == 0 && n4 % 2 == 0) {
            n3 /= 2;
            n4 /= 2;
        }
        if (n3 == 2) {
            if (n4 == 5) {
                return new VP2_5();
            }
            if (n4 == 25) {
                return new VP2_25();
            }
            VirtualPoint.errprintln("computeSavePoints can not handle!");
            return null;
        }
        if (n3 == 4 && n4 == 5) {
            return new VP4_5();
        }
        VirtualPoint.errprintln("computeSavePoints can not handle!");
        return null;
    }

    protected static void errprintln(String string) {
        System.err.println(string);
    }

    public static final VirtualPoint getInstance(BigDecimal bigDecimal) {
        VP1_4 vP1_4 = new VP1_4(bigDecimal);
        return vP1_4;
    }

    public String toString() {
        return SFormatter.UIformat("sample: %d, pixel: %d, point: %d", this.sample, this.pixel, this.getPoint());
    }

    public double getRFGap() {
        return (double)this.pixel / (double)this.getPoint();
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    protected void setRate(BigDecimal bigDecimal) {
        this.rate = bigDecimal;
    }

    protected void computeRate() {
        this.rate = BigDecimal.valueOf(this.sample).divide(BigDecimal.valueOf(this.pixel));
    }

    public double getCompressRate() {
        return this.rate.doubleValue();
    }

    public boolean isCompress1Screen(double d) {
        return this.rate.doubleValue() >= d;
    }

    public abstract void compressBySavePoints_Enough(ByteBuffer var1, byte[] var2, int var3, int var4);

    public abstract void compressBySavePoints(ByteBuffer var1, byte[] var2, int var3, int var4, int var5, boolean var6);

    protected abstract int getDilute2EndRemaining(boolean var1, int var2);

    public abstract int getDrawMode();

    public int getOffsetBetween(int n) {
        return n / this.sample * this.pixel;
    }

    public int getDilute2End(int n) {
        boolean bl;
        boolean bl2 = bl = n < 0;
        if (bl) {
            n = -n;
        }
        int n2 = 0;
        n2 += n / this.pixel * this.sample;
        int n3 = n % this.pixel;
        if (n3 == 0) {
            return bl ? -n2 : n2;
        }
        return bl ? -n2 : (n2 += this.getDilute2EndRemaining(bl, n3));
    }

    public void back2NormalXOrder(Range range, byte[] byArray) {
        int n = this.getPoint();
        int n2 = range.left / n;
        if (n2 > 1) {
            int n3 = 0;
            int n4 = range.left - n;
            --n2;
            byte[] byArray2 = new byte[10];
            for (int i = 0; i < n2; ++i, --n2) {
                System.arraycopy(byArray, n3, byArray2, 0, n);
                System.arraycopy(byArray, n4, byArray, n3, n);
                System.arraycopy(byArray2, 0, byArray, n4, n);
                n3 += n;
                n4 -= n;
            }
        }
    }

    public int xyrangeoffset2xoffset(int n, Range range) {
        int n2 = n + 1 - range.left / this.getPoint() * this.pixel;
        return n2;
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int n) {
        this.point = n;
    }
}

