/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.common.dm;

import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.wf.common.dm.CompressInfoUnit;
import com.owon.uppersoft.dso.wf.common.dm.IDiluteInfoUnit;
import com.owon.uppersoft.dso.wf.common.dm.InfoUnit;
import com.owon.uppersoft.vds.core.data.CByteArrayInputStream;
import com.owon.uppersoft.vds.core.machine.MachineInfo;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import java.awt.Graphics;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public abstract class LocInfo {
    public int initPos;
    public int screendatalen;
    public int slowmove;
    public int filePointer;
    public int datalen;
    public BigDecimal bdtb;
    public BigDecimal bdfsl;
    public final int pixs;
    public final int halfpixs;
    public int fsrate;
    public boolean wasSlowMove;
    public boolean shouldReverse;
    public int loadPos0;
    private boolean compress;
    protected IDiluteInfoUnit diu;
    protected CompressInfoUnit ciu;

    public LocInfo() {
        this.pixs = 1000;
        this.halfpixs = this.pixs >> 1;
        this.datalen = -1;
    }

    public void release() {
        if (this.diu != null) {
            this.diu.release();
        }
        if (this.ciu != null) {
            this.ciu.release();
        }
    }

    public void prepareDM(ScreenContext screenContext, DMDataInfo dMDataInfo, BigDecimal bigDecimal, int n, int n2, boolean bl, MachineType machineType, DMInfo dMInfo) {
        int n3;
        this.datalen = dMDataInfo.datalen;
        this.slowmove = dMDataInfo.slowMove;
        this.loadPos0 = dMDataInfo.pos0;
        this.shouldReverse = bl;
        this.filePointer = dMDataInfo.filePointer;
        this.screendatalen = dMDataInfo.screendatalen;
        this.initPos = dMDataInfo.initPos;
        this.fsrate = this.datalen / this.pixs;
        this.bdtb = bigDecimal;
        this.bdfsl = BigDecimal.valueOf(this.screendatalen);
        this.wasSlowMove = this.getMachineInfo().isSlowMove(n2);
        if (this.wasSlowMove && (n3 = this.datalen / this.pixs) > 1) {
            this.slowmove -= this.slowmove % n3;
            if (this.slowmove < 0) {
                this.slowmove = 0;
            }
        }
        this.compress = this.becomeCompress(this.screendatalen);
        this.diu = this.createDiluteInfoUnit(this);
        this.ciu = new CompressInfoUnit();
        this.diu.setPlug(!this.compress);
        this.prepareBeforeInitLoadInfoUnit(dMInfo);
        this.diu.reinit();
        if (this.compress) {
            this.ciu.initLoad(this, dMDataInfo);
        } else {
            this.diu.initLoad(dMDataInfo, n2, machineType);
        }
    }

    protected abstract void prepareBeforeInitLoadInfoUnit(DMInfo var1);

    protected abstract IDiluteInfoUnit createDiluteInfoUnit(LocInfo var1);

    protected InfoUnit getInfoUnit() {
        if (this.isCompress()) {
            return this.ciu;
        }
        return this.diu;
    }

    public boolean isCompress() {
        return this.compress;
    }

    private boolean becomeCompress(int n) {
        return n >= this.pixs;
    }

    private boolean becomeCompress(double d) {
        return d >= (double)this.pixs;
    }

    public DataHouse getDataHouse() {
        return Platform.getDataHouse();
    }

    public void setTimebaseIndex(int n) {
        BigDecimal bigDecimal = this.getMachineInfo().bdTIMEBASE[n];
        if (this.bdtb == null) {
            System.err.println("bdtb==null");
        }
        BigDecimal bigDecimal2 = bigDecimal.divide(this.bdtb);
        BigDecimal bigDecimal3 = this.bdfsl.multiply(bigDecimal2);
        double d = bigDecimal3.doubleValue();
        boolean bl = this.becomeCompress(d);
        if (this.isCompress()) {
            if (bl) {
                this.ciu.tbTranslate(this.bdtb, bigDecimal, n);
            } else {
                this.ciu.tbTranslate2D(this.bdtb, bigDecimal, this.diu, n);
                this.compress = false;
            }
        } else if (bl) {
            this.diu.tbTranslate2C(this.bdtb, bigDecimal, this.ciu, n);
            this.compress = true;
        } else {
            this.diu.tbTranslate(this.bdtb, bigDecimal, n);
        }
        this.bdtb = bigDecimal;
        this.bdfsl = bigDecimal3;
    }

    public CByteArrayInputStream getDeepMemoryStorage() {
        return this.getDataHouse().getDeepMemoryStorage();
    }

    public MachineInfo getMachineInfo() {
        return this.getDataHouse().controlManager.getMachineInfo();
    }

    public void addWaveFormsXloc(int n) {
        this.getInfoUnit().computeMove(-n);
    }

    public void drawView(Graphics graphics, int n, int n2, int n3, int n4) {
        this.getInfoUnit().drawView(graphics, n, n2, n3, n4);
    }

    public void resetIntBuf(BigDecimal bigDecimal, int n, boolean bl) {
        this.getInfoUnit().resetDMIntBuf(bigDecimal, n, bl);
    }

    public int getXoffset() {
        return this.getInfoUnit().getXoffset();
    }

    public ByteBuffer getADC_Buf() {
        if (this.datalen <= 0) {
            return null;
        }
        if (this.isCompress()) {
            return this.ciu.getb_adcbuf();
        }
        return this.diu.getb_adcbuf();
    }

    public double getGap() {
        if (this.isCompress()) {
            return this.ciu.getGap();
        }
        return this.diu.getGap();
    }

    public int getDrawMode() {
        if (this.isCompress()) {
            return this.ciu.getDrawMode();
        }
        return this.diu.getDrawMode();
    }
}

