/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.common.dm;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.wf.common.dm.IDiluteInfoUnit;
import com.owon.uppersoft.dso.wf.common.dm.InfoUnit;
import com.owon.uppersoft.dso.wf.common.dm.LocInfo;
import com.owon.uppersoft.dso.wf.common.dm.VirtualPoint;
import com.owon.uppersoft.dso.wf.common.dm.VirtualPointHandler;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.data.Range;
import com.owon.uppersoft.vds.util.PrimaryTypeUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class CompressInfoUnit
implements InfoUnit {
    private IntBuffer pixbuf;
    private ByteBuffer b_adcbuf;
    private LocInfo li;
    private Range ap;
    private VirtualPointHandler vph;
    private VirtualPoint vp;
    private int scpi;
    private int cpoff;
    private int xoffset;
    private int pixs;
    private int halfpixs;
    private int datalen;
    private int filePointer;
    private int initPos;
    private int screendatalen;
    private int databeg;
    private int bufcpoff = 0;

    private void prepare(LocInfo locInfo) {
        this.li = locInfo;
        this.pixs = locInfo.pixs;
        this.halfpixs = locInfo.halfpixs;
        this.datalen = locInfo.datalen;
        this.filePointer = locInfo.filePointer;
        this.initPos = locInfo.initPos;
        this.screendatalen = locInfo.screendatalen;
        this.databeg = locInfo.wasSlowMove ? this.datalen - locInfo.slowmove : 0;
        this.ap = new Range();
        this.vph = new VirtualPointHandler(locInfo.getDeepMemoryStorage(), this.filePointer, this.datalen);
        this.prepareBuffer();
        VirtualPoint.prepare(locInfo.getMachineInfo().DEEPValue);
    }

    private void prepareBuffer() {
        if (this.b_adcbuf == null) {
            this.b_adcbuf = ByteBuffer.allocate(4100).order(ByteOrder.BIG_ENDIAN);
            this.pixbuf = IntBuffer.allocate(4100);
            this.pixbuf.position(0);
            this.pixbuf.limit(0);
        }
    }

    private void logln(String string) {
        System.err.println(string);
    }

    public void initLoad(LocInfo locInfo, DMDataInfo dMDataInfo) {
        this.prepare(locInfo);
        this.initPos += dMDataInfo.pi.pluggedTrgOffset;
        this.scpi = this.initPos + (this.screendatalen >> 1);
        this.vp = VirtualPoint.getInstance(this.screendatalen, this.pixs);
        if (this.vp.sample <= 0) {
            this.logln("VirtualPoint.getInstance(screendatalen, pixs).sample == 0!!!");
        }
        this.cpoff = 0;
        this.bufcpoff = 0;
        this.computeXOffset();
    }

    protected void computeXOffset() {
        this.xoffset = this.vph.compressExecute(this.vp, 0, this.pixs, this.halfpixs + this.cpoff, this.scpi, this.b_adcbuf, this.databeg, this.datalen, this.ap, this.isCompress1Screen(), this.li.shouldReverse, this.li.loadPos0);
        this.confirmADCBuffer(this.b_adcbuf);
    }

    private int getHorTrgPos(int n) {
        int n2 = -this.cpoff - this.vp.getOffsetBetween(this.scpi - n) + this.bufcpoff;
        return n2;
    }

    public VirtualPointHandler getVirtualPointHandler() {
        return this.vph;
    }

    @Override
    public void release() {
        VirtualPoint.release();
        this.b_adcbuf = null;
    }

    @Override
    public void save2RefIntBuffer(IntBuffer intBuffer, int n) {
        int n2;
        ByteBuffer byteBuffer = this.b_adcbuf;
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.limit();
        for (int i = n2 = byteBuffer.position(); i < n3; ++i) {
            intBuffer.put(byArray[i] - n);
        }
        intBuffer.position(0);
        intBuffer.limit(n3 - n2);
    }

    private boolean isCompress1Screen() {
        return this.vp.isCompress1Screen(this.li.fsrate);
    }

    @Override
    public void computeMove(int n) {
        if (this.isCompress1Screen()) {
            this.xoffset += n;
            this.bufcpoff += n;
            return;
        }
        if (this.vp.pixel == 1) {
            this.scpi -= n * this.vp.sample;
        } else {
            int n2 = this.vp.pixel;
            int n3 = this.vp.sample;
            this.scpi -= n / n2 * n3;
            int n4 = n % n2;
            this.cpoff += n4;
            int n5 = this.cpoff;
            if (this.cpoff > 0) {
                int n6 = n5 / n2;
                this.scpi -= n6 * n3;
                this.cpoff -= n6 * n2;
            } else {
                n5 = -n5;
                int n7 = n5 / n2;
                this.scpi += n7 * n3;
                this.cpoff = -(n5 - n7 * n2);
            }
        }
        if (this.b_adcbuf == null) {
            this.logln("CompressInfoUnit.b_adcbuf==null");
        }
        this.computeXOffset();
    }

    @Override
    public void resetDMIntBuf(BigDecimal bigDecimal, int n, boolean bl) {
        boolean bl2 = PrimaryTypeUtil.canHoldAsInt(bigDecimal);
        if (this.b_adcbuf == null) {
            return;
        }
        if (bl2) {
            this.vph.transcriptionInt(this.b_adcbuf, this.pixbuf, bigDecimal, n, bl);
        } else {
            this.vph.transcriptionDouble(this.b_adcbuf, this.pixbuf, bigDecimal, n, bl);
        }
    }

    private void tbTranslate_(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n;
        BigDecimal bigDecimal3 = bigDecimal2.divide(bigDecimal);
        BigDecimal bigDecimal4 = bigDecimal3.multiply(this.vp.getRate());
        BigDecimal bigDecimal5 = bigDecimal4.multiply(BigDecimal.valueOf(this.pixs));
        VirtualPoint virtualPoint = this.vp;
        this.scpi -= virtualPoint.getDilute2End(this.cpoff + this.bufcpoff);
        this.bufcpoff = 0;
        this.cpoff = 0;
        if (!PrimaryTypeUtil.canHoldAsInt(bigDecimal5)) {
            this.vp = VirtualPoint.getInstance(bigDecimal4);
        } else {
            n = bigDecimal5.intValue();
            this.vp = VirtualPoint.getInstance(n, this.pixs);
        }
        n = this.vp.sample;
        if (n == 0) {
            this.logln("v = getMultiply(screendatalen, pixs) == 0!!!");
        }
    }

    @Override
    public void tbTranslate(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n) {
        this.tbTranslate_(bigDecimal, bigDecimal2);
        this.computeXOffset();
    }

    public void tbTranslate2D(BigDecimal bigDecimal, BigDecimal bigDecimal2, IDiluteInfoUnit iDiluteInfoUnit, int n) {
        BigDecimal bigDecimal3 = null;
        bigDecimal3 = bigDecimal.divide(this.vp.getRate());
        this.tbTranslate_(bigDecimal, bigDecimal3);
        this.release();
        iDiluteInfoUnit.fakeIn(this.scpi, n);
        iDiluteInfoUnit.tbTranslate(bigDecimal3, bigDecimal2, n);
    }

    @Override
    public void confirmADCBuffer(ByteBuffer byteBuffer) {
    }

    @Override
    public ByteBuffer getb_adcbuf() {
        return this.b_adcbuf;
    }

    public void fakeIn(int n, int n2, LocInfo locInfo, int n3) {
        this.prepare(locInfo);
        this.scpi = n;
        this.vp = VirtualPoint.getInstance(this.pixs, this.pixs);
        this.cpoff = n3;
    }

    @Override
    public void drawView(Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = 5;
        int n6 = n5 << 1;
        int n7 = this.datalen;
        if (this.vp == null) {
            this.logln("ERR:CompressInfoUnit,VirtualPoint==null");
        }
        int n8 = n7 / this.vp.sample;
        graphics2D.setColor(Color.LIGHT_GRAY);
        if (this.isCompress1Screen()) {
            int n9 = (int)((double)n8 * (double)n3 / (double)this.pixs);
            int n10 = n + (n3 - n9 >> 1);
            graphics2D.drawLine(n10, n2, n9 + n10, n2);
            int n11 = (int)((double)n4 * (double)n9 / (double)n7 + (double)n10);
            if (n11 <= n) {
                n11 = n;
            } else if (n11 >= n + n3) {
                n11 = n + n3;
            }
            int n12 = 1000;
            int n13 = n11 - (int)((double)((n12 >> 1) - Platform.getDataHouse().controlManager.getTimeControl().getHorizontalTriggerPosition()) / (double)n12 * (double)n3);
            int n14 = n13 + n3;
            graphics2D.drawLine(n13, n2 - n5, n13, n2 + n5);
            graphics2D.drawLine(n14, n2 - n5, n14, n2 + n5);
            graphics2D.setColor(Color.MAGENTA);
            int n15 = n2 - n5;
            int n16 = n2 - n6;
            graphics2D.drawLine(n11, n15, n11, n16);
            graphics2D.drawLine(n11 - 1, n16 + 2, n11 - 1, n16);
            graphics2D.drawLine(n11 + 1, n16 + 2, n11 + 1, n16);
        } else {
            int n17 = (int)((double)this.pixs * (double)n3 / (double)n8);
            int n18 = (int)((double)this.scpi * (double)n3 / (double)n7 - (double)(n17 >> 1) + (double)n);
            int n19 = n18 + n17;
            graphics2D.drawLine(n18, n2 - n5, n18, n2 + n5);
            graphics2D.drawLine(n19, n2 - n5, n19, n2 + n5);
            n18 = n;
            n19 = n + n3;
            graphics2D.drawLine(n18, n2, n19, n2);
            graphics2D.setColor(Color.MAGENTA);
            int n20 = (int)((double)n4 * (double)n3 / (double)n7 + (double)n);
            if (n20 <= n) {
                n20 = n;
            } else if (n20 >= n + n3) {
                n20 = n + n3;
            }
            int n21 = n2 - n5;
            int n22 = n2 - n6;
            graphics2D.drawLine(n20, n21, n20, n22);
            graphics2D.drawLine(n20 - 1, n22 + 2, n20 - 1, n22);
            graphics2D.drawLine(n20 + 1, n22 + 2, n20 + 1, n22);
        }
    }

    @Override
    public double getGap() {
        return this.vp.getRFGap();
    }

    @Override
    public int getXoffset() {
        return this.xoffset;
    }

    @Override
    public int getDrawMode() {
        return this.vp.getDrawMode();
    }
}

