/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.common;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.machine.aspect.IMultiWFManager;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.WaveFormInfoControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.ChannelInverseTranslator;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.data.OfflineInfo;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;

public class MultiWFManager
implements IMultiWFManager {
    private ControlManager cm;
    private ChannelInverseTranslator cit;

    public MultiWFManager(ControlManager controlManager) {
        this.cm = controlManager;
        this.cit = new ChannelInverseTranslator();
    }

    protected void doReceiveRTData(LoadMedia loadMedia, ScreenContext screenContext, WaveFormManager waveFormManager, boolean bl) {
        Iterator<? extends ChannelDataInfo> iterator = loadMedia.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            int n = channelDataInfo.chl;
            WaveForm waveForm = waveFormManager.getWaveForm(n);
            waveForm.setDm_xoffset(channelDataInfo.xoffset);
            waveForm.prepareRTNormalPaint(channelDataInfo, loadMedia, bl ? screenContext.getHcenter() : waveForm.getYb(screenContext));
            loadMedia.retireInstance(channelDataInfo);
        }
        if (loadMedia.getChannelCount() > 0) {
            waveFormManager.afterWaveFormsFeed(screenContext);
        }
    }

    @Override
    public void receiveRTData(LoadMedia loadMedia, ScreenContext screenContext, WaveFormManager waveFormManager, boolean bl) {
        BigDecimal bigDecimal = this.cm.getCurrentSampleRateBD_kHz();
        MachineType machineType = this.cm.getMachine();
        Iterator<? extends ChannelDataInfo> iterator = loadMedia.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            int n = channelDataInfo.chl;
            WaveForm waveForm = waveFormManager.getWaveForm(n);
            ChannelInfo channelInfo = waveForm.wfi.ci;
            channelDataInfo.computeFreq(bigDecimal, machineType);
            waveForm.saveFirstLoadPos0();
            if (!bl) continue;
            channelInfo.updateFreqLabel(channelDataInfo.getFrequencyFloat());
        }
        this.doReceiveRTData(loadMedia, screenContext, waveFormManager, true);
    }

    @Override
    public void receiveOfflineData(LoadMedia loadMedia, ScreenContext screenContext, WaveFormManager waveFormManager) {
        Iterator<? extends ChannelDataInfo> iterator = loadMedia.iterator_ChannelDataInfo();
        while (iterator.hasNext()) {
            ChannelDataInfo channelDataInfo = iterator.next();
            int n = channelDataInfo.chl;
            WaveForm waveForm = waveFormManager.getWaveForm(n);
            ChannelInfo channelInfo = waveForm.wfi.ci;
            channelInfo.setOn(true);
            OfflineInfo offlineInfo = channelDataInfo.oi;
            channelInfo.setVoltbaseIndex(offlineInfo.vbIdx, false, false);
            channelInfo.setPos0(offlineInfo.pos0);
            waveForm.saveFirstLoadPos0();
            channelInfo.setProbeMultiIdx(offlineInfo.probeMultiIdx);
            channelInfo.c_setInverse(this.cit.setOfflineInverseType_Normal(channelDataInfo.getInverseType()));
            channelInfo.updateFreqLabel(channelDataInfo.getFrequencyFloat());
        }
        this.doReceiveRTData(loadMedia, screenContext, waveFormManager, true);
    }

    @Override
    public void receiveOfflineDMData(DMInfo dMInfo, ScreenContext screenContext, BigDecimal bigDecimal, int n, WaveFormManager waveFormManager) {
        LinkedList<DMDataInfo> linkedList = dMInfo.channels;
        waveFormManager.offAllWaveForms();
        for (DMDataInfo dMDataInfo : linkedList) {
            boolean bl;
            int n2 = dMDataInfo.chl;
            WaveForm waveForm = waveFormManager.getWaveForm(n2);
            ChannelInfo channelInfo = waveForm.wfi.ci;
            channelInfo.setOn(true);
            channelInfo.setVoltbaseIndex(dMDataInfo.vbIdx, false, false);
            channelInfo.setPos0(dMDataInfo.pos0);
            waveForm.saveFirstLoadPos0();
            dMDataInfo.shouldInverse = bl = this.cit.setOfflineInverseType_DM(dMDataInfo.inverseType);
            channelInfo.c_setInverse(bl);
            channelInfo.setProbeMultiIdx(dMDataInfo.probeMultiIdx);
            channelInfo.updateFreqLabel(dMDataInfo.getFrequencyFloat());
            waveForm.wfi.prepareDM(screenContext, dMDataInfo, bigDecimal, n, channelInfo.getVoltbaseIndex(), this.cm.getMachine(), dMInfo);
        }
        this.simulateInitAsDM(dMInfo, screenContext, waveFormManager, true, n);
    }

    @Override
    public void receiveRTDMData(DMInfo dMInfo, ScreenContext screenContext, BigDecimal bigDecimal, int n, WaveFormManager waveFormManager) {
        LinkedList<DMDataInfo> linkedList = dMInfo.channels;
        for (DMDataInfo dMDataInfo : linkedList) {
            int n2 = dMDataInfo.chl;
            WaveForm waveForm = waveFormManager.getWaveForm(n2);
            dMDataInfo.shouldInverse = this.cit.setRTInverseType_DM(waveForm.wfi.ci.isInverse());
            ChannelInfo channelInfo = waveForm.wfi.ci;
            channelInfo.updateFreqLabel(dMDataInfo.getFrequencyFloat());
            waveForm.wfi.prepareDM(screenContext, dMDataInfo, bigDecimal, n, channelInfo.getVoltbaseIndex(), this.cm.getMachine(), dMInfo);
        }
        dMInfo.setPKDetect(this.cm.isPeakDetectWork());
        this.simulateInitAsDM(dMInfo, screenContext, waveFormManager, false, this.cm.getTimeControl().getTimebaseIdx());
    }

    protected void simulateInitAsDM(DMInfo dMInfo, ScreenContext screenContext, WaveFormManager waveFormManager, boolean bl, int n) {
        WFTimeScopeControl wFTimeScopeControl = waveFormManager.getWFTimeScopeControl();
        WaveFormInfoControl waveFormInfoControl = this.cm.getWaveFormInfoControl();
        ChannelsTransportInfo channelsTransportInfo = this.retrieveChannelsTransportInfoFromDM(false, bl, waveFormInfoControl);
        wFTimeScopeControl.loadDM(channelsTransportInfo, dMInfo.isPKDetect(), this.retrieveDrawModeFromDM(waveFormInfoControl), this.getDMGap(waveFormInfoControl));
        this.doReceiveRTData(channelsTransportInfo, screenContext, waveFormManager, bl);
    }

    @Override
    public void simulateReloadAsDM(ScreenContext screenContext, WaveFormInfoControl waveFormInfoControl, WFTimeScopeControl wFTimeScopeControl, WaveFormManager waveFormManager) {
        ChannelsTransportInfo channelsTransportInfo = this.retrieveChannelsTransportInfoFromDM(false, false, waveFormInfoControl);
        wFTimeScopeControl.loadDM(channelsTransportInfo, wFTimeScopeControl.isPK_Detect(), this.retrieveDrawModeFromDM(waveFormInfoControl), this.getDMGap(waveFormInfoControl));
        this.doReceiveRTData(channelsTransportInfo, screenContext, waveFormManager, false);
    }

    public ChannelsTransportInfo retrieveChannelsTransportInfoFromDM(boolean bl, boolean bl2, WaveFormInfoControl waveFormInfoControl) {
        ChannelsTransportInfo channelsTransportInfo = Platform.getControlApps().getDaemon().getChannelsTransportInfo();
        channelsTransportInfo.reset('T');
        int n = waveFormInfoControl.getLowMachineChannels();
        for (int i = 0; i < n; ++i) {
            WaveFormInfo waveFormInfo = waveFormInfoControl.getWaveFormInfo(i);
            ChannelInfo channelInfo = waveFormInfo.ci;
            if (!channelInfo.isOn()) continue;
            int n2 = channelInfo.getNumber();
            ChannelDataInfo channelDataInfo = channelsTransportInfo.getInstance();
            channelDataInfo.chl = n2;
            if (channelInfo.isInverse()) {
                channelDataInfo.setInverseType(1);
            } else {
                channelDataInfo.setInverseType(0);
            }
            ByteBuffer byteBuffer = waveFormInfo.getADC_Buf();
            if (byteBuffer == null) continue;
            channelDataInfo.initPos = byteBuffer.position();
            channelDataInfo.datalen = channelDataInfo.screendatalen = byteBuffer.remaining();
            channelDataInfo.slowMove = 0;
            channelDataInfo.xoffset = waveFormInfo.getXOffset_DM();
            channelDataInfo.setUniqueAdcbuf(byteBuffer);
            channelsTransportInfo.addChannelDataInfo(channelDataInfo);
        }
        channelsTransportInfo.setDataComplete(1);
        return channelsTransportInfo;
    }

    public double getDMGap(WaveFormInfoControl waveFormInfoControl) {
        WaveFormInfo waveFormInfo = waveFormInfoControl.getWaveFormInfoForDM();
        if (waveFormInfo == null) {
            return -1.0;
        }
        return waveFormInfo.getDMGap();
    }

    public int retrieveDrawModeFromDM(WaveFormInfoControl waveFormInfoControl) {
        WaveFormInfo waveFormInfo = waveFormInfoControl.getWaveFormInfoForDM();
        if (waveFormInfo == null) {
            return -1;
        }
        return waveFormInfo.getDrawMode();
    }
}

