/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf.common;

import com.owon.uppersoft.dso.function.PersistentDisplay;
import com.owon.uppersoft.dso.function.RecordControl;
import com.owon.uppersoft.dso.function.record.OfflineChannelsInfo;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.CoreControl;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.machine.aspect.IMultiReceiver;
import com.owon.uppersoft.dso.mode.control.TimeControl;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.view.ToolPane;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.dm.DMInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelsTransportInfo;
import com.owon.uppersoft.vds.print.PrinterPreviewFrame;
import java.math.BigDecimal;

public class MultiReceiver
implements IMultiReceiver {
    private ControlManager cm;
    private WaveFormManager wfm;
    private ScreenContext pc;
    private TimeControl tc;
    private int drawCount = 0;

    public MultiReceiver(ControlManager controlManager, WaveFormManager waveFormManager) {
        this.cm = controlManager;
        this.wfm = waveFormManager;
        this.pc = controlManager.paintContext;
        this.tc = controlManager.getTimeControl();
    }

    protected void dataCompleteNIncrease(DataHouse dataHouse) {
        dataHouse.dataComplete();
        ++this.drawCount;
    }

    protected void resetDrawCount() {
        this.drawCount = 0;
    }

    @Override
    public void receiveOfflineData(OfflineChannelsInfo offlineChannelsInfo, DataHouse dataHouse, int n) {
        if (offlineChannelsInfo.getChannelCount() == 0) {
            return;
        }
        if (offlineChannelsInfo.getFrameCount() == 0) {
            return;
        }
        dataHouse.setStatus(n);
        dataHouse.dataComplete();
        MainWindow mainWindow = Platform.getMainWindow();
        ToolPane toolPane = mainWindow.getToolPane();
        boolean bl = this.cm.getCoreControl().isRunMode_slowMove();
        int n2 = this.cm.getMachineInfo().getDMIndexFromLength(offlineChannelsInfo.DMlen);
        if (n2 >= 0) {
            this.cm.getDeepMemoryControl().setDeepIdx(n2);
        }
        this.tc.setHorTrgPos(offlineChannelsInfo.horTrgPos);
        this.cm.getCoreControl().updateHorTrgIdx4View();
        this.cm.getCoreControl().updateHorTrgPosRange();
        this.wfm.offAllWaveForms();
        this.wfm.receiveOfflineData(offlineChannelsInfo, this.pc, bl, offlineChannelsInfo.timebase);
        this.tc.offline_setTimeBaseIdx(offlineChannelsInfo.timebase);
        this.cm.measure(this.wfm);
        this.tc.recomputeHorizontalTriggerLabel();
        mainWindow.updateShow();
        toolPane.updateChannels();
        mainWindow.getITitleStatus().updateView();
        this.cm.pcs.firePropertyChange("onTimebaseUpdated", null, null);
        this.cm.pcs.firePropertyChange("APPLY_CHANNELS", null, null);
        PrinterPreviewFrame.selfRepaint();
    }

    @Override
    public void receiveOfflineDMData(DMInfo dMInfo, DataHouse dataHouse) {
        if (dMInfo.channelNum == 0) {
            return;
        }
        dataHouse.dataNotComplete();
        dataHouse.setStatus(2);
        MainWindow mainWindow = Platform.getMainWindow();
        ToolPane toolPane = mainWindow.getToolPane();
        CoreControl coreControl = this.cm.getCoreControl();
        int n = this.cm.getMachineInfo().getDMIndexFromLength(dMInfo.datalen);
        dataHouse.setupDeepMemoryStorage(dMInfo.file);
        int n2 = dMInfo.timebase;
        BigDecimal bigDecimal = coreControl.getTimeConfProvider().getBDTimebase(n2);
        this.cm.getDeepMemoryControl().setDeepIdx(n);
        this.tc.setHorTrgPos(dMInfo.horTrgPos);
        int n3 = dMInfo.initPos;
        int n4 = dMInfo.getScreendatalen();
        coreControl.updateDMHorTrgIdx4View(n3, n4);
        coreControl.updateHorTrgPosRange();
        this.tc.setTimebaseIndexValue(n2);
        this.wfm.receiveOfflineDMData(dMInfo, this.pc, bigDecimal, n2);
        dataHouse.dataComplete();
        this.tc.offline_setTimeBaseIdx(n2);
        this.cm.measure(this.wfm);
        this.tc.recomputeHorizontalTriggerLabel();
        this.cm.pcs.firePropertyChange("APPLY_CHANNELS", null, null);
        mainWindow.updateShow();
        toolPane.updateChannels();
        mainWindow.getITitleStatus().updateView();
        this.cm.pcs.firePropertyChange("onTimebaseUpdated", null, null);
        PrinterPreviewFrame.selfRepaint();
    }

    @Override
    public void reloadRTData(ChannelsTransportInfo channelsTransportInfo, DataHouse dataHouse) {
        if (channelsTransportInfo.getFrameCount() == 0) {
            return;
        }
        boolean bl = this.cm.getCoreControl().isRunMode_slowMove();
        this.wfm.receiveRTData(channelsTransportInfo, this.pc, bl);
        this.cm.updateMeasure(this.wfm);
    }

    @Override
    public void receiveRTData(ChannelsTransportInfo channelsTransportInfo, DataHouse dataHouse) {
        Object object;
        dataHouse.dataNotComplete();
        if (channelsTransportInfo.getChannelCount() == 0 || channelsTransportInfo.getDataComplete() == 0) {
            return;
        }
        if (channelsTransportInfo.getFrameCount() == 0) {
            return;
        }
        dataHouse.setStatus(11);
        this.dataCompleteNIncrease(dataHouse);
        MainWindow mainWindow = Platform.getMainWindow();
        ToolPane toolPane = mainWindow.getToolPane();
        boolean bl = this.cm.getCoreControl().isRunMode_slowMove();
        if (!bl && channelsTransportInfo.slowMove > 0) {
            object = this.cm.getMachine();
            boolean bl2 = object.passSlowOnNoneSlowTimebase();
            if (bl2) {
                channelsTransportInfo.slowMove = 0;
            } else {
                return;
            }
        }
        this.cm.getCoreControl().updateHorTrgIdx4View();
        this.wfm.receiveRTData(channelsTransportInfo, this.pc, bl);
        this.cm.updateMeasure(this.wfm);
        object = dataHouse.getPersistentDisplay();
        if (((PersistentDisplay)object).isUseCanvasBuffer()) {
            ((PersistentDisplay)object).bufferWaveForms(this.pc, this.wfm, mainWindow);
        } else {
            mainWindow.updateShow();
        }
        toolPane.updateAfterData();
        RecordControl recordControl = this.cm.rc;
        recordControl.recordOnce(this.wfm, channelsTransportInfo);
    }

    @Override
    public void receiveRTDMData(DMInfo dMInfo, DataHouse dataHouse) {
        if (dMInfo.channelNum == 0 || dMInfo.dataComplete == 0) {
            return;
        }
        dataHouse.setStatus(12);
        dataHouse.dataComplete();
        MainWindow mainWindow = Platform.getMainWindow();
        ToolPane toolPane = mainWindow.getToolPane();
        dataHouse.setupDeepMemoryStorage(dMInfo.file);
        int n = dMInfo.initPos;
        int n2 = dMInfo.getScreendatalen();
        this.cm.getCoreControl().updateDMHorTrgIdx4View(n, n2);
        this.wfm.receiveRTDMData(dMInfo, this.pc, this.tc.getBDTimebase(), this.tc.getTimebaseIdx());
        mainWindow.updateShow();
        toolPane.updateAfterData();
    }
}

