/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.model.WFTimeScopeControl;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.ref.IRefSource;
import com.owon.uppersoft.dso.util.ui.LineUtil;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.dso.wf.rt.RTLocInfoManager;
import com.owon.uppersoft.vds.core.aspect.IView;
import com.owon.uppersoft.vds.core.aspect.help.WF;
import com.owon.uppersoft.vds.core.measure.MeasureADC;
import com.owon.uppersoft.vds.core.paint.ScreenContext;
import com.owon.uppersoft.vds.core.wf.WaveFormInfo;
import com.owon.uppersoft.vds.core.wf.rt.ChannelDataInfo;
import com.owon.uppersoft.vds.core.wf.rt.LoadMedia;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class WaveForm
implements IView,
WF,
IRefSource {
    private MeasureADC madc;
    public WaveFormInfo wfi;
    public DataHouse dh;
    private ControlManager cm;
    public boolean onShowPos0 = false;
    private RTLocInfoManager rtlim;
    private int loadPos0;
    public int basevbidx = 0;
    private BigDecimal vbmulti = BigDecimal.valueOf(1L);
    private int dm_xoffset = 0;

    @Override
    public int getPos0() {
        return this.wfi.ci.getPos0();
    }

    @Override
    public int getWaveType() {
        return 0;
    }

    public boolean isGround() {
        return this.wfi.ci.isGround();
    }

    @Override
    public boolean isOn() {
        return this.wfi.ci.isOn();
    }

    public Color getColor() {
        return this.wfi.ci.getColor();
    }

    @Override
    public MeasureADC getMeasureADC() {
        return this.madc;
    }

    @Override
    public int getProbeMultiIdx() {
        return this.wfi.ci.getProbeMultiIdx();
    }

    public boolean equals(Object object) {
        if (object instanceof WaveForm) {
            WaveForm waveForm = (WaveForm)object;
            return this.wfi.ci.getNumber() == waveForm.wfi.ci.getNumber();
        }
        return false;
    }

    @Override
    public int getChannelNumber() {
        return this.wfi.ci.getNumber();
    }

    public boolean isInverted() {
        return this.wfi.ci.isInverse();
    }

    public String toString() {
        return this.wfi.ci.getName();
    }

    @Override
    public int getVoltbaseIndex() {
        return this.wfi.ci.getVoltbaseIndex();
    }

    @Override
    public int getPos0ForADC() {
        return this.wfi.ci.getPos0();
    }

    public int getPos0onChart(ScreenContext screenContext) {
        int n = screenContext.getHcenter();
        if (screenContext.isScreenMode_3()) {
            return n - this.wfi.ci.getPos0();
        }
        return n - (this.wfi.ci.getPos0() << 1);
    }

    public WaveForm(DataHouse dataHouse, WaveFormInfo waveFormInfo) {
        this.dh = dataHouse;
        this.wfi = waveFormInfo;
        this.cm = dataHouse.controlManager;
        this.rtlim = new RTLocInfoManager(this);
        this.madc = new MeasureADC();
    }

    @Override
    public IntBuffer save2RefIntBuffer() {
        return this.rtlim.save2RefIntBuffer();
    }

    @Override
    public ByteBuffer getADC_Buffer() {
        return this.rtlim.rtliADC_Buffer();
    }

    public ByteBuffer getFFT_Buffer() {
        return this.getADC_Buffer();
    }

    public ByteBuffer getNextFrameADCBuffer(int n) {
        return this.rtlim.getNextFrameADCBuffer(n);
    }

    @Override
    public boolean isADCBeyondMax() {
        return this.rtlim.isRtADC_MaxBeyond();
    }

    @Override
    public boolean isADCBeyondMin() {
        return this.rtlim.isRtADC_MinBeyond();
    }

    public int computeMiddle() {
        return this.rtlim.computeMiddle();
    }

    public void reduceFrame() {
        this.rtlim.restrictFrames(1, this.getChannelNumber());
    }

    public void prepareRTNormalPaint(ChannelDataInfo channelDataInfo, LoadMedia loadMedia, int n) {
        ScreenContext screenContext = this.getScreenContext();
        ChannelInfo channelInfo = this.wfi.ci;
        this.basevbidx = channelInfo.getVoltbaseIndex();
        this.rtlim.resetRTIntBuf(channelDataInfo, screenContext, this.dh.getWaveFormManager().getSkipPoints(), n, loadMedia, this.vbmulti);
    }

    public boolean setVoltBaseIndex(int n, boolean bl) {
        ChannelInfo channelInfo = this.wfi.ci;
        int n2 = channelInfo.getValidVotageChangeIndex(n);
        if (n2 < 0) {
            return false;
        }
        channelInfo.c_setVoltage(n2, this.cm.getResetPersistenceRunnable());
        if (bl) {
            this.update_Voltbase(n2);
        }
        return true;
    }

    private void update_Voltbase(int n) {
        this.updateVBMulti(n);
        this.resetNormalIntBuf(this.getScreenContext());
        this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
    }

    private ScreenContext getScreenContext() {
        return this.cm.paintContext;
    }

    public void setZeroYLoc(int n, boolean bl, boolean bl2) {
        ScreenContext screenContext = this.getScreenContext();
        ChannelInfo channelInfo = this.wfi.ci;
        channelInfo.c_setZero(n, bl);
        if (bl2) {
            this.resetNormalIntBuf(screenContext);
        }
    }

    public void updateVBMulti(int n) {
        this.vbmulti = this.cm.getMachineInfo().getVoltagesBDRatioBetween(this.basevbidx, n);
    }

    public void resetVbmulti() {
        this.vbmulti = BigDecimal.valueOf(1L);
    }

    public void saveFirstLoadPos0() {
        this.loadPos0 = this.wfi.ci.getPos0();
    }

    public BigDecimal getVbmulti() {
        return this.vbmulti;
    }

    public int getYb(ScreenContext screenContext) {
        int n = screenContext.getHcenter();
        int n2 = this.getPos0ForADC();
        boolean bl = screenContext.isScreenMode_3();
        int n3 = bl ? n - n2 + (int)((double)this.loadPos0 * this.getVbmulti().doubleValue()) : n - (n2 << 1) + (int)((double)(this.loadPos0 << 1) * this.getVbmulti().doubleValue());
        return n3;
    }

    public void releaseRT() {
        this.rtlim.releaseRTLI();
    }

    private void resetNormalIntBuf(ScreenContext screenContext) {
        this.rtlim.resetIntBuf(this.getVbmulti(), this.getYb(screenContext), screenContext.isScreenMode_3());
    }

    @Override
    public void adjustView(ScreenContext screenContext, Rectangle rectangle) {
        if (!screenContext.allowLazyRepaint()) {
            this.resetNormalIntBuf(screenContext);
        }
    }

    @Override
    public int getFirstLoadPos0() {
        return this.loadPos0;
    }

    public void paintItem(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle, ControlManager controlManager, boolean bl) {
        int n = this.getPos0onChart(screenContext);
        this.paintItem(graphics2D, screenContext, rectangle, controlManager, bl, n);
    }

    private void paintItem(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle, ControlManager controlManager, boolean bl, int n) {
        if (!this.isOn()) {
            return;
        }
        if (controlManager.mathControl.isMathChannelUse(this.wfi.ci.getNumber())) {
            return;
        }
        ChannelInfo channelInfo = this.wfi.ci;
        graphics2D.setColor(this.getColor());
        int n2 = rectangle.y;
        int n3 = rectangle.y + rectangle.height;
        LineUtil.paintChannelLabel(n, n2, n3, graphics2D, String.valueOf(channelInfo.getNumber() + 1), 2, bl);
        if (this.onShowPos0) {
            LineUtil.paintOnShowPos0(graphics2D, screenContext, this.dh.divUnits, channelInfo.getPos0(), n, rectangle);
        }
    }

    @Override
    public void paintView(Graphics2D graphics2D, ScreenContext screenContext, Rectangle rectangle) {
        if (!this.isOn()) {
            return;
        }
        if (this.cm.mathControl.isMathChannelUse(this.wfi.ci.getNumber())) {
            return;
        }
        boolean bl = this.dh.isLineLink();
        graphics2D.setColor(this.getColor());
        int n = rectangle.x;
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(rectangle);
        WFTimeScopeControl wFTimeScopeControl = this.dh.getWaveFormManager().getWFTimeScopeControl();
        boolean bl2 = wFTimeScopeControl.isPK_Detect();
        int n2 = wFTimeScopeControl.getDrawMode();
        n = wFTimeScopeControl.useCommonXboff() ? wFTimeScopeControl.computeXoffset(n, n2) : (n += this.dm_xoffset);
        this.rtlim.paintKinds(graphics2D, n2, n, bl, rectangle, bl2, wFTimeScopeControl, screenContext);
        graphics2D.setClip(shape);
    }

    public void setDm_xoffset(int n) {
        this.dm_xoffset = n;
    }

    public void doubleClickOnLevel() {
        this.setTrg50Percent(this.cm.getTriggerControl());
    }

    public void setTrg50Percent(TriggerControl triggerControl) {
        if (!this.cm.is50percentAvailable()) {
            return;
        }
        TriggerSet triggerSet = triggerControl.getTriggerSetOrNull(this.wfi.ci.getNumber());
        if (triggerSet == null || !triggerSet.isVoltsenseSupport()) {
            return;
        }
        int n = this.rtlim.getTrg50percentValue();
        if (n == Integer.MAX_VALUE) {
            return;
        }
        VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)triggerSet.getTrigger();
        boolean bl = voltsensableTrigger.c_setVoltsense(n);
        if (bl) {
            triggerControl.getVTPatchable().submiteVoltsense(this.getChannelNumber(), voltsensableTrigger);
        }
        this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        this.cm.pcs.firePropertyChange("UpdateVoltsense", -1, this.getChannelNumber());
    }

    public void setTrgEdgeMiddle(TriggerControl triggerControl) {
        TriggerSet triggerSet = triggerControl.getTriggerSetOrNull(this.wfi.ci.getNumber());
        if (triggerSet == null || !triggerSet.isCurrentTrigger_Edge()) {
            return;
        }
        int n = this.rtlim.getTrg50percentValue();
        if (n == Integer.MAX_VALUE) {
            return;
        }
        VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)triggerSet.getTrigger();
        int n2 = voltsensableTrigger.c_getVoltsense();
        if (Math.abs(n2 - n) < 5) {
            return;
        }
        boolean bl = voltsensableTrigger.c_setVoltsense(n);
        if (bl) {
            triggerControl.getVTPatchable().submiteVoltsense(this.getChannelNumber(), voltsensableTrigger);
        }
        this.cm.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        this.cm.pcs.firePropertyChange("UpdateVoltsense", -1, this.getChannelNumber());
    }

    public int getTrg50Percent() {
        if (!this.cm.is50percentAvailable()) {
            return Integer.MAX_VALUE;
        }
        int n = this.rtlim.getTrg50percentValue();
        return n;
    }
}

