/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.wf;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.function.Markable;
import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.DataHouse;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.source.comm.effect.SubmitorFactory;
import com.owon.uppersoft.dso.view.MainWindow;
import com.owon.uppersoft.dso.wf.IChannelInfo;
import com.owon.uppersoft.dso.wf.WaveForm;
import com.owon.uppersoft.vds.core.aspect.base.IOrgan;
import com.owon.uppersoft.vds.core.aspect.control.Pos0_VBChangeInfluence;
import com.owon.uppersoft.vds.core.aspect.control.VoltageProvider;
import com.owon.uppersoft.vds.core.comm.effect.P_Channel;
import com.owon.uppersoft.vds.core.comm.effect.Submitable;
import com.owon.uppersoft.vds.core.machine.MachineType;
import com.owon.uppersoft.vds.core.wf.dm.DMDataInfo;
import com.owon.uppersoft.vds.util.Pref;
import com.owon.uppersoft.vds.util.format.UnitConversionUtil;
import java.awt.Color;

public class ChannelInfo
implements IOrgan,
IChannelInfo,
Markable {
    public static final LObject[] COUPLING = new LObject[]{new LObject("M.Channel.Coupling.DC"), new LObject("M.Channel.Coupling.AC"), new LObject("M.Channel.Coupling.Ground")};
    public static final String[] COUPLINGCHARS = new String[]{"DC", "AC", "Gnd"};
    public static final int CouplingDCIndex = 0;
    public static final int CouplingACIndex = 1;
    public static final int CouplingGroundIndex = 2;
    private boolean on = false;
    private int probeMultiIdx = 0;
    private int couplingIdx = 0;
    private int vbIdx;
    private int pos0;
    private int number;
    private String name;
    public Color color;
    private int filterIdx = 0;
    private boolean bandlimit = false;
    private boolean inverse = false;
    public Volt[] VOLTAGEs;
    private float freq;
    private String freqtxt;
    private VoltageProvider vp;
    private Pos0_VBChangeInfluence pvi;
    private transient int amperePerVolt;
    private transient boolean measureCurrent;
    private String probeLabel;
    private int pos0HalfRange;
    double period;

    public VoltageProvider getVoltageProvider() {
        return this.vp;
    }

    public ChannelInfo(int n, VoltageProvider voltageProvider, Pos0_VBChangeInfluence pos0_VBChangeInfluence) {
        this.setNumber(n);
        this.vp = voltageProvider;
        this.pvi = pos0_VBChangeInfluence;
        this.setName("CH" + (n + 1));
        int n2 = voltageProvider.getVoltageNumber();
        this.VOLTAGEs = new Volt[n2];
        for (int i = 0; i < n2; ++i) {
            this.VOLTAGEs[i] = new Volt(i);
        }
    }

    public int getValidVotageChangeIndex(int n) {
        int n2 = n;
        if (n < 0) {
            n2 = 0;
        }
        if (n >= this.vp.getVoltageNumber()) {
            n2 = this.vp.getVoltageNumber() - 1;
        }
        return n2;
    }

    @Override
    public void load(Pref pref) {
        int n = pref.loadInt(this.getName() + ".vbIdx");
        if (n < 0 || n >= this.vp.getVoltageNumber()) {
            n = 0;
        }
        this.setPos0(pref.loadInt(this.getName() + ".pos0"));
        this.setVoltbaseIndex(n, true, true);
        this.setOn(pref.loadBoolean(this.getName() + ".on"));
        int n2 = pref.loadInt(this.getName() + ".probeMultiIdx");
        this.setProbeMultiIdx(n2);
        this.setCouplingIdx(pref.loadInt(this.getName() + ".couplingIdx"));
        this.color = pref.loadColor(this.getName() + ".rgb");
        this.setBandlimit(pref.loadBoolean(this.getName() + ".bandlimit"));
        this.inverse = pref.loadBoolean(this.getName() + ".inverse");
        this.setMeasureCurrent(pref.loadBoolean(this.getName() + ".measureCurrentOn"));
        this.setAmperePerVolt(pref.loadInt(this.getName() + ".amperePerVolt", 10000));
        this.setFilterIdx(pref.loadInt(this.getName() + ".filterIdx", 0));
    }

    @Override
    public void persist(Pref pref) {
        pref.persistInt(this.getName() + ".vbIdx", this.getVoltbaseIndex());
        pref.persistInt(this.getName() + ".pos0", this.getPos0());
        pref.persistBoolean(this.getName() + ".on", this.isOn());
        pref.persistInt(this.getName() + ".probeMultiIdx", this.probeMultiIdx);
        pref.persistInt(this.getName() + ".couplingIdx", this.getCouplingIdx());
        pref.persistColor(this.getName() + ".rgb", this.color);
        pref.persistBoolean(this.getName() + ".bandlimit", this.isBandlimit());
        pref.persistBoolean(this.getName() + ".inverse", this.inverse);
        pref.persistBoolean(this.getName() + ".measureCurrentOn", this.isMeasureCurrent());
        pref.persistInt(this.getName() + ".amperePerVolt", this.getAmperePerVolt());
        pref.persistInt(this.getName() + ".filterIdx", this.filterIdx);
    }

    @Override
    public boolean isGround() {
        return this.getCouplingIdx() == 2;
    }

    public Volt[] getVoltageLabels() {
        return this.VOLTAGEs;
    }

    @Override
    public int getPos0() {
        return this.pos0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPos0byRange(int n) {
        return n - this.getPos0();
    }

    public int getInverseValue(int n) {
        if (this.inverse) {
            return ChannelInfo.getLevelFromPos0(n, this.getPos0());
        }
        return n;
    }

    @Override
    public void setProbeMultiIdx(int n) {
        this.probeMultiIdx = n;
        this.probeLabel = this.getProbeLabelForUse(n);
    }

    public static String getProbeLabel(VoltageProvider voltageProvider, int n) {
        return "x" + voltageProvider.getProbeMulties()[n];
    }

    public String getProbeLabelForUse(int n) {
        return ChannelInfo.getProbeLabel(this.vp, n);
    }

    public void setNextProbeMultiIdx() {
        int n = (this.probeMultiIdx + 1) % this.vp.getProbeMulties().length;
        this.setProbeMultiIdx(n);
    }

    @Override
    public int getProbeMultiIdx() {
        return this.probeMultiIdx;
    }

    public String getProbeLabel() {
        return this.probeLabel;
    }

    public Volt getVoltageLabel() {
        return this.getVoltageLabels()[this.getVoltbaseIndex()];
    }

    @Override
    public double getVoltValue() {
        return this.getVoltageLabel().getValue();
    }

    public void updateFreqLabel(float f) {
        this.setFreq(f);
        if (f < 0.0f) {
            this.setFreqtxt("?");
        } else if (f >= 0.0f && f < 2.0f) {
            this.setFreqtxt("<2Hz");
        } else {
            MachineType machineType = Platform.getControlManager().getMachine();
            this.setFreqtxt(UnitConversionUtil.getSimplifiedFrequencyLabel_Hz2(f));
        }
    }

    public void c_forceBandLimit(boolean bl) {
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_chl(P_Channel.BANDLIMIT, this.getNumber(), bl ? 1 : 0);
        submitable.apply();
    }

    @Override
    public void c_setBandLimit(boolean bl) {
        this.setBandlimit(bl);
        this.c_forceBandLimit(this.isBandlimit());
    }

    public void setBandlimit(boolean bl) {
        this.bandlimit = bl;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    @Override
    public void c_setInverse(boolean bl) {
        if (this.inverse == bl) {
            return;
        }
        this.inverse = bl;
    }

    @Override
    public int getFilterIdx() {
        return this.filterIdx;
    }

    @Override
    public void setFilterIdx(int n) {
        this.filterIdx = n;
    }

    @Override
    public double getFilter() {
        if (this.filterIdx == 0) {
            return 0.0;
        }
        return (Math.pow(1.05, this.filterIdx) - 1.0) / 248.47858637391238;
    }

    public String getFilterLabel() {
        if (this.filterIdx == 0) {
            return "--";
        }
        ControlManager controlManager = Platform.getControlManager();
        double d = this.getFilter();
        double d2 = controlManager.getTimeControl().getBDTimebase().doubleValue();
        double d3 = d2 * 20.0;
        double d4 = 1.0 / (d3 * d);
        String string = UnitConversionUtil.getSimplifiedFrequencyLabel_Hz2(d4);
        return String.format("  %.2f%%    %s", d * 100.0, string);
    }

    @Override
    public void c_setOn(boolean bl) {
        DataHouse dataHouse = Platform.getDataHouse();
        ControlManager controlManager = dataHouse.controlManager;
        this.setOnWithoutSync(bl);
        Submitable submitable = SubmitorFactory.reInit();
        this.c_SyncChannel(submitable);
        submitable.apply();
        submitable = SubmitorFactory.reInit();
        controlManager.getTriggerControl().selfSubmit();
        submitable.apply_trgThen(controlManager.getResetPersistenceRunnable());
        controlManager.getCoreControl().updateCurrentSampleRate();
        controlManager.fire_RefreshMeasureResult();
    }

    @Override
    public void c_SyncChannel(Submitable submitable) {
        int n = this.getNumber();
        submitable.recommendOptimize();
        submitable.c_chl(P_Channel.ONOFF, n, this.isOn() ? 1 : 0);
        submitable.c_chl(P_Channel.COUPLING, n, this.getCouplingIdx());
        submitable.c_chl(P_Channel.VB, n, this.getVoltbaseIndex());
        submitable.c_chl(P_Channel.POS0, n, this.getPos0());
        submitable.c_chl(P_Channel.BANDLIMIT, n, this.isBandlimit() ? 1 : 0);
    }

    @Override
    public void setOnWithoutSync(boolean bl) {
        this.setOn(bl);
    }

    @Override
    public void c_setCoupling(int n) {
        this.setCouplingIdx(n);
        Submitable submitable = SubmitorFactory.reInit();
        submitable.c_chl(P_Channel.COUPLING, this.getNumber(), this.getCouplingIdx());
        submitable.apply();
    }

    public void c_setNextCoupling() {
        int n = (this.getCouplingIdx() + 1) % COUPLING.length;
        this.c_setCoupling(n);
    }

    @Override
    public void c_setVoltage(int n, final Runnable runnable) {
        int n2 = this.getValidVotageChangeIndex(n);
        if (n2 < 0) {
            return;
        }
        final int n3 = this.getVoltbaseIndex();
        final int n4 = n2;
        this.setVoltbaseIndex(n2, false, false);
        if (this.shouldForcebandlimit(n4)) {
            this.c_forceBandLimit(true);
            this.pvi.notifyChannelUpdate();
        } else if (this.shouldForcebandlimit(n3)) {
            this.c_forceBandLimit(this.isBandlimit());
            this.pvi.notifyChannelUpdate();
        }
        Submitable submitable = SubmitorFactory.reInit();
        final int n5 = this.getNumber();
        final int n6 = this.getPos0();
        submitable.d_chl_vb(this.getNumber(), this.getVoltbaseIndex(), new Runnable(){

            @Override
            public void run() {
                ChannelInfo.this.pvi.thredshold_voltsense_ByVoltBase(n5, n6, n3, n4, new Runnable(){

                    @Override
                    public void run() {
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                }, n6);
            }
        });
    }

    @Override
    public void c_setZero(int n, boolean bl) {
        int n2 = this.getPos0();
        int n3 = this.getHalfPosRange();
        if (n < -n3) {
            n = -n3;
        } else if (n > n3) {
            n = n3;
        }
        int n4 = n;
        int n5 = n4 - n2;
        this.setPos0(n);
        int n6 = this.getNumber();
        final Runnable runnable = this.pvi.thredshold_voltsense_ByPos0(n6, n5, bl);
        if (bl) {
            Submitable submitable = SubmitorFactory.reInit();
            submitable.d_chl_pos0(this.getNumber(), this.getPos0(), new Runnable(){

                @Override
                public void run() {
                    if (runnable != null) {
                        runnable.run();
                    }
                    ChannelInfo.this.pvi.resetPersistence();
                }
            });
        }
    }

    public static final int getLevelFromPos0(int n, int n2) {
        return n2 - (n - n2);
    }

    public int getLevelOnScreen(int n) {
        if (this.isInverse()) {
            return ChannelInfo.getLevelFromPos0(n, this.pos0);
        }
        return n;
    }

    public void snapShot2ChannelDataInfo(DMDataInfo dMDataInfo, WaveForm waveForm) {
        dMDataInfo.pos0 = waveForm.getFirstLoadPos0();
        dMDataInfo.vbIdx = this.getVoltbaseIndex();
        dMDataInfo.probeMultiIdx = this.getProbeMultiIdx();
        dMDataInfo.setFreq(this.getFreq());
    }

    public int getHalfPosRange() {
        return this.pos0HalfRange;
    }

    @Override
    public int getVoltbaseIndex() {
        return this.vbIdx;
    }

    public void setVoltbaseIndex(int n, boolean bl, boolean bl2) {
        this.vbIdx = n;
        Volt volt = this.getVoltageLabel();
        int n2 = volt.getValue(0);
        this.pos0HalfRange = this.vp.getPos0HalfRange(n2);
        if (!bl) {
            return;
        }
        DataHouse dataHouse = Platform.getDataHouse();
        if (dataHouse == null || bl2) {
            return;
        }
        WaveFormManager waveFormManager = dataHouse.getWaveFormManager();
        WaveForm waveForm = waveFormManager.getWaveForm(this.getNumber());
        MainWindow mainWindow = dataHouse.getWorkBench().getMainWindow();
        waveFormManager.setZeroYLoc(waveForm, this.getPos0(), true);
        mainWindow.getToolPane().getInfoPane().updatePos0(this.getNumber());
    }

    public void setOn(boolean bl) {
        this.on = bl;
    }

    @Override
    public boolean isOn() {
        return this.on;
    }

    public void setCouplingIdx(int n) {
        this.couplingIdx = n;
    }

    @Override
    public int getCouplingIdx() {
        return this.couplingIdx;
    }

    public void setPos0(int n) {
        this.pos0 = n;
    }

    @Override
    public boolean isForcebandlimit() {
        return this.shouldForcebandlimit(this.vbIdx);
    }

    private boolean shouldForcebandlimit(int n) {
        return n == 0;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    void setName(String string) {
        this.name = string;
    }

    void setNumber(int n) {
        this.number = n;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public double getPeriod() {
        return this.period;
    }

    void setFreq(float f) {
        this.freq = f;
        this.period = 1000000.0f / f;
    }

    public float getFreq() {
        return this.freq;
    }

    void setFreqtxt(String string) {
        this.freqtxt = string;
    }

    public String getFreqtxt() {
        return this.freqtxt;
    }

    @Override
    public boolean isBandlimit() {
        if (this.isForcebandlimit()) {
            return true;
        }
        return this.bandlimit;
    }

    @Override
    public boolean isMeasureCurrent() {
        return this.measureCurrent;
    }

    @Override
    public void setMeasureCurrent(boolean bl) {
        this.measureCurrent = bl;
    }

    @Override
    public int getAmperePerVolt() {
        return this.amperePerVolt;
    }

    @Override
    public void setAmperePerVolt(int n) {
        this.amperePerVolt = n;
    }

    @Override
    public String getValueLabel(double d) {
        if (this.measureCurrent) {
            double d2 = d / 1000.0 * (double)this.amperePerVolt;
            return UnitConversionUtil.getAmpererLabel_mA(d2);
        }
        return UnitConversionUtil.getSimplifiedVoltLabel_mV(d);
    }

    public String getValueLabel(int n) {
        if (this.measureCurrent) {
            double d = (double)n / 1000.0 * (double)this.amperePerVolt;
            return UnitConversionUtil.getAmpererLabel_mA(d);
        }
        return UnitConversionUtil.getIntVoltageLabel_mV(n);
    }

    public class Volt {
        public int idx;

        public Volt(int n) {
            this.idx = n;
        }

        public String getLabel(int n) {
            return ChannelInfo.this.getValueLabel(this.getValue(n));
        }

        public int getValue(int n) {
            return ChannelInfo.this.vp.getVoltage(n, this.idx);
        }

        public int getValue() {
            return this.getValue(ChannelInfo.this.probeMultiIdx);
        }

        public String toString() {
            return this.getLabel(ChannelInfo.this.probeMultiIdx);
        }
    }
}

