/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.global.ControlManager;
import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.TriggerUIInfo;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.ui.slider.SliderAdapter;

public class VoltSliderAdapter
extends SliderAdapter {
    private TriggerControl trgc;
    private ChannelInfo ci;
    private int halfRange;
    private VoltsensableTrigger vt;

    public VoltSliderAdapter(TriggerControl triggerControl, ChannelInfo channelInfo, int n, VoltsensableTrigger voltsensableTrigger) {
        this.trgc = triggerControl;
        this.ci = channelInfo;
        this.halfRange = n;
        this.vt = voltsensableTrigger;
    }

    @Override
    public void on50percent() {
        TriggerUIInfo triggerUIInfo = this.trgc.getTriggerUIInfo();
        TriggerSet triggerSet = triggerUIInfo.getCurrentTriggerSet();
        if (this.vt instanceof VoltsensableTrigger) {
            WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
            waveFormManager.getWaveForm(this.ci.getNumber()).setTrg50Percent(this.trgc);
        }
    }

    @Override
    public void valueChanged(int n, int n2) {
        int n3 = n2;
        n3 = this.halfRange - n3;
        boolean bl = this.vt.c_setVoltsense(n3 = this.ci.getInverseValue(n3));
        if (bl) {
            this.trgc.getVTPatchable().submiteVoltsense(this.ci.getNumber(), this.vt);
        }
        ControlManager controlManager = Platform.getControlManager();
        controlManager.pcs.firePropertyChange("REPAINT_CHARTSCREEN", null, null);
        controlManager.pcs.firePropertyChange("UpdateVoltsense", -1, this.ci.getNumber());
    }

    @Override
    public void onDispose() {
        Platform.getMainWindow().update_DoneVoltsense();
    }
}

