/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.global.Platform;
import com.owon.uppersoft.dso.i18n.I18nProvider;
import com.owon.uppersoft.dso.model.WaveFormManager;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerControl;
import com.owon.uppersoft.dso.model.trigger.TriggerSet;
import com.owon.uppersoft.dso.model.trigger.VoltsensableTrigger;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.VoltSliderAdapter;
import com.owon.uppersoft.dso.wf.ChannelInfo;
import com.owon.uppersoft.vds.data.Point;
import com.owon.uppersoft.vds.ui.slider.SliderBarLocation;
import com.owon.uppersoft.vds.ui.slider.SymmetrySliderBar;
import com.owon.uppersoft.vds.ui.window.WindowUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class VoltLevelMouseAdapter
extends MouseAdapter
implements SliderBarLocation {
    private TriggerLoaderPane ep;
    private TriggerControl trgc;
    private int halfRange;

    public VoltLevelMouseAdapter(TriggerLoaderPane triggerLoaderPane, TriggerControl triggerControl, int n) {
        this.ep = triggerLoaderPane;
        this.trgc = triggerControl;
        this.halfRange = n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            TriggerSet triggerSet = this.trgc.getTriggerSetOrNull(this.ep.getChannel());
            if (triggerSet == null || !triggerSet.isVoltsenseSupport()) {
                return;
            }
            WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
            waveFormManager.getWaveForm(this.ep.getChannel()).doubleClickOnLevel();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        AbsTrigger absTrigger = this.ep.getTrigger();
        if (!(absTrigger instanceof VoltsensableTrigger)) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.getSliderBarLocation(n, n2, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getComponent());
        int n3 = this.halfRange;
        int n4 = this.ep.getChannel();
        WaveFormManager waveFormManager = Platform.getDataHouse().getWaveFormManager();
        ChannelInfo channelInfo = waveFormManager.getWaveForm((int)n4).wfi.ci;
        int n5 = channelInfo.getPos0byRange(n3);
        VoltsensableTrigger voltsensableTrigger = (VoltsensableTrigger)absTrigger;
        int n6 = channelInfo.getInverseValue(voltsensableTrigger.c_getVoltsense());
        SymmetrySliderBar.createSymmetrySliderFrame(WindowUtil.getWindow(mouseEvent), point.x, point.y, n3, n5, n3 - n6, true, channelInfo.getColor(), 3, new VoltSliderAdapter(this.trgc, channelInfo, this.halfRange, voltsensableTrigger), I18nProvider.bundle());
        Platform.getMainWindow().update_ChangeVoltsense(n4);
    }

    @Override
    public Point getSliderBarLocation(int n, int n2, int n3, int n4, Component component) {
        int n5 = component.getWidth();
        n = n5 + n3 - n + 5;
        n2 = n4 - n2 - 178 + 20;
        return new Point(n, n2);
    }
}

