/*
 * Decompiled with CFR 0.152.
 */
package com.owon.uppersoft.dso.view.trigger;

import com.owon.uppersoft.dso.data.LObject;
import com.owon.uppersoft.dso.model.trigger.AbsTrigger;
import com.owon.uppersoft.dso.model.trigger.TriggerDefine;
import com.owon.uppersoft.dso.model.trigger.VideoTrigger;
import com.owon.uppersoft.dso.model.trigger.helper.ETV_Holdoff;
import com.owon.uppersoft.dso.model.trigger.helper.LabelValueUnitContactor;
import com.owon.uppersoft.dso.model.trigger.holdoff.HoldoffSpinnerModel;
import com.owon.uppersoft.dso.view.trigger.TriggerLoaderPane;
import com.owon.uppersoft.dso.view.trigger.TriggerPane;
import com.owon.uppersoft.dso.widget.custom.effect.LabelValueUnitPane;
import com.owon.uppersoft.vds.core.trigger.help.EnumNValue;
import com.owon.uppersoft.vds.ui.widget.CNumberSpinner;
import com.owon.uppersoft.vds.ui.widget.custom.CComboBox;
import com.owon.uppersoft.vds.ui.widget.custom.CLabel;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VideoPane
extends TriggerLoaderPane
implements ItemListener,
ChangeListener {
    private JSpinner spinner_sync;
    private CComboBox cbbsync;
    private CComboBox cbbmodule;
    private SpinnerNumberModel syncspin;
    private HoldoffSpinnerModel hospin;
    private LabelValueUnitPane vup;
    private CLabel cl;
    private boolean listening = false;
    private LabelValueUnitContactor lvuc;

    @Override
    public void loadTrigger(int n) {
        this.setChannel(n);
        this.listening = false;
        VideoTrigger videoTrigger = this.getTrigger();
        this.cbbmodule.setSelectedIndex(videoTrigger.module);
        this.resetMax(videoTrigger);
        this.cbbsync.setSelectedIndex(videoTrigger.sync);
        this.spinner_sync.setEnabled(videoTrigger.isSyncValueEnable());
        this.hospin.setValue(videoTrigger.etvho);
        this.lvuc.updateStepIndex(videoTrigger.etvho.getStepIndex());
        this.syncspin.setValue(new Long(videoTrigger.syncValue));
        this.listening = true;
    }

    @Override
    public AbsTrigger submitTrigger() {
        VideoTrigger videoTrigger = this.getTrigger();
        videoTrigger.etvho.set((EnumNValue)this.hospin.getValue());
        videoTrigger.module = this.cbbmodule.getSelectedIndex();
        videoTrigger.sync = this.cbbsync.getSelectedIndex();
        videoTrigger.syncValue = ((Number)this.syncspin.getValue()).intValue();
        return videoTrigger;
    }

    @Override
    public VideoTrigger getTrigger() {
        return this.getTriggerPane().curTrgSet().video;
    }

    public VideoPane(TriggerPane triggerPane) {
        super(triggerPane);
        this.nrip();
        this.cbbmodule = new CComboBox();
        this.ip.add(this.cbbmodule);
        this.syncspin = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                Object object = super.getNextValue();
                if (object != null) {
                    return object;
                }
                return this.getMinimum();
            }

            @Override
            public Object getPreviousValue() {
                Object object = super.getPreviousValue();
                if (object != null) {
                    return object;
                }
                return this.getMaximum();
            }
        };
        this.syncspin.setStepSize(new Long(1L));
        this.syncspin.setMaximum(new Long(525L));
        this.syncspin.setMinimum(new Long(1L));
        ETV_Holdoff eTV_Holdoff = this.getTrigger().etvho;
        this.hospin = new HoldoffSpinnerModel(eTV_Holdoff);
        this.nrip();
        this.cbbsync = new CComboBox();
        this.ip.add(this.cbbsync);
        this.spinner_sync = new CNumberSpinner(this.syncspin);
        new SpinnerMouseWheelSupport(this.spinner_sync);
        this.spinner_sync.setPreferredSize(new Dimension(60, 25));
        this.ip.add(this.spinner_sync);
        this.cl = new CLabel();
        this.cl.setPreferredSize(new Dimension(80, 25));
        this.ip.add(this.cl);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(TriggerDefine.HOLDOFF_STEP_TIME_UNIT);
        this.vup = new LabelValueUnitPane("", this.hospin, defaultComboBoxModel);
        this.lvuc = new LabelValueUnitContactor(new TriggerLoaderPane.HoldoffValueChange(), this.vup.comboBox, this.vup.spinner);
        this.nrip().add(this.vup);
        this.cbbsync.setModel(new DefaultComboBoxModel<LObject>(VideoTrigger.SYNC));
        this.cbbmodule.setModel(new DefaultComboBoxModel<String>(VideoTrigger.MODULE));
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        this.spinner_sync.addChangeListener(this);
        this.cbbsync.addItemListener(this);
        this.cbbmodule.addItemListener(this);
        this.listening = true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.listening) {
            return;
        }
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.cbbsync) {
            int n = this.cbbsync.getSelectedIndex();
            VideoTrigger videoTrigger = this.getTrigger();
            videoTrigger.sync = n;
            this.spinner_sync.setEnabled(videoTrigger.isSyncValueEnable());
            this.bodySend();
            this.getTriggerPane().updateTrgVoltPane();
            return;
        }
        if (itemEvent.getSource() == this.cbbmodule) {
            int n = this.cbbmodule.getSelectedIndex();
            VideoTrigger videoTrigger = this.getTrigger();
            videoTrigger.module = n;
            this.resetMax(videoTrigger);
            this.bodySend();
            return;
        }
    }

    protected void resetMax(VideoTrigger videoTrigger) {
        int n = videoTrigger.module;
        if (n != 0) {
            this.syncspin.setMaximum(Long.valueOf(625L));
            this.cl.setText(" <= 625");
        } else {
            this.syncspin.setMaximum(Long.valueOf(525L));
            this.cl.setText(" <= 525");
            int n2 = ((Number)this.syncspin.getValue()).intValue();
            if (n2 > 525) {
                this.syncspin.setValue(525L);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listening) {
            return;
        }
        if (changeEvent.getSource() == this.spinner_sync) {
            VideoTrigger videoTrigger = this.getTrigger();
            int n = ((Number)this.syncspin.getValue()).intValue();
            if (videoTrigger.syncValue != n) {
                videoTrigger.syncValue = n;
                this.bodySend();
            }
            this.getTriggerPane().updateTrgVoltPane();
            return;
        }
    }

    @Override
    public void localize(ResourceBundle resourceBundle) {
        this.vup.setLabel(resourceBundle.getString("M.Trg.Holdoff") + ": ");
        boolean bl = this.listening;
        this.listening = false;
        this.cbbsync.setSelectedItem(this.cbbsync.getSelectedItem());
        this.cbbsync.repaint();
        this.cbbmodule.setSelectedItem(this.cbbmodule.getSelectedItem());
        this.listening = bl;
    }

    @Override
    public void bodySend() {
        this.getTriggerPane().bodySend();
    }

    @Override
    public void fireProperty(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("NextStatus")) {
            this.listening = false;
            VideoTrigger videoTrigger = this.getTrigger();
            this.cbbsync.setSelectedIndex(videoTrigger.sync);
            this.spinner_sync.setEnabled(videoTrigger.isSyncValueEnable());
            this.spinner_sync.setValue(new Long(videoTrigger.syncValue));
            this.listening = true;
            return;
        }
        if (string.equals("updateVideoMod")) {
            this.listening = false;
            this.cbbmodule.setSelectedIndex(this.getTrigger().module);
            this.listening = true;
        }
    }

    class SpinnerMouseWheelSupport
    implements MouseWheelListener {
        private JSpinner js;

        public SpinnerMouseWheelSupport(JSpinner jSpinner) {
            this.js = jSpinner;
            jSpinner.addMouseWheelListener(this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!this.js.isFocusable()) {
                return;
            }
            int n = mouseWheelEvent.getWheelRotation();
            if (n < 0) {
                this.js.setValue(this.js.getNextValue());
            } else {
                this.js.setValue(this.js.getPreviousValue());
            }
        }
    }
}

